/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JakartaWrapper;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import javax.jms.Session;

public class JakartaSession<T extends Session>
implements jakarta.jms.Session,
JakartaWrapper<T> {
    private final T delegate;

    JakartaSession(T delegate) {
        this.delegate = delegate;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createBytesMessage()));
    }

    public MapMessage createMapMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createMapMessage()));
    }

    public Message createMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createMessage()));
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createObjectMessage()));
    }

    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createObjectMessage(object)));
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createStreamMessage()));
    }

    public TextMessage createTextMessage() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createTextMessage()));
    }

    public TextMessage createTextMessage(String text) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createTextMessage(text)));
    }

    public boolean getTransacted() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getTransacted());
    }

    public int getAcknowledgeMode() throws JMSException {
        return ShimUtil.call(() -> this.delegate.getAcknowledgeMode());
    }

    public void commit() throws JMSException {
        ShimUtil.run(() -> this.delegate.commit());
    }

    public void rollback() throws JMSException {
        ShimUtil.run(() -> this.delegate.rollback());
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> this.delegate.close());
    }

    public void recover() throws JMSException {
        ShimUtil.run(() -> this.delegate.recover());
    }

    public MessageListener getMessageListener() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.getMessageListener()));
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        ShimUtil.run(() -> this.delegate.setMessageListener(JavaxJms.create(listener)));
    }

    public void run() {
        this.delegate.run();
    }

    public MessageProducer createProducer(Destination destination) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createProducer(ShimUtil.destination(destination))));
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createConsumer(ShimUtil.destination(destination))));
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createConsumer(ShimUtil.destination(destination), messageSelector)));
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createConsumer(ShimUtil.destination(destination), messageSelector, noLocal)));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createSharedConsumer(ShimUtil.topic(topic), sharedSubscriptionName)));
    }

    public MessageConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createSharedConsumer(ShimUtil.topic(topic), sharedSubscriptionName, messageSelector)));
    }

    public Queue createQueue(String queueName) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createQueue(queueName)));
    }

    public Topic createTopic(String topicName) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createTopic(topicName)));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createDurableSubscriber(ShimUtil.topic(topic), name)));
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createDurableSubscriber(ShimUtil.topic(topic), name, messageSelector, noLocal)));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createDurableConsumer(ShimUtil.topic(topic), name)));
    }

    public MessageConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createDurableConsumer(ShimUtil.topic(topic), name, messageSelector, noLocal)));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createSharedDurableConsumer(ShimUtil.topic(topic), name)));
    }

    public MessageConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createSharedDurableConsumer(ShimUtil.topic(topic), name, messageSelector)));
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createBrowser(ShimUtil.queue(queue))));
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createBrowser(ShimUtil.queue(queue), messageSelector)));
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createTemporaryQueue()));
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.createTemporaryTopic()));
    }

    public void unsubscribe(String name) throws JMSException {
        ShimUtil.run(() -> this.delegate.unsubscribe(name));
    }

    @Override
    public T unwrap() {
        return this.delegate;
    }
}

