/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaMessage;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSException;
import jakarta.jms.StreamMessage;

class JakartaStreamMessage
extends JakartaMessage
implements StreamMessage {
    private final javax.jms.StreamMessage delegate;

    JakartaStreamMessage(javax.jms.StreamMessage delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public boolean readBoolean() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readBoolean());
    }

    public byte readByte() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readByte());
    }

    public short readShort() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readShort());
    }

    public char readChar() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readChar()).charValue();
    }

    public int readInt() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readInt());
    }

    public long readLong() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readLong());
    }

    public float readFloat() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readFloat()).floatValue();
    }

    public double readDouble() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readDouble());
    }

    public String readString() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readString());
    }

    public int readBytes(byte[] value) throws JMSException {
        return ShimUtil.call(() -> this.delegate.readBytes(value));
    }

    public Object readObject() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.StreamMessage)this.delegate).readObject());
    }

    public void writeBoolean(boolean value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBoolean(value));
    }

    public void writeByte(byte value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeByte(value));
    }

    public void writeShort(short value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeShort(value));
    }

    public void writeChar(char value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeChar(value));
    }

    public void writeInt(int value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeInt(value));
    }

    public void writeLong(long value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeLong(value));
    }

    public void writeFloat(float value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeFloat(value));
    }

    public void writeDouble(double value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeDouble(value));
    }

    public void writeString(String value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeString(value));
    }

    public void writeBytes(byte[] value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBytes(value));
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeBytes(value, offset, length));
    }

    public void writeObject(Object value) throws JMSException {
        ShimUtil.run(() -> this.delegate.writeObject(value));
    }

    public void reset() throws JMSException {
        ShimUtil.run(() -> ((javax.jms.StreamMessage)this.delegate).reset());
    }
}

