/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import io.helidon.messaging.connectors.jms.shim.JavaxJms;
import io.helidon.messaging.connectors.jms.shim.ShimUtil;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;

class JakartaTopicSubscriber
implements TopicSubscriber {
    private final javax.jms.TopicSubscriber delegate;

    JakartaTopicSubscriber(javax.jms.TopicSubscriber delegate) {
        this.delegate = delegate;
    }

    public Topic getTopic() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).getTopic()));
    }

    public boolean getNoLocal() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).getNoLocal());
    }

    public String getMessageSelector() throws JMSException {
        return ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).getMessageSelector());
    }

    public MessageListener getMessageListener() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).getMessageListener()));
    }

    public void setMessageListener(MessageListener listener) throws JMSException {
        ShimUtil.run(() -> this.delegate.setMessageListener(JavaxJms.create(listener)));
    }

    public Message receive() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).receive()));
    }

    public Message receive(long timeout) throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> this.delegate.receive(timeout)));
    }

    public Message receiveNoWait() throws JMSException {
        return JakartaJms.create(ShimUtil.call(() -> ((javax.jms.TopicSubscriber)this.delegate).receiveNoWait()));
    }

    public void close() throws JMSException {
        ShimUtil.run(() -> ((javax.jms.TopicSubscriber)this.delegate).close());
    }
}

