/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms.shim;

import io.helidon.messaging.connectors.jms.shim.JakartaDestination;
import io.helidon.messaging.connectors.jms.shim.JakartaMessage;
import io.helidon.messaging.connectors.jms.shim.JakartaQueue;
import io.helidon.messaging.connectors.jms.shim.JakartaTopic;
import jakarta.jms.JMSRuntimeException;
import jakarta.jms.Message;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.Topic;

final class ShimUtil {
    private ShimUtil() {
    }

    static <T> T call(JavaxJmsCallable<T> callable) throws jakarta.jms.JMSException {
        try {
            return callable.invoke();
        }
        catch (JMSException e) {
            throw ShimUtil.exception(e);
        }
    }

    static void run(JavaxJmsRunnable runnable) throws jakarta.jms.JMSException {
        try {
            runnable.run();
        }
        catch (JMSException e) {
            throw ShimUtil.exception(e);
        }
    }

    static <T> T callRuntime(JavaxJmsRuntimeCallable<T> callable) throws JMSRuntimeException {
        try {
            return callable.invoke();
        }
        catch (javax.jms.JMSRuntimeException e) {
            throw ShimUtil.exception(e);
        }
    }

    static void runRuntime(JavaxJmsRuntimeRunnable runnable) throws JMSRuntimeException {
        try {
            runnable.run();
        }
        catch (javax.jms.JMSRuntimeException e) {
            throw ShimUtil.exception(e);
        }
    }

    static JMSRuntimeException exception(javax.jms.JMSRuntimeException source) {
        return new JMSRuntimeException(source.getMessage(), source.getErrorCode(), (Throwable)source);
    }

    static jakarta.jms.JMSException exception(JMSException source) {
        jakarta.jms.JMSException result = new jakarta.jms.JMSException(source.getMessage(), source.getErrorCode());
        result.setLinkedException(source.getLinkedException());
        result.addSuppressed((Throwable)source);
        return result;
    }

    static JMSException exception(jakarta.jms.JMSException source) {
        JMSException result = new JMSException(source.getMessage(), source.getErrorCode());
        result.setLinkedException(source.getLinkedException());
        result.addSuppressed((Throwable)source);
        return result;
    }

    static Destination destination(jakarta.jms.Destination destination) {
        if (destination instanceof JakartaDestination) {
            return ((JakartaDestination)destination).unwrap();
        }
        if (destination instanceof Destination) {
            return (Destination)destination;
        }
        throw new RuntimeException("Destination was not created correctly, cannot convert to javax.jms.Destination: " + String.valueOf(destination));
    }

    static Topic topic(jakarta.jms.Topic topic) {
        if (topic instanceof JakartaTopic) {
            return (Topic)((JakartaTopic)topic).unwrap();
        }
        if (topic instanceof Topic) {
            return (Topic)topic;
        }
        throw new RuntimeException("Topic was not created correctly, cannot convert to javax.jms.Topic: " + String.valueOf(topic));
    }

    static Queue queue(jakarta.jms.Queue queue) {
        if (queue instanceof JakartaQueue) {
            return (Queue)((JakartaQueue)queue).unwrap();
        }
        if (queue instanceof Topic) {
            return (Queue)queue;
        }
        throw new RuntimeException("Queue was not created correctly, cannot convert to javax.jms.Queue: " + String.valueOf(queue));
    }

    static javax.jms.Message message(Message message) {
        if (message instanceof JakartaMessage) {
            return ((JakartaMessage)message).unwrap();
        }
        if (message instanceof javax.jms.Message) {
            return (javax.jms.Message)message;
        }
        throw new RuntimeException("Message was not created correctly, cannot convert to javax.jms.Message: " + String.valueOf(message));
    }

    static interface JavaxJmsCallable<T> {
        public T invoke() throws JMSException;
    }

    static interface JavaxJmsRunnable {
        public void run() throws JMSException;
    }

    static interface JavaxJmsRuntimeCallable<T> {
        public T invoke() throws javax.jms.JMSRuntimeException;
    }

    static interface JavaxJmsRuntimeRunnable {
        public void run() throws javax.jms.JMSRuntimeException;
    }
}

