/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.MessagingException;
import io.helidon.messaging.NackHandler;
import io.helidon.messaging.connectors.jms.JmsMessage;
import io.helidon.messaging.connectors.jms.SessionMetadata;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;

abstract class AbstractJmsMessage<T>
implements JmsMessage<T> {
    private static final System.Logger LOGGER = System.getLogger(AbstractJmsMessage.class.getName());
    private Executor executor;
    private SessionMetadata sharedSessionEntry;
    private volatile boolean acked = false;
    private final NackHandler nackHandler;

    protected AbstractJmsMessage(NackHandler nackHandler, Executor executor, SessionMetadata sharedSessionEntry) {
        this.nackHandler = nackHandler;
        this.sharedSessionEntry = sharedSessionEntry;
        this.executor = executor;
    }

    @Override
    public <P> P getProperty(String name) {
        try {
            return (P)this.getJmsMessage().getObjectProperty(name);
        }
        catch (JMSException | ClassCastException e) {
            throw new MessagingException("Error when getting property " + name);
        }
    }

    @Override
    public boolean hasProperty(String name) {
        try {
            return this.getJmsMessage().propertyExists(name);
        }
        catch (JMSException e) {
            throw new MessagingException("Error when checking existence of property " + name);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        try {
            return new HashSet<String>(Collections.list(this.getJmsMessage().getPropertyNames()));
        }
        catch (JMSException e) {
            throw new MessagingException("Error when getting property names ");
        }
    }

    @Override
    public Session getJmsSession() {
        return this.sharedSessionEntry.session();
    }

    @Override
    public Connection getJmsConnection() {
        return this.sharedSessionEntry.connection();
    }

    @Override
    public ConnectionFactory getJmsConnectionFactory() {
        return this.sharedSessionEntry.connectionFactory();
    }

    @Override
    public boolean isAck() {
        return this.acked;
    }

    public CompletionStage<Void> ack() {
        Runnable ackRunnable = () -> {
            try {
                this.getJmsMessage().acknowledge();
                this.acked = true;
            }
            catch (JMSException e) {
                LOGGER.log(System.Logger.Level.ERROR, () -> "Error during acknowledgement of JMS message", (Throwable)e);
            }
        };
        return Optional.ofNullable(this.executor).map(e -> CompletableFuture.runAsync(ackRunnable, e)).orElseGet(() -> {
            ackRunnable.run();
            return CompletableFuture.completedFuture(null);
        });
    }

    public Function<Throwable, CompletionStage<Void>> getNack() {
        return this.nackHandler != null ? this.nackHandler.getNack((Message)this) : reason -> CompletableFuture.completedFuture(null);
    }
}

