/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.config.Config;
import io.helidon.messaging.MessagingException;
import io.helidon.messaging.connectors.jms.shim.JakartaJms;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class ConnectionContext {
    private static final System.Logger LOGGER = System.getLogger(ConnectionContext.class.getName());
    private final Config config;
    private final InitialContext ctx;

    ConnectionContext(Config config) {
        this.config = config;
        if (this.isJndi()) {
            Properties props = new Properties();
            ((Map)config.get("jndi").get("env-properties").detach().asMap().orElseGet(Map::of)).forEach(props::setProperty);
            try {
                this.ctx = new InitialContext(props);
            }
            catch (NamingException e) {
                throw new MessagingException("Error when preparing JNDI context.", (Throwable)e);
            }
        } else {
            this.ctx = null;
        }
    }

    boolean isJndi() {
        return this.config.get("jndi").exists() && !this.config.get("named-factory").exists();
    }

    Optional<? extends ConnectionFactory> lookupFactory() {
        return this.lookupFactory((String)this.config.get("jndi").get("jms-factory").asString().orElse((Object)"ConnectionFactory"));
    }

    Optional<? extends Destination> lookupDestination() {
        return this.config.get("jndi").get("destination").asString().map(this::lookupDestination).orElseGet(Optional::empty);
    }

    Optional<? extends ConnectionFactory> lookupFactory(String jndi) {
        return Optional.ofNullable(this.lookup(jndi)).map(o -> (ConnectionFactory)JakartaJms.resolve((Object)o, ConnectionFactory.class));
    }

    Optional<? extends Destination> lookupDestination(String jndi) {
        return Optional.ofNullable(this.lookup(jndi)).map(o -> (Destination)JakartaJms.resolve((Object)o, Destination.class));
    }

    public Config config() {
        return this.config;
    }

    private Object lookup(String jndi) {
        try {
            return this.ctx.lookup(jndi);
        }
        catch (NamingException e) {
            LOGGER.log(System.Logger.Level.WARNING, () -> "JNDI lookup of " + jndi + " failed", (Throwable)e);
            return null;
        }
    }
}

