/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.MessagingException;
import io.helidon.messaging.NackHandler;
import io.helidon.messaging.connectors.jms.AbstractJmsMessage;
import io.helidon.messaging.connectors.jms.SessionMetadata;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MessageEOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class JmsBytesMessage
extends AbstractJmsMessage<byte[]> {
    private final BytesMessage msg;

    JmsBytesMessage(NackHandler nackHandler, BytesMessage msg, Executor executor, SessionMetadata sharedSessionEntry) {
        super(nackHandler, executor, sharedSessionEntry);
        this.msg = msg;
    }

    @Override
    public BytesMessage getJmsMessage() {
        return this.msg;
    }

    public InputStream asInputStream() {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                try {
                    return JmsBytesMessage.this.msg.readByte();
                }
                catch (MessageEOFException e) {
                    return -1;
                }
                catch (JMSException e) {
                    throw new IOException(e);
                }
            }
        };
    }

    public byte[] getPayload() {
        try {
            byte[] bytes = new byte[(int)this.msg.getBodyLength()];
            this.msg.readBytes(bytes);
            return bytes;
        }
        catch (JMSException e) {
            throw new MessagingException("Error when reading BytesMessage", (Throwable)e);
        }
    }
}

