/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.ConnectorConfigBuilder;
import io.helidon.messaging.connectors.jms.AcknowledgeMode;
import io.helidon.messaging.connectors.jms.Type;
import java.util.Map;
import javax.naming.spi.InitialContextFactory;

public final class JmsConfigBuilder
extends ConnectorConfigBuilder {
    JmsConfigBuilder() {
        super.property("connector", "helidon-jms");
    }

    public JmsConfigBuilder property(String key, String value) {
        super.property(key, value);
        return this;
    }

    public JmsConfigBuilder namedFactory(String factoryName) {
        super.property("named-factory", factoryName);
        return this;
    }

    public JmsConfigBuilder acknowledgeMode(AcknowledgeMode acknowledgeMode) {
        super.property("acknowledge-mode", acknowledgeMode.name());
        return this;
    }

    public JmsConfigBuilder transacted(boolean transacted) {
        super.property("transacted", String.valueOf(transacted));
        return this;
    }

    public JmsConfigBuilder username(String username) {
        super.property("username", username);
        return this;
    }

    public JmsConfigBuilder password(String password) {
        super.property("password", password);
        return this;
    }

    public JmsConfigBuilder type(Type type) {
        super.property("type", type.toString());
        return this;
    }

    public JmsConfigBuilder destination(String destination) {
        super.property("destination", destination);
        return this;
    }

    public JmsConfigBuilder queue(String destination) {
        this.type(Type.QUEUE);
        this.destination(destination);
        return this;
    }

    public JmsConfigBuilder topic(String destination) {
        this.type(Type.TOPIC);
        this.destination(destination);
        return this;
    }

    public JmsConfigBuilder messageSelector(String messageSelector) {
        super.property("message-selector", messageSelector);
        return this;
    }

    public JmsConfigBuilder pollTimeout(long pollTimeout) {
        super.property("poll-timeout", String.valueOf(pollTimeout));
        return this;
    }

    public JmsConfigBuilder periodExecutions(long periodExecutions) {
        super.property("period-executions", String.valueOf(periodExecutions));
        return this;
    }

    public JmsConfigBuilder sessionGroupId(String sessionGroupId) {
        super.property("session-group-id", sessionGroupId);
        return this;
    }

    public JmsConfigBuilder jndiJmsFactory(String jndiJmsFactory) {
        super.property("jndi.jms-factory", jndiJmsFactory);
        return this;
    }

    public JmsConfigBuilder jndiInitialFactory(String jndiInitialFactory) {
        super.property("jndi.env-properties.java.naming.factory.initial", jndiInitialFactory);
        return this;
    }

    public JmsConfigBuilder jndiInitialFactory(Class<? extends InitialContextFactory> jndiInitialFactory) {
        this.jndiInitialFactory(jndiInitialFactory.getName());
        return this;
    }

    public JmsConfigBuilder jndiProviderUrl(String jndiProviderUrl) {
        super.property("jndi.env-properties.java.naming.provider.url", jndiProviderUrl);
        return this;
    }

    public JmsConfigBuilder jndiInitialContextProperties(Map<String, String> initialContextProps) {
        initialContextProps.forEach((key, val) -> super.property("jndi.env-properties." + key, val));
        return this;
    }
}

