/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.common.Builder;
import io.helidon.messaging.MessagingException;
import io.helidon.messaging.connectors.jms.OutgoingJmsMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public interface JmsMessage<PAYLOAD>
extends org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD> {
    public Session getJmsSession();

    public Connection getJmsConnection();

    public ConnectionFactory getJmsConnectionFactory();

    public <MSG extends Message> MSG getJmsMessage();

    default public String getType() {
        try {
            return this.getJmsMessage().getJMSType();
        }
        catch (JMSException e) {
            throw new MessagingException("Error when retrieving JMS type.", (Throwable)e);
        }
    }

    default public String getCorrelationId() {
        try {
            return this.getJmsMessage().getJMSCorrelationID();
        }
        catch (JMSException e) {
            throw new MessagingException("Error when retrieving JMS correlation id.", (Throwable)e);
        }
    }

    default public Destination getReplyTo() {
        try {
            return this.getJmsMessage().getJMSReplyTo();
        }
        catch (JMSException e) {
            throw new MessagingException("Error when retrieving JMS reply to destination.", (Throwable)e);
        }
    }

    public boolean isAck();

    public <P> P getProperty(String var1);

    public boolean hasProperty(String var1);

    public Set<String> getPropertyNames();

    public static <PAYLOAD> org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD> of(PAYLOAD payload, Supplier<CompletionStage<Void>> ack) {
        return JmsMessage.builder(payload).onAck(ack).build();
    }

    public static <PAYLOAD> org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD> of(PAYLOAD payload) {
        return JmsMessage.builder(payload).build();
    }

    public static <PAYLOAD> OutgoingJmsMessageBuilder<PAYLOAD> builder(PAYLOAD payload) {
        return new OutgoingJmsMessageBuilder<PAYLOAD>(payload);
    }

    public static <PAYLOAD> OutgoingJmsMessageBuilder<PAYLOAD> builder(Message msg) {
        try {
            return new OutgoingJmsMessageBuilder(msg);
        }
        catch (JMSException e) {
            throw new MessagingException("Error when retrieving contents of jakarta.jms.Message");
        }
    }

    public static <PAYLOAD> OutgoingJmsMessageBuilder<PAYLOAD> builder() {
        return new OutgoingJmsMessageBuilder();
    }

    public static class OutgoingJmsMessageBuilder<PAYLOAD>
    implements Builder<OutgoingJmsMessageBuilder<PAYLOAD>, org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD>> {
        private final HashMap<String, Object> properties = new HashMap();
        private final OutgoingJmsMessage<PAYLOAD> message;
        private String correlationId = null;
        private Destination replyTo = null;
        private String type;

        private OutgoingJmsMessageBuilder() {
            this.message = new OutgoingJmsMessage();
        }

        private OutgoingJmsMessageBuilder(PAYLOAD payload) {
            this.message = new OutgoingJmsMessage<PAYLOAD>(payload);
        }

        private OutgoingJmsMessageBuilder(Message msg) throws JMSException {
            this.message = OutgoingJmsMessage.fromJmsMessage(msg);
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> payload(PAYLOAD payload) {
            this.message.setPayload(payload);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, boolean value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, byte value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, short value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, int value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, long value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, float value) {
            this.properties.put(name, Float.valueOf(value));
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, double value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> property(String name, String value) {
            this.properties.put(name, value);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> onAck(Supplier<CompletionStage<Void>> ack) {
            this.message.onAck(ack);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> customMapper(CustomMapper<PAYLOAD> mapper) {
            this.message.mapper(mapper);
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> correlationId(String correlationId) {
            this.correlationId = correlationId;
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> replyTo(Destination replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public OutgoingJmsMessageBuilder<PAYLOAD> type(String type) {
            this.type = type;
            return this;
        }

        public org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD> build() {
            this.message.postProcess(m -> {
                for (Map.Entry<String, Object> e : this.properties.entrySet()) {
                    m.setObjectProperty(e.getKey(), e.getValue());
                }
                if (null != this.correlationId) {
                    m.setJMSCorrelationID(this.correlationId);
                }
                if (null != this.replyTo) {
                    m.setJMSReplyTo(this.replyTo);
                }
                if (null != this.type) {
                    m.setJMSType(this.type);
                }
            });
            if (Objects.isNull(this.message.getPayload())) {
                throw new IllegalStateException("Message is missing payload.");
            }
            return this.message;
        }
    }

    @FunctionalInterface
    public static interface CustomMapper<PAYLOAD>
    extends BiFunction<PAYLOAD, Session, Message> {
        @Override
        default public Message apply(PAYLOAD p, Session session) {
            try {
                return this.applyThrows(p, session);
            }
            catch (JMSException e) {
                throw new MessagingException("Error when invoking custom mapper.", (Throwable)e);
            }
        }

        public Message applyThrows(PAYLOAD var1, Session var2) throws JMSException;
    }
}

