/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.common.reactive.BufferedEmittingPublisher;
import io.helidon.config.Config;
import io.helidon.config.ConfigSources;
import io.helidon.messaging.MessagingException;
import io.helidon.messaging.NackHandler;
import io.helidon.messaging.connectors.jms.ConnectionContext;
import io.helidon.messaging.connectors.jms.JmsConnector;
import io.helidon.messaging.connectors.jms.JmsMessage;
import io.helidon.messaging.connectors.jms.MessageMapper;
import io.helidon.messaging.connectors.jms.SessionMetadata;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageProducer;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.reactive.messaging.Message;

abstract class JmsNackHandler
implements NackHandler<JmsMessage<?>> {
    JmsNackHandler() {
    }

    static JmsNackHandler create(BufferedEmittingPublisher<Message<?>> emitter, Config config, JmsConnector jmsConnector) {
        Config dlq = config.get("nack-dlq");
        Config logOnly = config.get("nack-log-only");
        if (dlq.exists()) {
            dlq = dlq.detach();
            return new JmsDLQ(config, dlq, jmsConnector);
        }
        if (logOnly.exists() && ((Boolean)logOnly.asBoolean().orElse((Object)true)).booleanValue()) {
            logOnly = logOnly.detach();
            return new Log(config, logOnly);
        }
        return new KillChannel(emitter, config);
    }

    static <V> String messageToString(String prefix, String channel, JmsMessage<V> message) {
        StringBuilder msg = new StringBuilder(prefix);
        msg.append("\n");
        JmsNackHandler.appendNonNull(msg, "channel", channel);
        JmsNackHandler.appendNonNull(msg, "correlationId", message.getCorrelationId());
        JmsNackHandler.appendNonNull(msg, "replyTo", message.getReplyTo());
        for (String prop : message.getPropertyNames()) {
            JmsNackHandler.appendNonNull(msg, prop, message.getProperty(prop));
        }
        return msg.toString();
    }

    static StringBuilder appendNonNull(StringBuilder sb, String name, Object value) {
        if (Objects.isNull(value)) {
            return sb;
        }
        return sb.append(name + ": ").append(value).append("\n");
    }

    static class JmsDLQ
    extends JmsNackHandler {
        private static final System.Logger LOGGER = System.getLogger(JmsDLQ.class.getName());
        private final MessageProducer producer;
        private final SessionMetadata sessionMetadata;
        private final AtomicReference<MessageMapper> mapper = new AtomicReference();
        private final String channelName;
        private Config config;
        private JmsConnector jmsConnector;
        private Config dlq;

        JmsDLQ(Config config, Config dlq, JmsConnector jmsConnector) {
            this.config = config;
            this.jmsConnector = jmsConnector;
            this.channelName = (String)config.get("channel-name").asString().orElseThrow(() -> new MessagingException("Missing channel name!"));
            Config.Builder dlqCfgBuilder = Config.builder();
            HashMap<String, String> dlqCfgMap = new HashMap<String, String>();
            if (dlq.isLeaf()) {
                String destination = (String)dlq.asString().orElseThrow(() -> new MessagingException("nack-dlq with no value!"));
                dlqCfgMap.put("destination", destination);
                dlqCfgMap.put("type", "queue");
                this.dlq = dlqCfgBuilder.sources((Supplier)ConfigSources.create(dlqCfgMap), (Supplier)ConfigSources.create((Config)config.detach())).disableEnvironmentVariablesSource().disableSystemPropertiesSource().build();
            } else {
                this.dlq = dlq.detach();
            }
            try {
                ConnectionContext ctx = new ConnectionContext(this.dlq);
                ConnectionFactory factory = jmsConnector.getFactory(ctx).orElseThrow(() -> new MessagingException("No ConnectionFactory found."));
                this.sessionMetadata = jmsConnector.prepareSession(dlq, factory);
                Destination destination = jmsConnector.createDestination(this.sessionMetadata.session(), ctx);
                this.producer = jmsConnector.createProducer(destination, ctx, this.sessionMetadata);
            }
            catch (JMSException e) {
                throw new MessagingException("Error when setting up DLQ nack handler for channel " + this.channelName, (Throwable)e);
            }
        }

        public Function<Throwable, CompletionStage<Void>> getNack(JmsMessage<?> message) {
            return throwable -> this.nack((Throwable)throwable, message);
        }

        private CompletionStage<Void> nack(Throwable t, JmsMessage<?> message) {
            try {
                Throwable cause;
                for (cause = t; cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                }
                JmsMessage.OutgoingJmsMessageBuilder builder = JmsMessage.builder(message.getJmsMessage());
                builder.property("dlq-error", cause.getClass().getName()).property("dlq-error-msg", cause.getMessage()).correlationId(message.getCorrelationId()).payload(message.getPayload());
                this.config.get("destination").asString().ifPresent(s -> builder.property("dlq-orig-destination", (String)s));
                Message dlqMessage = builder.build();
                this.jmsConnector.consume(dlqMessage, this.sessionMetadata.session(), this.mapper, this.producer, this.config);
            }
            catch (Throwable e) {
                e.addSuppressed(t);
                LOGGER.log(System.Logger.Level.ERROR, "Error when sending nacked message to DLQ", e);
                return CompletableFuture.completedStage(null);
            }
            return CompletableFuture.completedStage(null);
        }
    }

    static class Log
    extends JmsNackHandler {
        private final System.Logger logger;
        private final String channelName;
        private final System.Logger.Level level;

        Log(Config config, Config logOnlyConfig) {
            this.channelName = (String)config.get("channel-name").asString().orElseThrow(() -> new MessagingException("Missing channel name!"));
            this.level = (System.Logger.Level)((Object)logOnlyConfig.get("level").as(System.Logger.Level.class).orElse((Object)System.Logger.Level.WARNING));
            this.logger = System.getLogger((String)logOnlyConfig.get("logger").asString().orElse((Object)JmsNackHandler.class.getName()));
        }

        public Function<Throwable, CompletionStage<Void>> getNack(JmsMessage<?> message) {
            return t -> this.nack((Throwable)t, message);
        }

        private CompletionStage<Void> nack(Throwable t, JmsMessage<?> message) {
            this.logger.log(this.level, Log.messageToString("NACKED Message ignored", this.channelName, message));
            message.ack();
            return CompletableFuture.completedFuture(null);
        }
    }

    static class KillChannel
    extends JmsNackHandler {
        private static final System.Logger LOGGER = System.getLogger(KillChannel.class.getName());
        private final BufferedEmittingPublisher<Message<?>> emitter;
        private final String channelName;

        KillChannel(BufferedEmittingPublisher<Message<?>> emitter, Config config) {
            this.emitter = emitter;
            this.channelName = (String)config.get("channel-name").asString().orElseThrow(() -> new MessagingException("Missing channel name!"));
        }

        public Function<Throwable, CompletionStage<Void>> getNack(JmsMessage<?> message) {
            return throwable -> this.nack((Throwable)throwable, message);
        }

        private CompletionStage<Void> nack(Throwable t, JmsMessage<?> message) {
            LOGGER.log(System.Logger.Level.ERROR, KillChannel.messageToString("NACKED message, killing the channel", this.channelName, message), t);
            this.emitter.fail(t);
            return CompletableFuture.failedStage(t);
        }
    }
}

