/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.MessagingException;
import io.helidon.messaging.NackHandler;
import io.helidon.messaging.connectors.jms.AbstractJmsMessage;
import io.helidon.messaging.connectors.jms.SessionMetadata;
import jakarta.jms.JMSException;
import jakarta.jms.TextMessage;
import java.util.concurrent.Executor;

public class JmsTextMessage
extends AbstractJmsMessage<String> {
    private final TextMessage msg;

    JmsTextMessage(NackHandler nackHandler, TextMessage msg, Executor executor, SessionMetadata sharedSessionEntry) {
        super(nackHandler, executor, sharedSessionEntry);
        this.msg = msg;
    }

    @Override
    public TextMessage getJmsMessage() {
        return this.msg;
    }

    public String getPayload() {
        try {
            return this.msg.getText();
        }
        catch (JMSException e) {
            throw new MessagingException("Error when retrieving payload of JMS text message", (Throwable)e);
        }
    }
}

