/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.connectors.jms.MessageMapper;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Map;
import org.eclipse.microprofile.reactive.messaging.Message;

class MessageMappers {
    private static final Map<Class<?>, MessageMapper> JMS_MESSAGE_MAPPERS = Map.of(String.class, (s, m) -> s.createTextMessage((String)m.getPayload()), byte[].class, (s, m) -> {
        BytesMessage bm = s.createBytesMessage();
        bm.writeBytes((byte[])m.getPayload());
        return bm;
    });

    private MessageMappers() {
    }

    static MessageMapper getJmsMessageMapper(Message<?> message) {
        Class<?> clazz = message.getPayload().getClass();
        return JMS_MESSAGE_MAPPERS.getOrDefault(clazz, (s, m) -> {
            if (ByteBuffer.class.isAssignableFrom(clazz)) {
                BytesMessage bm = s.createBytesMessage();
                bm.writeBytes(((ByteBuffer)m.getPayload()).array());
                return bm;
            }
            if (Serializable.class.isAssignableFrom(clazz)) {
                return s.createObjectMessage((Serializable)m.getPayload());
            }
            throw new JMSException("Unsupported payload type " + String.valueOf(clazz));
        });
    }
}

