/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.messaging.connectors.jms;

import io.helidon.messaging.MessagingException;
import io.helidon.messaging.connectors.jms.JmsMessage;
import io.helidon.messaging.connectors.jms.MessageMapper;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Session;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

class OutgoingJmsMessage<PAYLOAD>
implements org.eclipse.microprofile.reactive.messaging.Message<PAYLOAD> {
    private static final System.Logger LOGGER = System.getLogger(OutgoingJmsMessage.class.getName());
    private PAYLOAD payload;
    private JmsMessage.CustomMapper<PAYLOAD> mapper = null;
    private Supplier<CompletionStage<Void>> ack = () -> CompletableFuture.completedFuture(null);
    private volatile boolean acked = false;
    private List<PostProcessor> postProcessors = new ArrayList<PostProcessor>(2);

    OutgoingJmsMessage(PAYLOAD payload) {
        this.payload = payload;
    }

    OutgoingJmsMessage() {
    }

    void setPayload(PAYLOAD payload) {
        this.payload = payload;
    }

    void onAck(Supplier<CompletionStage<Void>> ack) {
        this.ack = ack;
    }

    public void mapper(JmsMessage.CustomMapper<PAYLOAD> mapper) {
        this.mapper = mapper;
    }

    public PAYLOAD getPayload() {
        return this.payload;
    }

    public boolean isAck() {
        return this.acked;
    }

    public CompletionStage<Void> ack() {
        return this.ack.get().thenRun(() -> {
            this.acked = true;
        });
    }

    void postProcess(PostProcessor processor) {
        this.postProcessors.add(processor);
    }

    Message toJmsMessage(Session session, MessageMapper defaultMapper) throws JMSException {
        Message jmsMessage = this.mapper != null ? this.mapper.apply(this.getPayload(), session) : defaultMapper.apply(session, this);
        for (PostProcessor p : this.postProcessors) {
            p.accept(jmsMessage);
        }
        return jmsMessage;
    }

    static <PAYLOAD> OutgoingJmsMessage<PAYLOAD> fromJmsMessage(Message jmsMessage) throws JMSException {
        OutgoingJmsMessage<PAYLOAD> msg = new OutgoingJmsMessage<PAYLOAD>();
        msg.postProcess(m -> {
            Enumeration e = jmsMessage.getPropertyNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                m.setObjectProperty(key, jmsMessage.getObjectProperty(key));
            }
            OutgoingJmsMessage.getAndSet("correlationId", () -> ((Message)jmsMessage).getJMSCorrelationID(), arg_0 -> ((Message)m).setJMSCorrelationID(arg_0));
            OutgoingJmsMessage.getAndSet("deliveryMode", () -> ((Message)jmsMessage).getJMSDeliveryMode(), arg_0 -> ((Message)m).setJMSDeliveryMode(arg_0));
            OutgoingJmsMessage.getAndSet("deliveryTime", () -> ((Message)jmsMessage).getJMSDeliveryTime(), arg_0 -> ((Message)m).setJMSDeliveryTime(arg_0));
            OutgoingJmsMessage.getAndSet("destination", () -> ((Message)jmsMessage).getJMSDestination(), arg_0 -> ((Message)m).setJMSDestination(arg_0));
            OutgoingJmsMessage.getAndSet("expiration", () -> ((Message)jmsMessage).getJMSExpiration(), arg_0 -> ((Message)m).setJMSExpiration(arg_0));
            OutgoingJmsMessage.getAndSet("priority", () -> ((Message)jmsMessage).getJMSPriority(), arg_0 -> ((Message)m).setJMSPriority(arg_0));
            OutgoingJmsMessage.getAndSet("redelivered", () -> ((Message)jmsMessage).getJMSRedelivered(), arg_0 -> ((Message)m).setJMSRedelivered(arg_0));
            OutgoingJmsMessage.getAndSet("replyTo", () -> ((Message)jmsMessage).getJMSReplyTo(), arg_0 -> ((Message)m).setJMSReplyTo(arg_0));
            OutgoingJmsMessage.getAndSet("type", () -> ((Message)jmsMessage).getJMSType(), arg_0 -> ((Message)m).setJMSType(arg_0));
        });
        msg.onAck(() -> {
            try {
                jmsMessage.acknowledge();
                return CompletableFuture.completedFuture(null);
            }
            catch (IllegalStateException e) {
                return CompletableFuture.completedFuture(null);
            }
            catch (JMSException e) {
                throw new MessagingException("Error when acking original jakarta.jms.Message");
            }
        });
        return msg;
    }

    static <T> void getAndSet(String propName, JmsProducer<T> supplier, JmsConsumer<T> consumer) {
        T prop;
        try {
            prop = supplier.accept();
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.DEBUG, () -> "Unable to retrieve JMS " + propName, e);
            return;
        }
        try {
            consumer.accept(prop);
        }
        catch (Throwable e) {
            LOGGER.log(System.Logger.Level.DEBUG, () -> "Unable to set JMS " + propName, e);
        }
    }

    @FunctionalInterface
    static interface PostProcessor {
        public void accept(Message var1) throws JMSException;
    }

    @FunctionalInterface
    static interface JmsProducer<T> {
        public T accept() throws Throwable;
    }

    @FunctionalInterface
    static interface JmsConsumer<T> {
        public void accept(T var1) throws Throwable;
    }
}

