/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.config.Config;
import io.helidon.config.ConfigValue;
import io.helidon.metrics.api.BaseMetricsSettings;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsSettings;
import io.helidon.metrics.api.MetricsSettings;
import io.helidon.metrics.api.RegistrySettings;
import io.helidon.metrics.api.RegistrySettingsImpl;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.microprofile.metrics.MetricRegistry;

class MetricsSettingsImpl
implements MetricsSettings {
    private static final RegistrySettings DEFAULT_REGISTRY_SETTINGS = RegistrySettings.create();
    private final boolean isEnabled;
    private final KeyPerformanceIndicatorMetricsSettings kpiMetricsSettings;
    private final BaseMetricsSettings baseMetricsSettings;
    private final EnumMap<MetricRegistry.Type, RegistrySettings> registrySettings;

    private MetricsSettingsImpl(Builder builder) {
        this.isEnabled = builder.isEnabled;
        this.kpiMetricsSettings = builder.kpiMetricsSettingsBuilder.build();
        this.baseMetricsSettings = (BaseMetricsSettings)builder.baseMetricsSettingsBuilder.build();
        this.registrySettings = builder.registrySettings;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public KeyPerformanceIndicatorMetricsSettings keyPerformanceIndicatorSettings() {
        return this.kpiMetricsSettings;
    }

    @Override
    public BaseMetricsSettings baseMetricsSettings() {
        return this.baseMetricsSettings;
    }

    @Override
    public boolean isMetricEnabled(MetricRegistry.Type registryType, String metricName) {
        if (!this.isEnabled) {
            return false;
        }
        RegistrySettings registrySettings = this.registrySettings.get(registryType);
        return registrySettings == null || registrySettings.isMetricEnabled(metricName);
    }

    @Override
    public RegistrySettings registrySettings(MetricRegistry.Type registryType) {
        return this.registrySettings.getOrDefault(registryType, DEFAULT_REGISTRY_SETTINGS);
    }

    Map<MetricRegistry.Type, RegistrySettings> registrySettings() {
        return this.registrySettings;
    }

    static class Builder
    implements MetricsSettings.Builder {
        private boolean isEnabled = true;
        private KeyPerformanceIndicatorMetricsSettings.Builder kpiMetricsSettingsBuilder = KeyPerformanceIndicatorMetricsSettings.builder();
        private BaseMetricsSettings.Builder baseMetricsSettingsBuilder = BaseMetricsSettings.builder();
        private final EnumMap<MetricRegistry.Type, RegistrySettings> registrySettings = Builder.prepareRegistrySettings();

        private static EnumMap<MetricRegistry.Type, RegistrySettings> prepareRegistrySettings() {
            EnumMap<MetricRegistry.Type, RegistrySettings> result = new EnumMap<MetricRegistry.Type, RegistrySettings>(MetricRegistry.Type.class);
            for (MetricRegistry.Type type : MetricRegistry.Type.values()) {
                result.put(type, RegistrySettings.create());
            }
            return result;
        }

        protected Builder() {
        }

        protected Builder(MetricsSettings serviceSettings) {
            this.isEnabled = serviceSettings.isEnabled();
            this.kpiMetricsSettingsBuilder = KeyPerformanceIndicatorMetricsSettings.builder(serviceSettings.keyPerformanceIndicatorSettings());
            this.baseMetricsSettingsBuilder = BaseMetricsSettings.builder(serviceSettings.baseMetricsSettings());
            for (MetricRegistry.Type metricRegistryType : MetricRegistry.Type.values()) {
                this.registrySettings.put(metricRegistryType, ((MetricsSettingsImpl)serviceSettings).registrySettings().get(metricRegistryType));
            }
        }

        @Override
        public MetricsSettingsImpl build() {
            return new MetricsSettingsImpl(this);
        }

        @Override
        public Builder enabled(boolean value) {
            this.isEnabled = value;
            return this;
        }

        @Override
        public Builder baseMetricsSettings(BaseMetricsSettings.Builder baseMetricsSettingsBuilder) {
            this.baseMetricsSettingsBuilder = baseMetricsSettingsBuilder;
            return this;
        }

        @Override
        public Builder config(Config metricsSettingsConfig) {
            this.baseMetricsSettingsBuilder.config(metricsSettingsConfig.get("base"));
            this.kpiMetricsSettingsBuilder.config(metricsSettingsConfig.get("key-performance-indicators"));
            metricsSettingsConfig.get("enabled").asBoolean().ifPresent(this::enabled);
            metricsSettingsConfig.get("registries").asList(TypedRegistrySettingsImpl::create).ifPresent(this::addAllTypedRegistrySettings);
            return this;
        }

        @Override
        public Builder keyPerformanceIndicatorSettings(KeyPerformanceIndicatorMetricsSettings.Builder kpiMetricsSettings) {
            this.kpiMetricsSettingsBuilder = kpiMetricsSettings;
            return this;
        }

        @Override
        public MetricsSettings.Builder registrySettings(MetricRegistry.Type registryType, RegistrySettings registrySettings) {
            this.registrySettings.put(registryType, registrySettings);
            return this;
        }

        private void addAllTypedRegistrySettings(List<TypedRegistrySettingsImpl> typedRegistrySettingsList) {
            for (TypedRegistrySettingsImpl typedRegistrySettings : typedRegistrySettingsList) {
                this.registrySettings.put(typedRegistrySettings.registryType, typedRegistrySettings);
            }
        }

        private static class TypedRegistrySettingsImpl
        extends RegistrySettingsImpl {
            private final MetricRegistry.Type registryType;

            static TypedRegistrySettingsImpl create(Config registrySettingsConfig) {
                RegistrySettingsImpl.Builder builder = RegistrySettingsImpl.builder();
                builder.config(registrySettingsConfig);
                ConfigValue typeNameValue = registrySettingsConfig.get("type").asString();
                if (!typeNameValue.isPresent()) {
                    throw new IllegalArgumentException("Missing metric registry type in registry settings: " + registrySettingsConfig);
                }
                MetricRegistry.Type type = MetricRegistry.Type.valueOf((String)((String)typeNameValue.get()).toUpperCase(Locale.ROOT));
                return new TypedRegistrySettingsImpl(type, builder);
            }

            private TypedRegistrySettingsImpl(MetricRegistry.Type registryType, RegistrySettingsImpl.Builder builder) {
                super(builder);
                this.registryType = registryType;
            }
        }
    }
}

