/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.NoOpMetricRegistry;
import io.helidon.metrics.api.RegistryFactory;
import java.util.EnumMap;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricRegistry;

class NoOpRegistryFactory
implements RegistryFactory {
    private static final EnumMap<MetricRegistry.Type, MetricRegistry> NO_OP_REGISTRIES = Stream.of(MetricRegistry.Type.values()).collect(() -> new EnumMap(MetricRegistry.Type.class), (map, type) -> map.put(type, NoOpMetricRegistry.create(type)), EnumMap::putAll);

    public static NoOpRegistryFactory create() {
        return new NoOpRegistryFactory();
    }

    private NoOpRegistryFactory() {
    }

    @Override
    public MetricRegistry getRegistry(MetricRegistry.Type type) {
        return NO_OP_REGISTRIES.get(type);
    }
}

