/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.metrics.api.Clock;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.api.Wrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface MeterRegistry
extends Wrapper {
    public List<Meter> meters();

    public Collection<Meter> meters(Predicate<Meter> var1);

    public Iterable<Meter> meters(Iterable<String> var1);

    public Iterable<String> scopes();

    public void close();

    public boolean isMeterEnabled(String var1, Map<String, String> var2, Optional<String> var3);

    public Clock clock();

    public <B extends Meter.Builder<B, M>, M extends Meter> M getOrCreate(B var1);

    default public Optional<Counter> counter(String name, Iterable<Tag> tags) {
        return this.meter(Counter.class, name, tags);
    }

    default public Optional<DistributionSummary> summary(String name, Iterable<Tag> tags) {
        return this.meter(DistributionSummary.class, name, tags);
    }

    default public Optional<Gauge> gauge(String name, Iterable<Tag> tags) {
        return this.meter(Gauge.class, name, tags);
    }

    default public Optional<Timer> timer(String name, Iterable<Tag> tags) {
        return this.meter(Timer.class, name, tags);
    }

    public <M extends Meter> Optional<M> meter(Class<M> var1, String var2, Iterable<Tag> var3);

    public Optional<Meter> remove(Meter var1);

    public Optional<Meter> remove(Meter.Id var1);

    public Optional<Meter> remove(Meter.Id var1, String var2);

    public Optional<Meter> remove(String var1, Iterable<Tag> var2);

    public Optional<Meter> remove(String var1, Iterable<Tag> var2, String var3);

    public boolean isDeleted(Meter var1);

    public MeterRegistry onMeterAdded(Consumer<Meter> var1);

    public MeterRegistry onMeterRemoved(Consumer<Meter> var1);

    public static interface Builder<B extends Builder<B, R>, R extends MeterRegistry>
    extends io.helidon.common.Builder<B, R> {
        public B clock(Clock var1);

        public B metricsConfig(MetricsConfig var1);

        public B onMeterAdded(Consumer<Meter> var1);

        public B onMeterRemoved(Consumer<Meter> var1);
    }
}

