/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.api;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.KeyPerformanceIndicatorMetricsConfig;
import io.helidon.metrics.api.MetricsConfigSupport;
import io.helidon.metrics.api.NoOpTag;
import io.helidon.metrics.api.ScopingConfig;
import io.helidon.metrics.api.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import java.util.regex.Matcher;

@Prototype.Configured(value="metrics")
@Prototype.Blueprint(decorator=MetricsConfigSupport.BuilderDecorator.class)
@Prototype.CustomMethods(value=MetricsConfigSupport.class)
interface MetricsConfigBlueprint {
    public static final String METRICS_CONFIG_KEY = "metrics";
    public static final String SCOPE_CONFIG_KEY = "scoping";
    public static final String KEY_PERFORMANCE_INDICATORS_CONFIG_KEY = "key-performance-indicators";

    @Prototype.FactoryMethod
    public static List<Tag> createTags(Config globalTagExpression) {
        return MetricsConfigBlueprint.createTags((String)globalTagExpression.asString().get());
    }

    public static List<Tag> createTags(String pairs) {
        TreeMap<String, Tag> result = new TreeMap<String, Tag>();
        ArrayList<String> allErrors = new ArrayList<String>();
        String[] assignments = pairs.split("(?<!\\\\),");
        int position = 0;
        for (String assignment : assignments) {
            ArrayList<Object> errorsForThisAssignment = new ArrayList<Object>();
            if (assignment.isBlank()) {
                errorsForThisAssignment.add("empty assignment at position " + position + ": " + assignment);
            } else {
                Matcher matcher = MetricsConfigSupport.TAG_ASSIGNMENT_PATTERN.matcher(assignment);
                if (!matcher.matches()) {
                    errorsForThisAssignment.add("expected tag=value but found '" + assignment + "'");
                } else {
                    String name = matcher.group(1);
                    String value = matcher.group(2);
                    if (name.isBlank()) {
                        errorsForThisAssignment.add("missing tag name");
                    }
                    if (value.isBlank()) {
                        errorsForThisAssignment.add("missing tag value");
                    }
                    if (!name.matches("[A-Za-z_][A-Za-z_0-9]*")) {
                        errorsForThisAssignment.add("tag name must start with a letter and include only letters, digits, and underscores");
                    }
                    if (errorsForThisAssignment.isEmpty()) {
                        result.put(name, NoOpTag.create(name, value.replace("\\,", ",").replace("\\=", "=")));
                    }
                }
            }
            if (!errorsForThisAssignment.isEmpty()) {
                allErrors.add(String.format("Position %d with expression %s: %s", position, assignment, errorsForThisAssignment));
            }
            ++position;
        }
        if (!allErrors.isEmpty()) {
            throw new IllegalArgumentException("Error(s) in tag expression: " + String.valueOf(allErrors));
        }
        return result.values().stream().toList();
    }

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean enabled();

    @Option.Configured
    @Option.DefaultBoolean(value={true})
    public boolean permitAll();

    @Option.Configured
    @Option.Default(value={"observe"})
    public List<String> roles();

    @Option.Configured(value="key-performance-indicators")
    public KeyPerformanceIndicatorMetricsConfig keyPerformanceIndicatorMetricsConfig();

    @Option.Configured
    public List<Tag> tags();

    @Option.Configured
    public Optional<String> appName();

    @Option.Configured
    public Optional<String> appTagName();

    @Option.Configured
    public ScopingConfig scoping();

    @Option.Configured
    public boolean restRequestEnabled();

    @Option.Redundant
    public Config config();

    public boolean isScopeEnabled(String var1);

    public boolean isMeterEnabled(String var1, String var2);
}

