/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.serviceapi;

import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.SystemTagsManager;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;

public final class JsonFormat {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Map.of());
    private static final Map<String, String> JSON_ESCAPED_CHARS_MAP = JsonFormat.initEscapedCharsMap();
    private static final Pattern JSON_ESCAPED_CHARS_REGEX = Pattern.compile(JSON_ESCAPED_CHARS_MAP.keySet().stream().map(Pattern::quote).collect(Collectors.joining("", "[", "]")));

    private JsonFormat() {
    }

    public static JsonObject jsonData(Registry ... registries) {
        return JsonFormat.toJson(JsonFormat::toJsonData, registries);
    }

    public static JsonObject jsonData(Registry registry) {
        return JsonFormat.toJson((JsonObjectBuilder builder, MetricInstance entry) -> JsonFormat.jsonData(builder, entry.id(), entry.metric()), registry);
    }

    public static JsonObject jsonDataByName(Registry registry, String metricName) {
        MergingJsonObjectBuilder builder = new MergingJsonObjectBuilder(JSON.createObjectBuilder());
        for (MetricInstance metricEntry : registry.list(metricName)) {
            HelidonMetric metric = metricEntry.metric();
            if (!registry.enabled(metricName)) continue;
            JsonFormat.jsonData(builder, metricEntry.id(), metric);
        }
        return builder.build();
    }

    public static void jsonMeta(JsonObjectBuilder builder, HelidonMetric helidonMetric, List<MetricID> metricIds) {
        MergingJsonObjectBuilder metaBuilder = new MergingJsonObjectBuilder(JSON.createObjectBuilder());
        Metadata metadata = helidonMetric.metadata();
        JsonFormat.addNonEmpty(metaBuilder, "unit", metadata.getUnit());
        JsonFormat.addNonEmpty(metaBuilder, "type", metadata.getType());
        JsonFormat.addNonEmpty(metaBuilder, "description", metadata.getDescription());
        JsonFormat.addNonEmpty(metaBuilder, "displayName", metadata.getDisplayName());
        if (metricIds != null) {
            for (MetricID metricID : metricIds) {
                boolean tagAdded = false;
                JsonArrayBuilder ab = JSON.createArrayBuilder();
                for (Map.Entry tag : SystemTagsManager.instance().allTags(metricID)) {
                    tagAdded = true;
                    ab.add(JsonFormat.tagForJsonKey(tag));
                }
                if (!tagAdded) continue;
                metaBuilder.add("tags", ab);
            }
        }
        builder.add(metadata.getName(), (JsonObjectBuilder)metaBuilder);
    }

    public static JsonObject jsonMeta(Registry ... registries) {
        return JsonFormat.toJson(JsonFormat::jsonMeta, registries);
    }

    public static JsonObject jsonMeta(Registry registry) {
        return JsonFormat.toJson((JsonObjectBuilder builder, MetricInstance entry) -> {
            MetricID metricID = entry.id();
            HelidonMetric metric = entry.metric();
            List sameNamedIDs = registry.metricIdsByName(metricID.getName());
            JsonFormat.jsonMeta(builder, metric, sameNamedIDs);
        }, registry);
    }

    private static void jsonData(JsonObjectBuilder builder, MetricID key, HelidonMetric value) {
        switch (value.metadata().getTypeRaw()) {
            case CONCURRENT_GAUGE: {
                JsonFormat.concurrentGauge(builder, key, (ConcurrentGauge)value);
                break;
            }
            case COUNTER: {
                JsonFormat.counter(builder, key, (Counter)value);
                break;
            }
            case GAUGE: {
                JsonFormat.gauge(builder, key, (Gauge<? extends Number>)((Gauge)value));
                break;
            }
            case METERED: {
                JsonFormat.meter(builder, key, (Meter)value);
                break;
            }
            case HISTOGRAM: {
                JsonFormat.histogram(builder, key, (Histogram)value);
                break;
            }
            case TIMER: {
                JsonFormat.timer(builder, key, value, (Timer)value);
                break;
            }
            case SIMPLE_TIMER: {
                JsonFormat.simpleTimer(builder, key, value, (SimpleTimer)value);
                break;
            }
            case INVALID: {
                throw new IllegalArgumentException("Invalid metric encountered: " + String.valueOf(key));
            }
            default: {
                throw new IllegalArgumentException("Invalid metric type encountered: " + String.valueOf(value.metadata().getTypeRaw()) + ", key" + String.valueOf(key));
            }
        }
    }

    private static String jsonFullKey(MetricID metricID) {
        return JsonFormat.jsonFullKey(metricID.getName(), metricID);
    }

    private static long conversionFactor(HelidonMetric helidonMetric) {
        String unit = helidonMetric.metadata().getUnit();
        if (unit == null || unit.isEmpty() || "none".equals(unit)) {
            return 1L;
        }
        return switch (unit) {
            case "microseconds" -> 1000L;
            case "milliseconds" -> 1000000L;
            case "seconds" -> 1000000000L;
            case "minutes" -> 60000000000L;
            case "hours" -> 3600000000000L;
            case "days" -> 86400000000000L;
            default -> 1L;
        };
    }

    private static JsonObject toJsonData(Registry registry) {
        return JsonFormat.toJson((JsonObjectBuilder builder, MetricInstance entry) -> JsonFormat.jsonData(builder, entry.id(), entry.metric()), registry);
    }

    private static void simpleTimer(JsonObjectBuilder builder, MetricID metricID, HelidonMetric helidonMetric, SimpleTimer value) {
        long divisor = JsonFormat.conversionFactor(helidonMetric);
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(JsonFormat.jsonFullKey("count", metricID), value.getCount()).add(JsonFormat.jsonFullKey("elapsedTime", metricID), JsonFormat.jsonDuration(value.getElapsedTime(), divisor)).add(JsonFormat.jsonFullKey("maxTimeDuration", metricID), JsonFormat.jsonDuration(value.getMaxTimeDuration(), divisor)).add(JsonFormat.jsonFullKey("minTimeDuration", metricID), JsonFormat.jsonDuration(value.getMinTimeDuration(), divisor));
        builder.add(metricID.getName(), myBuilder);
    }

    private static JsonValue jsonDuration(Duration duration, long conversionFactor) {
        if (duration == null) {
            return JsonObject.NULL;
        }
        double result = (double)duration.toNanos() / (double)conversionFactor;
        return Json.createValue((double)result);
    }

    private static void timer(JsonObjectBuilder builder, MetricID metricID, HelidonMetric helidonMetric, Timer value) {
        Snapshot snapshot = value.getSnapshot();
        long divisor = JsonFormat.conversionFactor(helidonMetric);
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(JsonFormat.jsonFullKey("count", metricID), value.getCount()).add(JsonFormat.jsonFullKey("elapsedTime", metricID), JsonFormat.jsonDuration(value.getElapsedTime(), divisor)).add(JsonFormat.jsonFullKey("meanRate", metricID), value.getMeanRate()).add(JsonFormat.jsonFullKey("oneMinRate", metricID), value.getOneMinuteRate()).add(JsonFormat.jsonFullKey("fiveMinRate", metricID), value.getFiveMinuteRate()).add(JsonFormat.jsonFullKey("fifteenMinRate", metricID), value.getFifteenMinuteRate()).add(JsonFormat.jsonFullKey("min", metricID), snapshot.getMin() / divisor).add(JsonFormat.jsonFullKey("max", metricID), snapshot.getMax() / divisor).add(JsonFormat.jsonFullKey("mean", metricID), snapshot.getMean() / (double)divisor).add(JsonFormat.jsonFullKey("stddev", metricID), snapshot.getStdDev() / (double)divisor).add(JsonFormat.jsonFullKey("p50", metricID), snapshot.getMedian() / (double)divisor).add(JsonFormat.jsonFullKey("p75", metricID), snapshot.get75thPercentile() / (double)divisor).add(JsonFormat.jsonFullKey("p95", metricID), snapshot.get95thPercentile() / (double)divisor).add(JsonFormat.jsonFullKey("p98", metricID), snapshot.get98thPercentile() / (double)divisor).add(JsonFormat.jsonFullKey("p99", metricID), snapshot.get99thPercentile() / (double)divisor).add(JsonFormat.jsonFullKey("p999", metricID), snapshot.get999thPercentile() / (double)divisor);
        builder.add(metricID.getName(), myBuilder);
    }

    private static void histogram(JsonObjectBuilder builder, MetricID metricId, Histogram value) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(JsonFormat.jsonFullKey("count", metricId), value.getCount()).add(JsonFormat.jsonFullKey("sum", metricId), value.getSum());
        Snapshot snapshot = value.getSnapshot();
        myBuilder = myBuilder.add(JsonFormat.jsonFullKey("min", metricId), snapshot.getMin()).add(JsonFormat.jsonFullKey("max", metricId), snapshot.getMax()).add(JsonFormat.jsonFullKey("mean", metricId), snapshot.getMean()).add(JsonFormat.jsonFullKey("stddev", metricId), snapshot.getStdDev()).add(JsonFormat.jsonFullKey("p50", metricId), snapshot.getMedian()).add(JsonFormat.jsonFullKey("p75", metricId), snapshot.get75thPercentile()).add(JsonFormat.jsonFullKey("p95", metricId), snapshot.get95thPercentile()).add(JsonFormat.jsonFullKey("p98", metricId), snapshot.get98thPercentile()).add(JsonFormat.jsonFullKey("p99", metricId), snapshot.get99thPercentile()).add(JsonFormat.jsonFullKey("p999", metricId), snapshot.get999thPercentile());
        builder.add(metricId.getName(), myBuilder);
    }

    private static void meter(JsonObjectBuilder builder, MetricID metricId, Meter value) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(JsonFormat.jsonFullKey("count", metricId), value.getCount()).add(JsonFormat.jsonFullKey("meanRate", metricId), value.getMeanRate()).add(JsonFormat.jsonFullKey("oneMinRate", metricId), value.getOneMinuteRate()).add(JsonFormat.jsonFullKey("fiveMinRate", metricId), value.getFiveMinuteRate()).add(JsonFormat.jsonFullKey("fifteenMinRate", metricId), value.getFifteenMinuteRate());
        builder.add(metricId.getName(), myBuilder);
    }

    private static void gauge(JsonObjectBuilder builder, MetricID metricId, Gauge<? extends Number> gauge) {
        Number value = (Number)gauge.getValue();
        String nameWithTags = JsonFormat.jsonFullKey(metricId);
        if (value instanceof AtomicInteger) {
            AtomicInteger it = (AtomicInteger)value;
            builder.add(nameWithTags, it.longValue());
        } else if (value instanceof AtomicLong) {
            AtomicLong it = (AtomicLong)value;
            builder.add(nameWithTags, it.longValue());
        } else if (value instanceof BigDecimal) {
            BigDecimal it = (BigDecimal)value;
            builder.add(nameWithTags, it);
        } else if (value instanceof BigInteger) {
            BigInteger it = (BigInteger)value;
            builder.add(nameWithTags, it);
        } else if (value instanceof Byte) {
            Byte it = (Byte)value;
            builder.add(nameWithTags, it.intValue());
        } else if (value instanceof Double) {
            Double it = (Double)value;
            builder.add(nameWithTags, it.doubleValue());
        } else if (value instanceof DoubleAccumulator) {
            DoubleAccumulator it = (DoubleAccumulator)value;
            builder.add(nameWithTags, it.doubleValue());
        } else if (value instanceof DoubleAdder) {
            DoubleAdder it = (DoubleAdder)value;
            builder.add(nameWithTags, it.doubleValue());
        } else if (value instanceof Float) {
            Float it = (Float)value;
            builder.add(nameWithTags, (double)it.floatValue());
        } else if (value instanceof Integer) {
            Integer it = (Integer)value;
            builder.add(nameWithTags, it.intValue());
        } else if (value instanceof Long) {
            Long it = (Long)value;
            builder.add(nameWithTags, it.longValue());
        } else if (value instanceof LongAccumulator) {
            LongAccumulator it = (LongAccumulator)value;
            builder.add(nameWithTags, it.longValue());
        } else if (value instanceof LongAdder) {
            LongAdder it = (LongAdder)value;
            builder.add(nameWithTags, it.longValue());
        } else if (value instanceof Short) {
            Short it = (Short)value;
            builder.add(nameWithTags, it.intValue());
        } else {
            builder.add(nameWithTags, value.doubleValue());
        }
    }

    private static void counter(JsonObjectBuilder builder, MetricID metricId, Counter value) {
        builder.add(JsonFormat.jsonFullKey(metricId), value.getCount());
    }

    private static void concurrentGauge(JsonObjectBuilder builder, MetricID metricId, ConcurrentGauge value) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(JsonFormat.jsonFullKey("current", metricId), value.getCount()).add(JsonFormat.jsonFullKey("max", metricId), value.getMax()).add(JsonFormat.jsonFullKey("min", metricId), value.getMin());
        builder.add(metricId.getName(), myBuilder);
    }

    private static String jsonEscape(String s) {
        Matcher m = JSON_ESCAPED_CHARS_REGEX.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, JSON_ESCAPED_CHARS_MAP.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private static Map<String, String> initEscapedCharsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("\b", JsonFormat.bsls("b"));
        result.put("\f", JsonFormat.bsls("f"));
        result.put("\n", JsonFormat.bsls("n"));
        result.put("\r", JsonFormat.bsls("r"));
        result.put("\t", JsonFormat.bsls("t"));
        result.put("\"", JsonFormat.bsls("\""));
        result.put("\\", JsonFormat.bsls("\\\\"));
        result.put(";", "_");
        return result;
    }

    private static String bsls(String s) {
        return "\\\\" + s;
    }

    private static String jsonFullKey(String baseName, MetricID metricID) {
        return baseName + JsonFormat.tagsToJsonFormat(SystemTagsManager.instance().allTags(metricID));
    }

    private static String tagsToJsonFormat(Iterable<Map.Entry<String, String>> it) {
        StringJoiner sj = new StringJoiner(";", ";", "").setEmptyValue("");
        it.forEach(entry -> sj.add(JsonFormat.tagForJsonKey(entry)));
        return sj.toString();
    }

    private static String tagForJsonKey(Map.Entry<String, String> tagEntry) {
        return String.format("%s=%s", JsonFormat.jsonEscape(tagEntry.getKey()), JsonFormat.jsonEscape(tagEntry.getValue()));
    }

    private static void addNonEmpty(JsonObjectBuilder builder, String name, String value) {
        if (null != value && !value.isEmpty()) {
            builder.add(name, value);
        }
    }

    private static JsonObject toJson(BiConsumer<JsonObjectBuilder, MetricInstance> accumulator, Registry registry) {
        return registry.stream().sorted(Comparator.comparing(MetricInstance::id)).collect(() -> new MergingJsonObjectBuilder(JSON.createObjectBuilder()), accumulator, JsonObjectBuilder::addAll).build();
    }

    private static JsonObject toJson(Function<Registry, JsonObject> fn, Registry ... registries) {
        return Arrays.stream(registries).filter(r -> !r.empty()).collect(() -> ((JsonBuilderFactory)JSON).createObjectBuilder(), (builder, registry) -> JsonFormat.accumulateJson(builder, registry, fn), JsonObjectBuilder::addAll).build();
    }

    private static void accumulateJson(JsonObjectBuilder builder, Registry registry, Function<Registry, JsonObject> fn) {
        builder.add(registry.type(), (JsonValue)fn.apply(registry));
    }

    static final class MergingJsonObjectBuilder
    implements JsonObjectBuilder {
        private final JsonObjectBuilder delegate;
        private final Map<String, List<JsonObject>> subValuesMap = new HashMap<String, List<JsonObject>>();
        private final Map<String, List<JsonArray>> subArraysMap = new HashMap<String, List<JsonArray>>();

        MergingJsonObjectBuilder(JsonObjectBuilder delegate) {
            this.delegate = delegate;
        }

        public JsonObjectBuilder add(String arg0, JsonValue arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, String arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, BigInteger arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, BigDecimal arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, int arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, long arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, double arg1) {
            if (Double.isNaN(arg1)) {
                this.delegate.add(arg0, String.valueOf(Double.NaN));
            } else {
                this.delegate.add(arg0, arg1);
            }
            return this;
        }

        public JsonObjectBuilder add(String arg0, boolean arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder addNull(String arg0) {
            this.delegate.addNull(arg0);
            return this;
        }

        public JsonObjectBuilder add(String name, JsonObjectBuilder subBuilder) {
            List<Object> subValues;
            JsonObject ob = subBuilder.build();
            this.delegate.add(name, JSON.createObjectBuilder(ob));
            if (this.subValuesMap.containsKey(name)) {
                subValues = this.subValuesMap.get(name);
            } else {
                subValues = new ArrayList();
                this.subValuesMap.put(name, subValues);
            }
            subValues.add(ob);
            return this;
        }

        public JsonObjectBuilder add(String name, JsonArrayBuilder arrayBuilder) {
            List<Object> subArrays;
            JsonArray array = arrayBuilder.build();
            this.delegate.add(name, JSON.createArrayBuilder(array));
            if (this.subArraysMap.containsKey(name)) {
                subArrays = this.subArraysMap.get(name);
            } else {
                subArrays = new ArrayList();
                this.subArraysMap.put(name, subArrays);
            }
            subArrays.add(array);
            return this;
        }

        public JsonObjectBuilder addAll(JsonObjectBuilder builder) {
            this.delegate.addAll(builder);
            return this;
        }

        public JsonObjectBuilder remove(String name) {
            this.delegate.remove(name);
            return this;
        }

        public JsonObject build() {
            JsonObject beforeMerging = this.delegate.build();
            if (this.subValuesMap.isEmpty() && this.subArraysMap.isEmpty()) {
                return beforeMerging;
            }
            JsonObjectBuilder mainBuilder = JSON.createObjectBuilder(beforeMerging);
            this.subValuesMap.forEach((key, value) -> {
                JsonObjectBuilder metricBuilder = JSON.createObjectBuilder();
                for (JsonObject subObject : value) {
                    JsonObjectBuilder subBuilder = JSON.createObjectBuilder(subObject);
                    metricBuilder.addAll(subBuilder);
                }
                mainBuilder.add(key, metricBuilder);
            });
            this.subArraysMap.forEach((key, value) -> {
                JsonArrayBuilder arrayBuilder = JSON.createArrayBuilder();
                for (JsonArray subArray : value) {
                    JsonArrayBuilder subArrayBuilder = JSON.createArrayBuilder(subArray);
                    arrayBuilder.add(subArrayBuilder);
                }
                mainBuilder.add(key, arrayBuilder);
            });
            return mainBuilder.build();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

