/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.serviceapi;

import io.helidon.metrics.api.HelidonMetric;
import io.helidon.metrics.api.LabeledSnapshot;
import io.helidon.metrics.api.MetricInstance;
import io.helidon.metrics.api.Registry;
import io.helidon.metrics.api.Sample;
import io.helidon.metrics.api.SampledMetric;
import io.helidon.metrics.api.SnapshotMetric;
import io.helidon.metrics.api.SystemTagsManager;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

public final class PrometheusFormat {
    private static final System.Logger LOGGER = System.getLogger(PrometheusFormat.class.getName());
    private static final Pattern DOUBLE_UNDERSCORE = Pattern.compile("__");
    private static final Pattern COLON_UNDERSCORE = Pattern.compile(":_");
    private static final Map<String, Units> PROMETHEUS_CONVERTERS = new HashMap<String, Units>();
    private static final int EXEMPLAR_MAX_LENGTH = 128;
    private static final long KILOBITS = 125L;
    private static final long MEGABITS = 125000L;
    private static final long GIGABITS = 125000000L;
    private static final long KIBIBITS = 128L;
    private static final long MEBIBITS = 131072L;
    private static final long GIBIBITS = 0x8000000L;
    private static final long KILOBYTES = 1000L;
    private static final long MEGABYTES = 1000000L;
    private static final long GIGABYTES = 1000000000L;

    private PrometheusFormat() {
    }

    public static String prometheusDataByName(Registry registry, String metricName) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (MetricInstance metricEntry : registry.list(metricName)) {
            HelidonMetric metric = metricEntry.metric();
            if (registry.enabled(metricName)) {
                PrometheusFormat.prometheusData(sb, metricEntry.id(), metric, isFirst);
            }
            isFirst = false;
        }
        return sb.toString();
    }

    public static String prometheusData(Registry ... registries) {
        return Arrays.stream(registries).filter(r -> !r.empty()).map(PrometheusFormat::prometheusData).collect(Collectors.joining());
    }

    public static String prometheusData(MetricID metricId, HelidonMetric value, boolean withHelpType) {
        StringBuilder sb = new StringBuilder();
        PrometheusFormat.prometheusData(sb, metricId, value, withHelpType);
        return sb.toString();
    }

    private static void prometheusData(StringBuilder sb, MetricID key, HelidonMetric value, boolean withHelpType) {
        Metadata metadata = value.metadata();
        switch (metadata.getTypeRaw()) {
            case CONCURRENT_GAUGE: {
                PrometheusFormat.concurrentGauge(sb, key, metadata, value, (ConcurrentGauge)value, withHelpType);
                break;
            }
            case COUNTER: {
                PrometheusFormat.counter(sb, key, metadata, value, (Counter)value, withHelpType);
                break;
            }
            case GAUGE: {
                PrometheusFormat.gauge(sb, key, metadata, value, (Gauge<? extends Number>)((Gauge)value), withHelpType);
                break;
            }
            case METERED: {
                PrometheusFormat.meter(sb, key, metadata, value, (Meter)value, withHelpType);
                break;
            }
            case HISTOGRAM: {
                PrometheusFormat.histogram(sb, key, metadata, value, (Histogram)value, withHelpType);
                break;
            }
            case TIMER: {
                PrometheusFormat.timer(sb, key, metadata, value, (Timer)value, withHelpType);
                break;
            }
            case SIMPLE_TIMER: {
                PrometheusFormat.simpleTimer(sb, key, metadata, value, (SimpleTimer)value, withHelpType);
                break;
            }
            case INVALID: {
                throw new IllegalArgumentException("Invalid metric encountered: " + String.valueOf(key));
            }
            default: {
                throw new IllegalArgumentException("Invalid metric type encountered: " + String.valueOf(metadata.getTypeRaw()) + ", key: " + String.valueOf(key));
            }
        }
    }

    private static String nameWithUnits(String registryType, Metadata metadata, MetricID metricID) {
        return PrometheusFormat.nameWithUnits(registryType, metricID.getName(), PrometheusFormat.units(metadata));
    }

    private static String nameWithUnits(String registryType, String name, Units units) {
        return PrometheusFormat.prometheusName(registryType, name) + units.getPrometheusUnit().map(it -> "_" + it).orElse("");
    }

    private static String prometheusName(String registryType, String name) {
        return PrometheusFormat.prometheusClean(name, registryType + "_");
    }

    private static String tags(Map<String, String> tags) {
        StringJoiner sj = new StringJoiner(",", "{", "}").setEmptyValue("");
        SystemTagsManager.instance().allTags(tags).forEach(entry -> {
            if (entry.getKey() != null) {
                sj.add(String.format("%s=\"%s\"", PrometheusFormat.prometheusClean((String)entry.getKey(), ""), PrometheusFormat.prometheusTagValue((String)entry.getValue())));
            }
        });
        return sj.toString();
    }

    private static String prometheusData(Registry registry) {
        StringBuilder builder = new StringBuilder();
        HashSet serialized = new HashSet();
        registry.stream().sorted(Comparator.comparing(MetricInstance::id)).forEach(entry -> {
            String name = entry.id().getName();
            if (!serialized.contains(name)) {
                PrometheusFormat.prometheusData(builder, entry.id(), entry.metric(), true);
                serialized.add(name);
            } else {
                PrometheusFormat.prometheusData(builder, entry.id(), entry.metric(), false);
            }
        });
        return builder.toString();
    }

    private static void simpleTimer(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, SimpleTimer value, boolean withHelpType) {
        String tags = PrometheusFormat.tags(metricId.getTags());
        String baseName = PrometheusFormat.prometheusName(helidonMetric.registryType(), metricId.getName());
        String name = baseName + "_total";
        PrometheusFormat.help(sb, metadata, name, "counter", withHelpType);
        sb.append(name).append(tags).append(" ").append(value.getCount());
        Sample.Labeled sample = null;
        if (helidonMetric instanceof Sample.Labeled) {
            Sample.Labeled labeled;
            sample = labeled = (Sample.Labeled)helidonMetric;
            sb.append(PrometheusFormat.prometheusExemplar(TimeUnit.NANOSECONDS.toSeconds(labeled.value()), labeled));
        }
        sb.append("\n");
        name = baseName + "_elapsedTime_seconds";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, name, "gauge");
        }
        sb.append(name).append(tags).append(" ").append(value.getElapsedTime().toSeconds()).append(PrometheusFormat.exemplarForElapsedTime(sample)).append("\n");
        name = baseName + "_maxTimeDuration_seconds";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, name, "gauge");
        }
        sb.append(name).append(tags).append(" ").append(PrometheusFormat.durationPrometheusOutput(value.getMaxTimeDuration())).append("\n");
        name = baseName + "_minTimeDuration_seconds";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, name, "gauge");
        }
        sb.append(name).append(tags).append(" ").append(PrometheusFormat.durationPrometheusOutput(value.getMinTimeDuration())).append("\n");
    }

    private static void timer(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, Timer value, boolean withHelpType) {
        if (!(helidonMetric instanceof SnapshotMetric)) {
            return;
        }
        SnapshotMetric snapshotable = (SnapshotMetric)helidonMetric;
        String baseName = PrometheusFormat.prometheusClean(metricId.getName(), helidonMetric.registryType() + "_");
        PrometheusName name = PrometheusName.create(helidonMetric.registryType(), metadata, metricId, TimeUnits.PROMETHEUS_TIMER_CONVERSION_TIME_UNITS, baseName);
        PrometheusFormat.appendPrometheusTimerStatElement(sb, name, "rate_per_second", withHelpType, "gauge", value.getMeanRate());
        PrometheusFormat.appendPrometheusTimerStatElement(sb, name, "one_min_rate_per_second", withHelpType, "gauge", value.getOneMinuteRate());
        PrometheusFormat.appendPrometheusTimerStatElement(sb, name, "five_min_rate_per_second", withHelpType, "gauge", value.getFiveMinuteRate());
        PrometheusFormat.appendPrometheusTimerStatElement(sb, name, "fifteen_min_rate_per_second", withHelpType, "gauge", value.getFifteenMinuteRate());
        LabeledSnapshot snap = snapshotable.snapshot();
        PrometheusFormat.histogram(sb, name, metadata, snap, TimeUnits.PROMETHEUS_TIMER_CONVERSION_TIME_UNITS, value.getCount(), value.getElapsedTime().toSeconds(), withHelpType);
    }

    private static void appendPrometheusTimerStatElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, double value) {
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, name.nameStat(statName), typeName);
        }
        sb.append(name.nameStatTags(statName)).append(" ").append(value).append("\n");
    }

    private static void histogram(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, Histogram value, boolean withHelpType) {
        if (!(helidonMetric instanceof SnapshotMetric)) {
            return;
        }
        SnapshotMetric snapshotable = (SnapshotMetric)helidonMetric;
        String name = metricId.getName();
        String baseName = PrometheusFormat.prometheusClean(name, helidonMetric.registryType() + "_");
        Units units = PrometheusFormat.units(metadata);
        PrometheusName pName = PrometheusName.create(helidonMetric.registryType(), metadata, metricId, units, baseName);
        PrometheusFormat.histogram(sb, pName, metadata, snapshotable.snapshot(), units, value.getCount(), value.getSum(), withHelpType);
    }

    private static void histogram(StringBuilder sb, PrometheusName name, Metadata metadata, LabeledSnapshot snap, Units units, long count, long sum, boolean withHelpType) {
        PrometheusFormat.appendPrometheusElement(sb, name, "mean", withHelpType, "gauge", snap.mean());
        PrometheusFormat.appendPrometheusElement(sb, name, "max", withHelpType, "gauge", snap.max());
        PrometheusFormat.appendPrometheusElement(sb, name, "min", withHelpType, "gauge", snap.min());
        PrometheusFormat.appendPrometheusElement(sb, name, "stddev", withHelpType, "gauge", snap.stdDev());
        PrometheusFormat.help(sb, metadata, name.nameUnits(), "summary", withHelpType);
        sb.append(name.nameUnitsSuffixTags("count")).append(" ").append(count).append('\n');
        sb.append(name.nameUnitsSuffixTags("sum")).append(" ").append(sum).append('\n');
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.5", snap.median());
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.75", snap.sample75thPercentile());
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.95", snap.sample95thPercentile());
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.98", snap.sample98thPercentile());
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.99", snap.sample99thPercentile());
        PrometheusFormat.prometheusQuantile(sb, name, units, "0.999", snap.sample999thPercentile());
    }

    private static void prometheusQuantile(StringBuilder sb, PrometheusName name, Units units, String quantile, Sample.Derived derived) {
        String quantileTag = "quantile=\"" + quantile + "\"";
        Object tags = name.prometheusTags();
        tags = name.prometheusTags().isEmpty() ? "{" + quantileTag + "}" : ((String)tags).substring(0, ((String)tags).length() - 1) + "," + quantileTag + "}";
        sb.append(name.nameUnits()).append((String)tags).append(" ").append(units.convert(derived.value()));
        sb.append(PrometheusFormat.prometheusExemplar(units, derived.sample()));
        sb.append("\n");
    }

    private static void appendPrometheusElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, Sample.Derived derived) {
        PrometheusFormat.appendPrometheusElement(sb, name, () -> name.nameStatUnits(statName), withHelpType, typeName, derived.value(), derived.sample());
    }

    private static void appendPrometheusElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, Sample.Labeled sample) {
        PrometheusFormat.appendPrometheusElement(sb, name, () -> name.nameStatUnits(statName), withHelpType, typeName, sample.value(), sample);
    }

    private static void appendPrometheusElement(StringBuilder sb, PrometheusName name, Supplier<String> nameToUse, boolean withHelpType, String typeName, double value, Sample.Labeled sample) {
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameToUse.get(), typeName);
        }
        Object convertedValue = name.units().convert(value);
        sb.append(nameToUse.get()).append(name.prometheusTags()).append(" ").append(convertedValue).append(PrometheusFormat.prometheusExemplar(name.units(), sample)).append("\n");
    }

    private static void meter(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, Meter value, boolean withHelpType) {
        String name = metricId.getName();
        String baseName = PrometheusFormat.prometheusClean(name, helidonMetric.registryType() + "_");
        String tags = PrometheusFormat.tags(metricId.getTags());
        String nameUnits = baseName + "_total";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameUnits, "counter");
            PrometheusFormat.prometheusHelp(sb, metadata, nameUnits);
        }
        sb.append(nameUnits).append(tags).append(" ").append(value.getCount()).append("\n");
        nameUnits = baseName + "_rate_per_second";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(value.getMeanRate()).append("\n");
        nameUnits = baseName + "_one_min_rate_per_second";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(value.getOneMinuteRate()).append("\n");
        nameUnits = baseName + "_five_min_rate_per_second";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(value.getFiveMinuteRate()).append("\n");
        nameUnits = baseName + "_fifteen_min_rate_per_second";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(value.getFifteenMinuteRate()).append("\n");
    }

    private static void gauge(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, Gauge<? extends Number> value, boolean withHelpType) {
        String name = PrometheusFormat.nameWithUnits(helidonMetric.registryType(), metadata, metricId);
        PrometheusFormat.help(sb, metadata, name, metadata.getType(), withHelpType);
        sb.append(name).append(PrometheusFormat.tags(metricId.getTags())).append(" ").append(PrometheusFormat.units(metadata).convert(value.getValue())).append('\n');
    }

    private static void counter(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, Counter value, boolean withHelpType) {
        Object name = PrometheusFormat.prometheusName(helidonMetric.registryType(), metricId.getName());
        name = ((String)name).endsWith("total") ? name : (String)name + "_total";
        PrometheusFormat.help(sb, metadata, (String)name, metadata.getType(), withHelpType);
        sb.append((String)name).append(PrometheusFormat.tags(metricId.getTags())).append(" ").append(value.getCount());
        if (value instanceof SampledMetric) {
            SampledMetric sampled = (SampledMetric)value;
            sampled.sample().ifPresent(it -> sb.append(PrometheusFormat.prometheusExemplar(PrometheusFormat.units(metadata), it)));
        }
        sb.append('\n');
    }

    private static void concurrentGauge(StringBuilder sb, MetricID metricId, Metadata metadata, HelidonMetric helidonMetric, ConcurrentGauge value, boolean withHelpType) {
        String name = PrometheusFormat.nameWithUnits(helidonMetric.registryType(), metadata, metricId);
        String nameCurrent = name + "_current";
        PrometheusFormat.help(sb, metadata, nameCurrent, "gauge", withHelpType);
        sb.append(nameCurrent).append(PrometheusFormat.tags(metricId.getTags())).append(" ").append(value.getCount()).append('\n');
        String nameMin = name + "_min";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameMin, "gauge");
        }
        sb.append(nameMin).append(PrometheusFormat.tags(metricId.getTags())).append(" ").append(value.getMin()).append('\n');
        String nameMax = name + "_max";
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, nameMax, "gauge");
        }
        sb.append(nameMax).append(PrometheusFormat.tags(metricId.getTags())).append(" ").append(value.getMax()).append('\n');
    }

    private static void help(StringBuilder sb, Metadata metadata, String name, String type, boolean withHelpType) {
        if (withHelpType) {
            PrometheusFormat.prometheusType(sb, name, type);
            PrometheusFormat.prometheusHelp(sb, metadata, name);
        }
    }

    private static void prometheusType(StringBuilder sb, String nameWithUnits, String type) {
        sb.append("# TYPE ").append(nameWithUnits).append(" ").append(type).append('\n');
    }

    private static void prometheusHelp(StringBuilder sb, Metadata metadata, String nameWithUnits) {
        sb.append("# HELP ").append(nameWithUnits).append(" ").append(metadata.getDescription()).append('\n');
    }

    private static Units units(Metadata metadata) {
        String unit = metadata.getUnit();
        if (null == unit || unit.isEmpty() || "none".equals(unit)) {
            return new Units(null);
        }
        Units units = PROMETHEUS_CONVERTERS.get(unit);
        return units == null ? new Units(unit, unit, Function.identity()) : units;
    }

    private static String prometheusExemplar(Units units, Sample.Labeled sample) {
        return sample == null ? "" : PrometheusFormat.prometheusExemplar(units.convert(sample.value()), sample);
    }

    private static String prometheusExemplar(Object value, Sample.Labeled sample) {
        if (sample == null || sample.label().isBlank()) {
            return "";
        }
        String exemplar = String.format(" # %s %s %f", sample.label(), value, (double)sample.timestamp() / 1000.0);
        if (exemplar.length() <= 128) {
            return exemplar;
        }
        LOGGER.log(System.Logger.Level.WARNING, String.format("Exemplar string exceeds the maximum length(%d); suppressing '%s'", exemplar.length(), exemplar));
        return "";
    }

    private static void addByteConverter(String metricUnit, long toByteRatio) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new Units(metricUnit, "bytes", o -> ((Number)o).doubleValue() * (double)toByteRatio));
    }

    private static void addConverter(Units units) {
        PROMETHEUS_CONVERTERS.put(units.getMetricUnit(), units);
    }

    private static void addTimeConverter(String metricUnit, TimeUnit timeUnit) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new TimeUnits(metricUnit, timeUnit));
    }

    private static String prometheusTagValue(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\n", "\\n");
        return value;
    }

    private static String prometheusClean(String name, String prefix) {
        Object orig;
        name = ((String)name).replaceAll("[^a-zA-Z0-9_]", "_");
        name = prefix + (String)name;
        while (!((String)(orig = name)).equals(name = DOUBLE_UNDERSCORE.matcher((CharSequence)name).replaceAll("_"))) {
        }
        while (!((String)(orig = name)).equals(name = COLON_UNDERSCORE.matcher((CharSequence)name).replaceAll(":"))) {
        }
        return name;
    }

    private static String durationPrometheusOutput(Duration duration) {
        return duration == null ? "NaN" : Double.toString((double)duration.toNanos() / 1000.0 / 1000.0 / 1000.0);
    }

    private static String exemplarForElapsedTime(Sample.Labeled sample) {
        return sample == null ? "" : PrometheusFormat.prometheusExemplar(sample.value(), sample);
    }

    private static String convertTime(Object o, TimeUnit from) {
        return String.valueOf(TimeUnit.SECONDS.convert(new BigDecimal(String.valueOf(o)).longValue(), from));
    }

    private static String convertNanos(Object o) {
        return String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1.0E9);
    }

    private static String convertMicros(Object o) {
        return String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000000.0);
    }

    private static String convertMillis(Object o) {
        return String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000.0);
    }

    static {
        PrometheusFormat.addTimeConverter("nanoseconds", TimeUnit.NANOSECONDS);
        PrometheusFormat.addTimeConverter("microseconds", TimeUnit.MICROSECONDS);
        PrometheusFormat.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        PrometheusFormat.addTimeConverter("seconds", TimeUnit.SECONDS);
        PrometheusFormat.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        PrometheusFormat.addTimeConverter("minutes", TimeUnit.MINUTES);
        PrometheusFormat.addTimeConverter("hours", TimeUnit.HOURS);
        PrometheusFormat.addTimeConverter("days", TimeUnit.DAYS);
        PrometheusFormat.addConverter(new Units("bits", "bytes", o -> ((Number)o).doubleValue() / 8.0));
        PrometheusFormat.addByteConverter("kilobits", 125L);
        PrometheusFormat.addByteConverter("megabits", 125000L);
        PrometheusFormat.addByteConverter("gigabits", 125000000L);
        PrometheusFormat.addByteConverter("kibibits", 128L);
        PrometheusFormat.addByteConverter("mebibits", 131072L);
        PrometheusFormat.addByteConverter("gibibits", 0x8000000L);
        PrometheusFormat.addByteConverter("kilobytes", 1000L);
        PrometheusFormat.addByteConverter("megabytes", 1000000L);
        PrometheusFormat.addByteConverter("gigabytes", 1000000000L);
        PrometheusFormat.addConverter(new Units("fahrenheits", "celsius", o -> (((Number)o).doubleValue() - 32.0) * 5.0 / 9.0));
        PrometheusFormat.addConverter(new LengthUnits("millimeters", 0.001));
        PrometheusFormat.addConverter(new LengthUnits("centimeters", 0.01));
        PrometheusFormat.addConverter(new LengthUnits("kilometers", 1000.0));
    }

    static class Units {
        private final String metricUnit;
        private final String prometheusUnit;
        private final Function<Object, Object> converter;

        Units(String unit) {
            this.metricUnit = unit;
            this.prometheusUnit = unit;
            this.converter = o -> o;
        }

        private Units(String metricUnit, String prometheusUnit, Function<Object, Object> converter) {
            this.metricUnit = metricUnit;
            this.prometheusUnit = prometheusUnit;
            this.converter = converter;
        }

        public Object convert(Object value) {
            double num;
            Object apply = this.converter.apply(value);
            if (apply instanceof Double && Math.floor(num = ((Double)apply).doubleValue()) == num) {
                return (long)num;
            }
            return apply;
        }

        String getMetricUnit() {
            return this.metricUnit;
        }

        Optional<String> getPrometheusUnit() {
            return Optional.ofNullable(this.prometheusUnit);
        }
    }

    static final class TimeUnits
    extends Units {
        static final TimeUnits PROMETHEUS_TIMER_CONVERSION_TIME_UNITS = new TimeUnits("seconds", TimeUnit.NANOSECONDS);
        private static final long MILLISECONDS = 1000L;
        private static final long MICROSECONDS = 1000000L;
        private static final long NANOSECONDS = 1000000000L;
        private static final String DOUBLE_NAN = String.valueOf(Double.NaN);
        private static final BiFunction<Object, Function<Object, Object>, Object> CHECK_NANS = (o, f) -> o instanceof Double && ((Double)o).isNaN() ? DOUBLE_NAN : f.apply(o);

        private TimeUnits(String metricUnit, TimeUnit timeUnit) {
            super(metricUnit, "seconds", TimeUnits.timeConverter(timeUnit));
        }

        static Function<Object, Object> timeConverter(TimeUnit from) {
            return switch (from) {
                case TimeUnit.NANOSECONDS -> o -> CHECK_NANS.apply(o, PrometheusFormat::convertNanos);
                case TimeUnit.MICROSECONDS -> o -> CHECK_NANS.apply(o, PrometheusFormat::convertMicros);
                case TimeUnit.MILLISECONDS -> o -> CHECK_NANS.apply(o, PrometheusFormat::convertMillis);
                case TimeUnit.SECONDS -> o -> CHECK_NANS.apply(o, String::valueOf);
                default -> o -> CHECK_NANS.apply(o, it -> PrometheusFormat.convertTime(it, from));
            };
        }
    }

    static class PrometheusName {
        private final String prometheusTags;
        private final MetricID metricID;
        private final String prometheusNameWithUnits;
        private final String prometheusName;
        private final String prometheusUnit;
        private final Units units;
        private final String registryType;
        private final Metadata metadata;

        private PrometheusName(String registryType, Metadata metadata, MetricID metricID, Units units, String baseName) {
            this.registryType = registryType;
            this.metadata = metadata;
            this.metricID = metricID;
            this.units = units;
            this.prometheusName = baseName;
            this.prometheusTags = PrometheusFormat.tags(metricID.getTags());
            this.prometheusNameWithUnits = PrometheusFormat.nameWithUnits(registryType, metadata, metricID);
            this.prometheusUnit = units.getPrometheusUnit().orElse("");
        }

        static PrometheusName create(String registryType, Metadata metadata, MetricID metricID, Units units, String baseName) {
            return new PrometheusName(registryType, metadata, metricID, units, baseName);
        }

        Units units() {
            return this.units;
        }

        String nameUnits() {
            return this.prometheusNameWithUnits;
        }

        String nameUnits(Units units) {
            return PrometheusFormat.nameWithUnits(this.registryType, this.metricID.getName(), units);
        }

        String nameStatUnits(String statName) {
            return this.nameStat(statName) + (String)(this.prometheusUnit.isBlank() ? "" : "_" + this.prometheusUnit);
        }

        String nameStat(String statName) {
            return this.prometheusName + "_" + statName;
        }

        String nameStatTags(String statName) {
            return this.nameStat(statName) + this.prometheusTags;
        }

        String nameUnitsSuffixTags(String nameSuffix) {
            return this.prometheusNameWithUnits + "_" + nameSuffix + this.prometheusTags;
        }

        String prometheusTags() {
            return this.prometheusTags;
        }
    }

    private static class LengthUnits
    extends Units {
        private LengthUnits(String metricUnit, double ratio) {
            super(metricUnit, "meters", o -> ((Number)o).doubleValue() * ratio);
        }
    }
}

