/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.systemmeters;

import io.helidon.common.Builder;
import io.helidon.metrics.api.BuiltInMeterNameFormat;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.spi.MetersProvider;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class SystemMetersProvider
implements MetersProvider {
    private static final String BYTES = "bytes";
    private static final String SECONDS = "seconds";
    private static final String SCOPE = "base";
    private static final Map<String, String> CAMEL_TO_SNAKE_CASE_METER_NAMES = SystemMetersProvider.initMeterNames();
    private static final Metadata.Builder MEMORY_USED_HEAP = Metadata.builder().withName("memory.usedHeap").withDescription("Displays the amount of used heap memory in bytes.").withUnit("bytes");
    private static final Metadata.Builder MEMORY_COMMITTED_HEAP = Metadata.builder().withName("memory.committedHeap").withDescription("Displays the amount of memory in bytes that is committed for the Java virtual machine to use. This amount of memory is guaranteed for the Java virtual machine to use.").withUnit("bytes");
    private static final Metadata.Builder MEMORY_MAX_HEAP = Metadata.builder().withName("memory.maxHeap").withDescription("Displays the maximum amount of heap memory in bytes that can be used for memory management. This attribute displays -1 if the maximum heap memory size is undefined. This amount of memory is not guaranteed to be available for memory management if it is greater than the amount of committed memory. The Java virtual machine may fail to allocate memory even if the amount of used memory does not exceed this maximum size.").withUnit("bytes");
    private static final Metadata.Builder JVM_UPTIME = Metadata.builder().withName("jvm.uptime").withDescription("Displays the start time of the Java virtual machine in seconds. This attribute displays the approximate time when the Java virtual machine started.").withUnit("seconds");
    private static final Metadata.Builder THREAD_COUNT = Metadata.builder().withName("thread.count").withDescription("Displays the current number of live threads including both daemon and nondaemon threads");
    private static final Metadata.Builder THREAD_DAEMON_COUNT = Metadata.builder().withName("thread.daemon.count").withDescription("Displays the current number of live daemon threads.");
    private static final Metadata.Builder THREAD_MAX_COUNT = Metadata.builder().withName("thread.max.count").withDescription("Displays the peak live thread count since the Java virtual machine started or peak was reset. This includes daemon and non-daemon threads.");
    private static final Metadata.Builder THREAD_STARTS = Metadata.builder().withName("thread.starts").withDescription("Displays the total number of platform threads created and also started since the Java virtual machine started.");
    private static final Metadata.Builder CL_LOADED_COUNT = Metadata.builder().withName("classloader.loadedClasses.count").withDescription("Displays the number of classes that are currently loaded in the Java virtual machine.");
    private static final Metadata.Builder CL_LOADED_TOTAL = Metadata.builder().withName("classloader.loadedClasses.total").withDescription("Displays the total number of classes that have been loaded since the Java virtual machine has started execution.");
    private static final Metadata.Builder CL_UNLOADED_COUNT = Metadata.builder().withName("classloader.unloadedClasses.total").withDescription("Displays the total number of classes unloaded since the Java virtual machine has started execution.");
    private static final Metadata.Builder OS_AVAILABLE_CPU = Metadata.builder().withName("cpu.availableProcessors").withDescription("Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.");
    private static final Metadata.Builder OS_LOAD_AVERAGE = Metadata.builder().withName("cpu.systemLoadAverage").withDescription("Displays the system load average for the last minute. The system load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated is operating system specific but is typically a damped timedependent average. If the load average is not available, a negative value is displayed. This attribute is designed to provide a hint about the system load and may be queried frequently. The load average may be unavailable on some platforms where it is expensive to implement this method.");
    private static final Metadata.Builder GC_TIME = Metadata.builder().withName("gc.time").withDescription("Displays the approximate accumulated collection elapsed time in seconds. This attribute displays -1 if the collection elapsed time is undefined for this collector. The Java virtual machine implementation may use a high resolution timer to measure the elapsed time. This attribute may display the same value even if the collection count has been incremented if the collection elapsed time is very short.").withUnit("seconds");
    private static final Metadata.Builder GC_COUNT = Metadata.builder().withName("gc.total").withDescription("Displays the total number of collections that have occurred. This attribute lists -1 if the collection count is undefined for this collector.");
    private MetricsFactory metricsFactory;

    @Deprecated
    public SystemMetersProvider() {
    }

    private static Map<String, String> initMeterNames() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("memory.usedHeap", "memory.used_heap");
        result.put("memory.committedHeap", "memory.committed_heap");
        result.put("memory.maxHeap", "memory.max_heap");
        result.put("classloader.loadedClasses.count", "classloader.loaded_classes.count");
        result.put("classloader.loadedClasses.total", "classloader.loaded_classes.total");
        result.put("classloader.unloadedClasses.total", "classloader.unloaded_classes.total");
        result.put("cpu.availableProcessors", "cpu.available_processors");
        result.put("cpu.systemLoadAverage", "cpu.system_load_average");
        return result;
    }

    public Collection<Meter.Builder<?, ?>> meterBuilders(MetricsFactory metricsFactory) {
        this.metricsFactory = metricsFactory;
        return this.prepareMeterBuilders();
    }

    private static <M, S, N extends Number> Function<M, N> typedFn(Function<M, S> getSubBeanFn, Function<S, N> valueFn) {
        return main -> (Number)valueFn.apply(getSubBeanFn.apply(main));
    }

    private Metadata metadata(Metadata.Builder metadataBuilderWithCamelCaseName) {
        String camelCaseName = metadataBuilderWithCamelCaseName.name;
        Metadata.Builder builder = metadataBuilderWithCamelCaseName;
        if (this.metricsFactory.metricsConfig().builtInMeterNameFormat() == BuiltInMeterNameFormat.SNAKE) {
            builder = Metadata.builder().withName(CAMEL_TO_SNAKE_CASE_METER_NAMES.getOrDefault(camelCaseName, camelCaseName)).withDescription(metadataBuilderWithCamelCaseName.description).withUnit(metadataBuilderWithCamelCaseName.baseUnit);
        }
        return builder.build();
    }

    private <B extends Meter.Builder<B, M>, M extends Meter> Collection<Meter.Builder<?, ?>> prepareMeterBuilders() {
        ArrayList result = new ArrayList();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        this.registerGauge(result, this.metadata(MEMORY_USED_HEAP), memoryBean, SystemMetersProvider.typedFn(MemoryMXBean::getHeapMemoryUsage, MemoryUsage::getUsed), new Tag[0]);
        this.registerGauge(result, this.metadata(MEMORY_COMMITTED_HEAP), memoryBean, SystemMetersProvider.typedFn(MemoryMXBean::getHeapMemoryUsage, MemoryUsage::getCommitted), new Tag[0]);
        this.registerGauge(result, this.metadata(MEMORY_MAX_HEAP), memoryBean, SystemMetersProvider.typedFn(MemoryMXBean::getHeapMemoryUsage, MemoryUsage::getMax), new Tag[0]);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        this.registerGauge(result, this.metadata(JVM_UPTIME), runtimeBean, rtBean -> (double)rtBean.getUptime() / 1000.0, new Tag[0]);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        this.registerGauge(result, this.metadata(THREAD_COUNT), threadBean, ThreadMXBean::getThreadCount, new Tag[0]);
        this.registerGauge(result, this.metadata(THREAD_DAEMON_COUNT), threadBean, ThreadMXBean::getDaemonThreadCount, new Tag[0]);
        this.registerGauge(result, this.metadata(THREAD_MAX_COUNT), threadBean, ThreadMXBean::getPeakThreadCount, new Tag[0]);
        this.registerGauge(result, this.metadata(THREAD_STARTS), threadBean, ThreadMXBean::getTotalStartedThreadCount, new Tag[0]);
        ClassLoadingMXBean clBean = ManagementFactory.getClassLoadingMXBean();
        this.registerGauge(result, this.metadata(CL_LOADED_COUNT), clBean, ClassLoadingMXBean::getLoadedClassCount, new Tag[0]);
        this.registerFunctionalCounter(result, this.metadata(CL_LOADED_TOTAL), clBean, ClassLoadingMXBean::getTotalLoadedClassCount, new Tag[0]);
        this.registerFunctionalCounter(result, this.metadata(CL_UNLOADED_COUNT), clBean, ClassLoadingMXBean::getUnloadedClassCount, new Tag[0]);
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        this.registerGauge(result, this.metadata(OS_AVAILABLE_CPU), osBean, OperatingSystemMXBean::getAvailableProcessors, new Tag[0]);
        this.registerGauge(result, this.metadata(OS_LOAD_AVERAGE), osBean, OperatingSystemMXBean::getSystemLoadAverage, new Tag[0]);
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            String poolName = gcBean.getName();
            this.registerFunctionalCounter(result, this.metadata(GC_COUNT), gcBean, GarbageCollectorMXBean::getCollectionCount, Tag.create((String)"name", (String)poolName));
            if (this.isGcTimeGauge()) {
                this.registerGauge(result, this.metadata(GC_TIME), gcBean, bean -> (long)((double)bean.getCollectionTime() / 1000.0), Tag.create((String)"name", (String)poolName));
                continue;
            }
            this.registerFunctionalCounter(result, this.metadata(GC_TIME), gcBean, bean -> (long)((double)bean.getCollectionTime() / 1000.0), Tag.create((String)"name", (String)poolName));
        }
        return result;
    }

    private <T, R extends Number> void registerGauge(Collection<Meter.Builder<?, ?>> result, Metadata metadata, T object, Function<T, R> fn, Tag ... tags) {
        result.add(((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)this.metricsFactory.gaugeBuilder(metadata.name, object, obj -> ((Number)fn.apply(obj)).doubleValue()).scope(SCOPE)).description(metadata.description)).baseUnit(metadata.baseUnit)).tags(Arrays.asList(tags)));
    }

    private <T> void registerFunctionalCounter(Collection<Meter.Builder<?, ?>> result, Metadata metadata, T object, Function<T, Long> fn, Tag ... tags) {
        result.add(((FunctionalCounter.Builder)((FunctionalCounter.Builder)((FunctionalCounter.Builder)this.metricsFactory.functionalCounterBuilder(metadata.name, object, fn).scope(SCOPE)).description(metadata.description)).baseUnit(metadata.baseUnit)).tags(Arrays.asList(tags)));
    }

    @Deprecated(since="4.1", forRemoval=true)
    private boolean isGcTimeGauge() {
        return this.metricsFactory.metricsConfig().gcTimeType().name().equals("GAUGE");
    }

    private static class Metadata {
        private final String name;
        private final String description;
        private final String baseUnit;

        private Metadata(Builder builder) {
            this.name = builder.name;
            this.description = builder.description;
            this.baseUnit = builder.baseUnit;
        }

        static Builder builder() {
            return new Builder();
        }

        private static class Builder
        implements io.helidon.common.Builder<Builder, Metadata> {
            private String name;
            private String description;
            private String baseUnit;

            private Builder() {
            }

            public Metadata build() {
                return new Metadata(this);
            }

            Builder withName(String name) {
                this.name = name;
                return this;
            }

            Builder withDescription(String description) {
                this.description = description;
                return this;
            }

            Builder withUnit(String unit) {
                this.baseUnit = unit;
                return this;
            }
        }
    }
}

