/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.http.Http;
import io.helidon.common.http.MediaType;
import io.helidon.config.Config;
import io.helidon.config.DeprecatedConfig;
import io.helidon.media.common.MessageBodyWriter;
import io.helidon.media.jsonp.JsonpSupport;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.Registry;
import io.helidon.metrics.RegistryFactory;
import io.helidon.webserver.Handler;
import io.helidon.webserver.RequestHeaders;
import io.helidon.webserver.Routing;
import io.helidon.webserver.ServerRequest;
import io.helidon.webserver.ServerResponse;
import io.helidon.webserver.Service;
import io.helidon.webserver.cors.CorsEnabledServiceHelper;
import io.helidon.webserver.cors.CrossOriginConfig;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

public final class MetricsSupport
implements Service {
    private static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final String DEFAULT_CONTEXT = "/metrics";
    private static final String SERVICE_NAME = "Metrics";
    private static final MessageBodyWriter<JsonStructure> JSONP_WRITER = JsonpSupport.writer();
    private final String context;
    private final RegistryFactory rf;
    private final CorsEnabledServiceHelper corsEnabledServiceHelper;
    private static final Logger LOGGER = Logger.getLogger(MetricsSupport.class.getName());

    private MetricsSupport(Builder builder) {
        this.rf = builder.registryFactory.get();
        this.context = builder.context;
        this.corsEnabledServiceHelper = CorsEnabledServiceHelper.create((String)SERVICE_NAME, (CrossOriginConfig)builder.crossOriginConfig);
    }

    public static MetricsSupport create() {
        return MetricsSupport.builder().build();
    }

    public static MetricsSupport create(Config config) {
        return MetricsSupport.builder().config(config).build();
    }

    static JsonObjectBuilder createMergingJsonObjectBuilder(JsonObjectBuilder delegate) {
        return new MergingJsonObjectBuilder(delegate);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static MediaType findBestAccepted(RequestHeaders headers) {
        Optional mediaType = headers.bestAccepted(new MediaType[]{MediaType.TEXT_PLAIN, MediaType.APPLICATION_JSON});
        return mediaType.orElse(null);
    }

    private static void getAll(ServerRequest req, ServerResponse res, Registry registry) {
        if (registry.empty()) {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        MediaType mediaType = MetricsSupport.findBestAccepted(req.headers());
        if (mediaType == MediaType.APPLICATION_JSON) {
            MetricsSupport.sendJson(res, MetricsSupport.toJsonData(registry));
        } else if (mediaType == MediaType.TEXT_PLAIN) {
            res.send((Object)MetricsSupport.toPrometheusData(registry));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsAll(ServerRequest req, ServerResponse res, Registry registry) {
        if (registry.empty()) {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
            return;
        }
        if (req.headers().isAccepted(MediaType.APPLICATION_JSON)) {
            MetricsSupport.sendJson(res, MetricsSupport.toJsonMeta(registry));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    static String toPrometheusData(Registry ... registries) {
        return Arrays.stream(registries).filter(r -> !r.empty()).map(MetricsSupport::toPrometheusData).collect(Collectors.joining());
    }

    static String toPrometheusData(Registry registry) {
        StringBuilder builder = new StringBuilder();
        HashSet serialized = new HashSet();
        registry.stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            String name = ((MetricID)entry.getKey()).getName();
            if (!serialized.contains(name)) {
                MetricsSupport.toPrometheusData(builder, (MetricID)entry.getKey(), (Metric)entry.getValue(), true);
                serialized.add(name);
            } else {
                MetricsSupport.toPrometheusData(builder, (MetricID)entry.getKey(), (Metric)entry.getValue(), false);
            }
        });
        return builder.toString();
    }

    public static String toPrometheusData(MetricID metricID, Metric metric, boolean withHelpType) {
        StringBuilder sb = new StringBuilder();
        MetricsSupport.checkMetricTypeThenRun(sb, metricID, metric, withHelpType);
        return sb.toString();
    }

    public static String toPrometheusData(String name, Metric metric, boolean withHelpType) {
        return MetricsSupport.toPrometheusData(new MetricID(name), metric, withHelpType);
    }

    static void toPrometheusData(StringBuilder sb, MetricID metricID, Metric metric, boolean withHelpType) {
        MetricsSupport.checkMetricTypeThenRun(sb, metricID, metric, withHelpType);
    }

    private static void checkMetricTypeThenRun(StringBuilder sb, MetricID metricID, Metric metric, boolean withHelpType) {
        Objects.requireNonNull(metric);
        if (!(metric instanceof HelidonMetric)) {
            throw new IllegalArgumentException(String.format("Metric of type %s is expected to implement %s but does not", metric.getClass().getName(), HelidonMetric.class.getName()));
        }
        ((HelidonMetric)metric).prometheusData(sb, metricID, withHelpType);
    }

    static JsonObject toJsonData(Registry ... registries) {
        return MetricsSupport.toJson(MetricsSupport::toJsonData, registries);
    }

    static JsonObject toJsonData(Registry registry) {
        return MetricsSupport.toJson((JsonObjectBuilder builder, ? super Map.Entry<MetricID, HelidonMetric> entry) -> ((HelidonMetric)entry.getValue()).jsonData((JsonObjectBuilder)builder, (MetricID)entry.getKey()), registry);
    }

    static JsonObject toJsonMeta(Registry ... registries) {
        return MetricsSupport.toJson(MetricsSupport::toJsonMeta, registries);
    }

    static JsonObject toJsonMeta(Registry registry) {
        return MetricsSupport.toJson((JsonObjectBuilder builder, ? super Map.Entry<MetricID, HelidonMetric> entry) -> {
            MetricID metricID = (MetricID)entry.getKey();
            HelidonMetric metric = (HelidonMetric)entry.getValue();
            List<MetricID> sameNamedIDs = registry.metricIDsForName(metricID.getName());
            metric.jsonMeta((JsonObjectBuilder)builder, sameNamedIDs);
        }, registry);
    }

    private static JsonObject toJson(Function<Registry, JsonObject> fn, Registry ... registries) {
        return Arrays.stream(registries).filter(r -> !r.empty()).collect(() -> ((JsonBuilderFactory)JSON).createObjectBuilder(), (builder, registry) -> MetricsSupport.accumulateJson(builder, registry, fn), JsonObjectBuilder::addAll).build();
    }

    private static void accumulateJson(JsonObjectBuilder builder, Registry registry, Function<Registry, JsonObject> fn) {
        builder.add(registry.type(), (JsonValue)fn.apply(registry));
    }

    private static JsonObject toJson(BiConsumer<JsonObjectBuilder, ? super Map.Entry<MetricID, HelidonMetric>> accumulator, Registry registry) {
        return registry.stream().sorted(Comparator.comparing(Map.Entry::getKey)).collect(() -> new MergingJsonObjectBuilder(JSON.createObjectBuilder()), accumulator, JsonObjectBuilder::addAll).build();
    }

    public void configureVendorMetrics(String routingName, Routing.Rules rules) {
        String metricPrefix = (String)(null == routingName ? "" : routingName + ".") + "requests.";
        Registry vendor = this.rf.getARegistry(MetricRegistry.Type.VENDOR);
        Counter totalCount = vendor.counter(Metadata.builder().withName(metricPrefix + "count").withDisplayName("Total number of HTTP requests").withDescription("Each request (regardless of HTTP method) will increase this counter").withType(MetricType.COUNTER).withUnit("none").build());
        Meter totalMeter = vendor.meter(Metadata.builder().withName(metricPrefix + "meter").withDisplayName("Meter for overall HTTP requests").withDescription("Each request will mark the meter to see overall throughput").withType(MetricType.METERED).withUnit("none").build());
        rules.any(new Handler[]{(req, res) -> {
            totalCount.inc();
            totalMeter.mark();
            req.next();
        }});
    }

    public void configureEndpoint(Routing.Rules rules) {
        Registry base = this.rf.getARegistry(MetricRegistry.Type.BASE);
        Registry vendor = this.rf.getARegistry(MetricRegistry.Type.VENDOR);
        Registry app = this.rf.getARegistry(MetricRegistry.Type.APPLICATION);
        rules.any(this.context, new Handler[]{this.corsEnabledServiceHelper.processor()});
        rules.any(new Handler[]{new MetricsContextHandler(app, this.rf)});
        rules.get(this.context, new Handler[]{(req, res) -> this.getMultiple(req, res, base, app, vendor)}).options(this.context, new Handler[]{(req, res) -> this.optionsMultiple(req, res, base, app, vendor)});
        Stream.of(app, base, vendor).forEach(registry -> {
            String type = registry.type();
            rules.get(this.context + "/" + type, new Handler[]{(req, res) -> MetricsSupport.getAll(req, res, registry)}).get(this.context + "/" + type + "/{metric}", new Handler[]{(req, res) -> this.getByName(req, res, (Registry)((Object)registry))}).options(this.context + "/" + type, new Handler[]{(req, res) -> this.optionsAll(req, res, (Registry)((Object)registry))}).options(this.context + "/" + type + "/{metric}", new Handler[]{(req, res) -> this.optionsOne(req, res, (Registry)((Object)registry))});
        });
    }

    public void update(Routing.Rules rules) {
        this.configureVendorMetrics(null, rules);
        this.configureEndpoint(rules);
    }

    private void getByName(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().param("metric");
        registry.getOptionalMetricEntry(metricName).ifPresentOrElse(entry -> {
            MediaType mediaType = MetricsSupport.findBestAccepted(req.headers());
            if (mediaType == MediaType.APPLICATION_JSON) {
                MetricsSupport.sendJson(res, MetricsSupport.jsonDataByName(registry, metricName));
            } else if (mediaType == MediaType.TEXT_PLAIN) {
                res.send((Object)MetricsSupport.prometheusDataByName(registry, metricName));
            } else {
                res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
                res.send();
            }
        }, () -> {
            res.status((Http.ResponseStatus)Http.Status.NOT_FOUND_404);
            res.send();
        });
    }

    static JsonObject jsonDataByName(Registry registry, String metricName) {
        MergingJsonObjectBuilder builder = new MergingJsonObjectBuilder(JSON.createObjectBuilder());
        for (Map.Entry<MetricID, HelidonMetric> metricEntry : registry.getMetricsByName(metricName)) {
            metricEntry.getValue().jsonData(builder, metricEntry.getKey());
        }
        return builder.build();
    }

    static String prometheusDataByName(Registry registry, String metricName) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<MetricID, HelidonMetric> metricEntry : registry.getMetricsByName(metricName)) {
            metricEntry.getValue().prometheusData(sb, metricEntry.getKey(), isFirst);
            isFirst = false;
        }
        return sb.toString();
    }

    private static void sendJson(ServerResponse res, JsonObject object) {
        res.send(JSONP_WRITER.marshall((Object)object));
    }

    private void getMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        MediaType mediaType = MetricsSupport.findBestAccepted(req.headers());
        if (mediaType == MediaType.APPLICATION_JSON) {
            MetricsSupport.sendJson(res, MetricsSupport.toJsonData(registries));
        } else if (mediaType == MediaType.TEXT_PLAIN) {
            res.send((Object)MetricsSupport.toPrometheusData(registries));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsMultiple(ServerRequest req, ServerResponse res, Registry ... registries) {
        if (req.headers().isAccepted(MediaType.APPLICATION_JSON)) {
            MetricsSupport.sendJson(res, MetricsSupport.toJsonMeta(registries));
        } else {
            res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
            res.send();
        }
    }

    private void optionsOne(ServerRequest req, ServerResponse res, Registry registry) {
        String metricName = req.path().param("metric");
        registry.getOptionalMetricWithIDsEntry(metricName).ifPresentOrElse(entry -> {
            if (req.headers().isAccepted(MediaType.APPLICATION_JSON)) {
                JsonObjectBuilder builder = JSON.createObjectBuilder();
                ((HelidonMetric)HelidonMetric.class.cast(entry.getKey())).jsonMeta(builder, (List)entry.getValue());
                MetricsSupport.sendJson(res, builder.build());
            } else {
                res.status((Http.ResponseStatus)Http.Status.NOT_ACCEPTABLE_406);
                res.send();
            }
        }, () -> {
            res.status((Http.ResponseStatus)Http.Status.NO_CONTENT_204);
            res.send();
        });
    }

    static final class MergingJsonObjectBuilder
    implements JsonObjectBuilder {
        private final JsonObjectBuilder delegate;
        private final Map<String, List<JsonObject>> subValuesMap = new HashMap<String, List<JsonObject>>();
        private final Map<String, List<JsonArray>> subArraysMap = new HashMap<String, List<JsonArray>>();

        MergingJsonObjectBuilder(JsonObjectBuilder delegate) {
            this.delegate = delegate;
        }

        public JsonObjectBuilder add(String name, JsonObjectBuilder subBuilder) {
            List<Object> subValues;
            JsonObject ob = subBuilder.build();
            this.delegate.add(name, JSON.createObjectBuilder(ob));
            if (this.subValuesMap.containsKey(name)) {
                subValues = this.subValuesMap.get(name);
            } else {
                subValues = new ArrayList();
                this.subValuesMap.put(name, subValues);
            }
            subValues.add(ob);
            return this;
        }

        public JsonObjectBuilder add(String name, JsonArrayBuilder arrayBuilder) {
            List<Object> subArrays;
            JsonArray array = arrayBuilder.build();
            this.delegate.add(name, JSON.createArrayBuilder(array));
            if (this.subArraysMap.containsKey(name)) {
                subArrays = this.subArraysMap.get(name);
            } else {
                subArrays = new ArrayList();
                this.subArraysMap.put(name, subArrays);
            }
            subArrays.add(array);
            return this;
        }

        public JsonObjectBuilder add(String arg0, JsonValue arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, String arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, BigInteger arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, BigDecimal arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, int arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, long arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, double arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder add(String arg0, boolean arg1) {
            this.delegate.add(arg0, arg1);
            return this;
        }

        public JsonObjectBuilder addNull(String arg0) {
            this.delegate.addNull(arg0);
            return this;
        }

        public JsonObjectBuilder addAll(JsonObjectBuilder builder) {
            this.delegate.addAll(builder);
            return this;
        }

        public JsonObjectBuilder remove(String name) {
            this.delegate.remove(name);
            return this;
        }

        public JsonObject build() {
            JsonObject beforeMerging = this.delegate.build();
            if (this.subValuesMap.isEmpty() && this.subArraysMap.isEmpty()) {
                return beforeMerging;
            }
            JsonObjectBuilder mainBuilder = JSON.createObjectBuilder(beforeMerging);
            this.subValuesMap.entrySet().stream().forEach(entry -> {
                JsonObjectBuilder metricBuilder = JSON.createObjectBuilder();
                for (JsonObject subObject : (List)entry.getValue()) {
                    JsonObjectBuilder subBuilder = JSON.createObjectBuilder(subObject);
                    metricBuilder.addAll(subBuilder);
                }
                mainBuilder.add((String)entry.getKey(), metricBuilder);
            });
            this.subArraysMap.entrySet().stream().forEach(entry -> {
                JsonArrayBuilder arrayBuilder = JSON.createArrayBuilder();
                for (JsonArray subArray : (List)entry.getValue()) {
                    JsonArrayBuilder subArrayBuilder = JSON.createArrayBuilder(subArray);
                    arrayBuilder.add(subArrayBuilder);
                }
                mainBuilder.add((String)entry.getKey(), arrayBuilder);
            });
            return mainBuilder.build();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }

    private static final class MetricsContextHandler
    implements Handler {
        private final Registry appRegistry;
        private final RegistryFactory registryFactory;

        private MetricsContextHandler(Registry appRegistry, RegistryFactory registryFactory) {
            this.appRegistry = appRegistry;
            this.registryFactory = registryFactory;
        }

        public void accept(ServerRequest req, ServerResponse res) {
            req.context().register((Object)this.appRegistry);
            req.context().register((Object)this.registryFactory);
            req.next();
        }
    }

    public static final class Builder
    implements io.helidon.common.Builder<MetricsSupport> {
        private Supplier<RegistryFactory> registryFactory;
        private String context = "/metrics";
        private Config config = Config.empty();
        private CrossOriginConfig crossOriginConfig = null;

        private Builder() {
        }

        public MetricsSupport build() {
            if (null == this.registryFactory) {
                this.registryFactory = () -> RegistryFactory.getInstance(this.config);
            }
            return new MetricsSupport(this);
        }

        public Builder config(Config config) {
            this.config = config;
            DeprecatedConfig.get((Config)config, (String)"web-context", (String)"context").asString().ifPresent(this::webContext);
            config.get("cors").as(CrossOriginConfig::create).ifPresent(this::crossOriginConfig);
            if (!((Boolean)config.get("base.enabled").asBoolean().orElse((Object)true)).booleanValue()) {
                LOGGER.finest("Metrics support for base metrics is disabled in configuration");
            }
            return this;
        }

        public Builder registryFactory(RegistryFactory factory) {
            this.registryFactory = () -> factory;
            return this;
        }

        public Builder webContext(String path) {
            this.context = path.startsWith("/") ? path : "/" + path;
            return this;
        }

        public Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            Objects.requireNonNull(crossOriginConfig, "CrossOriginConfig must be non-null");
            this.crossOriginConfig = crossOriginConfig;
            return this;
        }
    }
}

