/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.serviceloader.HelidonServiceLoader;
import io.helidon.metrics.ExemplarService;
import java.util.List;
import java.util.ServiceLoader;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

class ExemplarServiceManager {
    private static final Logger LOGGER = Logger.getLogger(ExemplarServiceManager.class.getName());
    private static final List<ExemplarService> EXEMPLAR_SERVICES = ExemplarServiceManager.collectExemplarServices();
    private static final Supplier<String> EXEMPLAR_SUPPLIER = EXEMPLAR_SERVICES.isEmpty() ? () -> "" : () -> EXEMPLAR_SERVICES.stream().map(ExemplarService::label).filter(Predicate.not(String::isBlank)).collect(Collectors.joining(",", "{", "}"));

    private ExemplarServiceManager() {
    }

    static String exemplarLabel() {
        return EXEMPLAR_SUPPLIER.get();
    }

    private static List<ExemplarService> collectExemplarServices() {
        List exemplarServices = HelidonServiceLoader.create(ServiceLoader.load(ExemplarService.class)).asList();
        if (!exemplarServices.isEmpty()) {
            LOGGER.log(Level.INFO, "Using metrics ExemplarServices " + exemplarServices.toString());
        }
        return exemplarServices;
    }
}

