/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonGauge<T>
extends MetricImpl
implements Gauge<T> {
    private final Supplier<T> value = () -> metric.getValue();

    private HelidonGauge(String registryType, Metadata metadata, Gauge<T> metric) {
        super(registryType, metadata);
    }

    static <S> HelidonGauge<S> create(String registryType, Metadata metadata, Gauge<S> metric) {
        return new HelidonGauge<S>(registryType, metadata, metric);
    }

    public T getValue() {
        return this.value.get();
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusNameWithUnits(metricID.getName(), this.getUnits().getPrometheusUnit());
    }

    @Override
    public String prometheusValue() {
        return this.getUnits().convert(this.getValue()).toString();
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        T untypedValue = this.getValue();
        String nameWithTags = HelidonGauge.jsonFullKey(metricID);
        if (untypedValue instanceof Number) {
            Number value = (Number)untypedValue;
            if (value instanceof AtomicInteger) {
                builder.add(nameWithTags, value.doubleValue());
            } else if (value instanceof AtomicLong) {
                builder.add(nameWithTags, value.longValue());
            } else if (value instanceof BigDecimal) {
                builder.add(nameWithTags, (BigDecimal)value);
            } else if (value instanceof BigInteger) {
                builder.add(nameWithTags, (BigInteger)value);
            } else if (value instanceof Byte) {
                builder.add(nameWithTags, value.intValue());
            } else if (value instanceof Double) {
                builder.add(nameWithTags, ((Double)value).doubleValue());
            } else if (value instanceof DoubleAccumulator) {
                builder.add(nameWithTags, value.doubleValue());
            } else if (value instanceof DoubleAdder) {
                builder.add(nameWithTags, value.doubleValue());
            } else if (value instanceof Float) {
                builder.add(nameWithTags, (double)value.floatValue());
            } else if (value instanceof Integer) {
                builder.add(nameWithTags, ((Integer)value).intValue());
            } else if (value instanceof Long) {
                builder.add(nameWithTags, ((Long)value).longValue());
            } else if (value instanceof LongAccumulator) {
                builder.add(nameWithTags, value.longValue());
            } else if (value instanceof LongAdder) {
                builder.add(nameWithTags, value.longValue());
            } else if (value instanceof Short) {
                builder.add(nameWithTags, value.intValue());
            } else {
                builder.add(nameWithTags, value.doubleValue());
            }
        } else {
            builder.add(nameWithTags, String.valueOf(this.value));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonGauge that = (HelidonGauge)o;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }
}

