/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.DisplayableLabeledSnapshot;
import io.helidon.metrics.ExemplarServiceManager;
import io.helidon.metrics.ExponentiallyDecayingReservoir;
import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.WeightedSnapshot;
import io.helidon.metrics.WrappedSnapshot;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Snapshot;

final class HelidonHistogram
extends MetricImpl
implements Histogram {
    private final Histogram delegate;

    private HelidonHistogram(String type, Metadata metadata, Histogram delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonHistogram create(String type, Metadata metadata) {
        return HelidonHistogram.create(type, metadata, Clock.system());
    }

    static HelidonHistogram create(String type, Metadata metadata, Clock clock) {
        return new HelidonHistogram(type, metadata, new HistogramImpl(clock));
    }

    static HelidonHistogram create(String type, Metadata metadata, Histogram delegate) {
        return new HelidonHistogram(type, metadata, delegate);
    }

    public void update(int value) {
        this.delegate.update(value);
    }

    public void update(long value) {
        this.delegate.update(value);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public Snapshot getSnapshot() {
        return this.delegate.getSnapshot();
    }

    DisplayableLabeledSnapshot snapshot() {
        return this.delegate instanceof HistogramImpl ? ((HistogramImpl)this.delegate).snapshot() : WrappedSnapshot.create(this.delegate.getSnapshot());
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType) {
        this.appendPrometheusHistogramElements(sb, metricID, withHelpType, this.getCount(), this.snapshot());
    }

    @Override
    public String prometheusValue() {
        throw new UnsupportedOperationException("Not supported.");
    }

    HistogramImpl getDelegate() {
        return this.delegate instanceof HistogramImpl ? (HistogramImpl)this.delegate : (this.delegate instanceof HelidonHistogram ? ((HelidonHistogram)this.delegate).getDelegate() : null);
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonHistogram.jsonFullKey("count", metricID), this.getCount());
        Snapshot snapshot = this.getSnapshot();
        myBuilder = myBuilder.add(HelidonHistogram.jsonFullKey("min", metricID), snapshot.getMin()).add(HelidonHistogram.jsonFullKey("max", metricID), snapshot.getMax()).add(HelidonHistogram.jsonFullKey("mean", metricID), snapshot.getMean()).add(HelidonHistogram.jsonFullKey("stddev", metricID), snapshot.getStdDev()).add(HelidonHistogram.jsonFullKey("p50", metricID), snapshot.getMedian()).add(HelidonHistogram.jsonFullKey("p75", metricID), snapshot.get75thPercentile()).add(HelidonHistogram.jsonFullKey("p95", metricID), snapshot.get95thPercentile()).add(HelidonHistogram.jsonFullKey("p98", metricID), snapshot.get98thPercentile()).add(HelidonHistogram.jsonFullKey("p99", metricID), snapshot.get99thPercentile()).add(HelidonHistogram.jsonFullKey("p999", metricID), snapshot.get999thPercentile());
        builder.add(metricID.getName(), myBuilder);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonHistogram that = (HelidonHistogram)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    static final class HistogramImpl
    implements Histogram {
        private final LongAdder counter = new LongAdder();
        private final ExponentiallyDecayingReservoir reservoir;

        private HistogramImpl(Clock clock) {
            this.reservoir = new ExponentiallyDecayingReservoir(clock);
        }

        public void update(int value) {
            this.update((long)value);
        }

        public void update(long value) {
            this.counter.increment();
            this.reservoir.update(value, ExemplarServiceManager.exemplarLabel());
        }

        public void update(long value, long timestamp) {
            this.counter.increment();
            this.reservoir.update(value, timestamp, ExemplarServiceManager.exemplarLabel());
        }

        public long getCount() {
            return this.counter.sum();
        }

        public Snapshot getSnapshot() {
            return this.reservoir.getSnapshot();
        }

        WeightedSnapshot snapshot() {
            return this.reservoir.getSnapshot();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getCount());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistogramImpl that = (HistogramImpl)o;
            return this.getCount() == that.getCount();
        }
    }
}

