/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.EWMA;
import io.helidon.metrics.MetricImpl;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonMeter
extends MetricImpl
implements Meter {
    private static final long TICK_INTERVAL = TimeUnit.SECONDS.toNanos(5L);
    private final Meter delegate;

    private HelidonMeter(String type, Metadata metadata, Meter delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonMeter create(String type, Metadata metadata) {
        return HelidonMeter.create(type, metadata, Clock.system());
    }

    static HelidonMeter create(String type, Metadata metadata, Clock clock) {
        return new HelidonMeter(type, metadata, new MeterImpl(clock));
    }

    static HelidonMeter create(String type, Metadata metadata, Meter delegate) {
        return new HelidonMeter(type, metadata, delegate);
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType) {
        String name = metricID.getName();
        String nameUnits = this.prometheusNameWithUnits(name, Optional.empty()) + "_total";
        String tags = this.prometheusTags(metricID.getTags());
        if (withHelpType) {
            this.prometheusType(sb, nameUnits, "counter");
            this.prometheusHelp(sb, nameUnits);
        }
        sb.append(nameUnits).append(tags).append(" ").append(this.getCount()).append("\n");
        nameUnits = this.prometheusNameWithUnits(name, Optional.empty()) + "_rate_per_second";
        if (withHelpType) {
            this.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(this.getMeanRate()).append("\n");
        nameUnits = this.prometheusNameWithUnits(name, Optional.empty()) + "_one_min_rate_per_second";
        if (withHelpType) {
            this.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(this.getOneMinuteRate()).append("\n");
        nameUnits = this.prometheusNameWithUnits(name, Optional.empty()) + "_five_min_rate_per_second";
        if (withHelpType) {
            this.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(this.getFiveMinuteRate()).append("\n");
        nameUnits = this.prometheusNameWithUnits(name, Optional.empty()) + "_fifteen_min_rate_per_second";
        if (withHelpType) {
            this.prometheusType(sb, nameUnits, "gauge");
        }
        sb.append(nameUnits).append(tags).append(" ").append(this.getFifteenMinuteRate()).append("\n");
    }

    @Override
    public String prometheusValue() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonMeter.jsonFullKey("count", metricID), this.getCount()).add(HelidonMeter.jsonFullKey("meanRate", metricID), this.getMeanRate()).add(HelidonMeter.jsonFullKey("oneMinRate", metricID), this.getOneMinuteRate()).add(HelidonMeter.jsonFullKey("fiveMinRate", metricID), this.getFiveMinuteRate()).add(HelidonMeter.jsonFullKey("fifteenMinRate", metricID), this.getFifteenMinuteRate());
        builder.add(metricID.getName(), myBuilder);
    }

    public void mark() {
        this.delegate.mark();
    }

    public void mark(long n) {
        this.delegate.mark(n);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.delegate.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.delegate.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.delegate.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.delegate.getOneMinuteRate();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonMeter that = (HelidonMeter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    private static final class MeterImpl
    implements Meter {
        private final EWMA m1Rate = EWMA.oneMinuteEWMA();
        private final EWMA m5Rate = EWMA.fiveMinuteEWMA();
        private final EWMA m15Rate = EWMA.fifteenMinuteEWMA();
        private final LongAdder count = new LongAdder();
        private final long startTime;
        private final AtomicLong lastTick;
        private final Clock clock;

        private MeterImpl(Clock clock) {
            this.startTime = clock.nanoTick();
            this.lastTick = new AtomicLong(this.startTime);
            this.clock = clock;
        }

        public void mark() {
            this.mark(1L);
        }

        public void mark(long n) {
            this.tickIfNecessary();
            this.count.add(n);
            this.m1Rate.update(n);
            this.m5Rate.update(n);
            this.m15Rate.update(n);
        }

        public long getCount() {
            return this.count.sum();
        }

        public double getFifteenMinuteRate() {
            this.tickIfNecessary();
            return this.m15Rate.getRate(TimeUnit.SECONDS);
        }

        public double getFiveMinuteRate() {
            this.tickIfNecessary();
            return this.m5Rate.getRate(TimeUnit.SECONDS);
        }

        public double getMeanRate() {
            if (this.getCount() == 0L) {
                return 0.0;
            }
            double elapsed = this.clock.nanoTick() - this.startTime;
            return (double)this.getCount() / elapsed * (double)TimeUnit.SECONDS.toNanos(1L);
        }

        public double getOneMinuteRate() {
            this.tickIfNecessary();
            return this.m1Rate.getRate(TimeUnit.SECONDS);
        }

        private void tickIfNecessary() {
            long newIntervalStartTick;
            long oldTick = this.lastTick.get();
            long newTick = this.clock.nanoTick();
            long age = newTick - oldTick;
            if (age > TICK_INTERVAL && this.lastTick.compareAndSet(oldTick, newIntervalStartTick = newTick - age % TICK_INTERVAL)) {
                long requiredTicks = age / TICK_INTERVAL;
                for (long i = 0L; i < requiredTicks; ++i) {
                    this.m1Rate.tick();
                    this.m5Rate.tick();
                    this.m15Rate.tick();
                }
            }
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getCount());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MeterImpl that = (MeterImpl)o;
            return this.getCount() == that.getCount();
        }
    }
}

