/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.Sample;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;

final class HelidonSimpleTimer
extends MetricImpl
implements SimpleTimer {
    private final SimpleTimer delegate;

    private HelidonSimpleTimer(String type, Metadata metadata, SimpleTimer delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata) {
        return HelidonSimpleTimer.create(repoType, metadata, Clock.system());
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata, Clock clock) {
        return HelidonSimpleTimer.create(repoType, metadata, new SimpleTimerImpl(repoType, metadata.getName(), clock));
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata, SimpleTimer metric) {
        return new HelidonSimpleTimer(repoType, metadata, metric);
    }

    public void update(Duration duration) {
        this.delegate.update(duration);
    }

    public <T> T time(Callable<T> event) throws Exception {
        return (T)this.delegate.time(event);
    }

    public void time(Runnable event) {
        this.delegate.time(event);
    }

    public SimpleTimer.Context time() {
        return this.delegate.time();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public Duration getElapsedTime() {
        return this.delegate.getElapsedTime();
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType) {
        Sample.Labeled sample;
        String name = metricID.getName();
        String tags = this.prometheusTags(metricID.getTags());
        Object promName = this.prometheusName(name) + "_total";
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "counter");
            this.prometheusHelp(sb, (String)promName);
        }
        sb.append((String)promName).append(tags).append(" ").append(this.getCount());
        SimpleTimerImpl simpleTimerImpl = this.delegate instanceof SimpleTimerImpl ? (SimpleTimerImpl)this.delegate : null;
        Sample.Labeled labeled = sample = simpleTimerImpl != null ? simpleTimerImpl.sample : null;
        if (sample != null) {
            sb.append(this.prometheusExemplar(this.elapsedTimeInSeconds(sample.value()), simpleTimerImpl.sample));
        }
        sb.append("\n");
        promName = this.prometheusNameWithUnits(name + "_elapsedTime", Optional.of("seconds"));
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "gauge");
        }
        sb.append((String)promName).append(tags).append(" ").append(this.elapsedTimeInSeconds());
        if (sample != null) {
            sb.append(this.prometheusExemplar(this.elapsedTimeInSeconds(sample.value()), sample));
        }
        sb.append("\n");
    }

    @Override
    public String prometheusValue() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonSimpleTimer.jsonFullKey("count", metricID), this.getCount()).add(HelidonSimpleTimer.jsonFullKey("elapsedTime", metricID), this.elapsedTimeInSeconds());
        builder.add(metricID.getName(), myBuilder);
    }

    private double elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds(this.getElapsedTime().toNanos());
    }

    private double elapsedTimeInSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonSimpleTimer that = (HelidonSimpleTimer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    private static class SimpleTimerImpl
    implements SimpleTimer {
        private final HelidonCounter counter;
        private final Clock clock;
        private Duration elapsed = Duration.ofNanos(0L);
        private Sample.Labeled sample = null;

        SimpleTimerImpl(String repoType, String name, Clock clock) {
            this.counter = HelidonCounter.create(repoType, Metadata.builder().withName(name).withType(MetricType.COUNTER).build());
            this.clock = clock;
        }

        public void update(Duration duration) {
            this.update(duration.toNanos());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T time(Callable<T> event) throws Exception {
            long t = this.clock.nanoTick();
            try {
                T t2 = event.call();
                return t2;
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void time(Runnable event) {
            long t = this.clock.nanoTick();
            try {
                event.run();
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        public SimpleTimer.Context time() {
            return new ContextImpl(this, this.clock);
        }

        public Duration getElapsedTime() {
            return this.elapsed;
        }

        public long getCount() {
            return this.counter.getCount();
        }

        private void update(long nanos) {
            if (nanos >= 0L) {
                this.counter.inc();
                this.elapsed = this.elapsed.plusNanos(nanos);
                this.sample = Sample.labeled(nanos);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleTimerImpl that = (SimpleTimerImpl)o;
            return this.counter.equals(that.counter) && this.elapsed.equals(that.elapsed);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.counter, this.elapsed);
        }
    }

    private static final class ContextImpl
    implements SimpleTimer.Context {
        private final SimpleTimerImpl theSimpleTimer;
        private final long startTime;
        private final Clock clock;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private Duration elapsed;

        private ContextImpl(SimpleTimerImpl theSimpleTimer, Clock clock) {
            this.theSimpleTimer = theSimpleTimer;
            this.startTime = clock.nanoTick();
            this.clock = clock;
        }

        public long stop() {
            if (this.running.compareAndSet(true, false)) {
                this.elapsed = Duration.ofNanos(this.clock.nanoTick() - this.startTime);
                this.theSimpleTimer.update(this.elapsed);
            }
            return this.elapsed.toNanos();
        }

        public void close() {
            this.stop();
        }
    }
}

