/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.KeyPerformanceIndicatorMetricsSettings;
import io.helidon.metrics.RegistryFactory;
import io.helidon.webserver.KeyPerformanceIndicatorSupport;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;

class KeyPerformanceIndicatorMetricsImpls {
    static final String METRICS_NAME_PREFIX = "requests";
    static final String REQUESTS_COUNT_NAME = "count";
    static final String REQUESTS_METER_NAME = "meter";
    static final String INFLIGHT_REQUESTS_NAME = "inFlight";
    static final String LONG_RUNNING_REQUESTS_NAME = "longRunning";
    static final String LOAD_NAME = "load";
    public static final String DEFERRED_NAME = "deferred";
    static final MetricRegistry.Type KPI_METRICS_REGISTRY_TYPE = MetricRegistry.Type.VENDOR;
    private static final Map<String, KeyPerformanceIndicatorSupport.Metrics> KPI_METRICS = new HashMap<String, KeyPerformanceIndicatorSupport.Metrics>();

    private KeyPerformanceIndicatorMetricsImpls() {
    }

    static KeyPerformanceIndicatorSupport.Metrics get(String metricsNamePrefix, KeyPerformanceIndicatorMetricsSettings kpiConfig) {
        return KPI_METRICS.computeIfAbsent(metricsNamePrefix, prefix -> kpiConfig.isExtended() ? new Extended(metricsNamePrefix, kpiConfig) : new Basic(metricsNamePrefix));
    }

    private static class Extended
    extends Basic {
        private final ConcurrentGauge inflightRequests;
        private final Meter longRunningRequests;
        private final Meter load;
        private final long longRunningRequestThresdholdMs;
        protected static final String LOAD_DISPLAY_NAME = "Requests load";
        protected static final String LOAD_DESCRIPTION = "Measures the total number of in-flight requests and rates at which they occur";

        protected Extended(String metricsNamePrefix, KeyPerformanceIndicatorMetricsSettings kpiConfig) {
            super(metricsNamePrefix);
            this.longRunningRequestThresdholdMs = kpiConfig.longRunningRequestThresholdMs();
            this.inflightRequests = this.kpiMetricRegistry().concurrentGauge(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.INFLIGHT_REQUESTS_NAME).withDisplayName("Current number of in-flight requests").withDescription("Measures the number of currently in-flight requests").withType(MetricType.CONCURRENT_GAUGE).withUnit("none").build());
            this.longRunningRequests = this.kpiMetricRegistry().meter(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.LONG_RUNNING_REQUESTS_NAME).withDisplayName("Long-running requests").withDescription("Measures the total number of long-running requests and rates at which they occur").withType(MetricType.METERED).withUnit("none").build());
            this.load = this.kpiMetricRegistry().meter(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.LOAD_NAME).withDisplayName(LOAD_DISPLAY_NAME).withDescription(LOAD_DESCRIPTION).withType(MetricType.METERED).withUnit("none").build());
            this.kpiMetricRegistry().register(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.DEFERRED_NAME).withDisplayName("Deferred requests").withDescription("Measures deferred requests").withType(MetricType.METERED).withUnit("none").build(), (Metric)new DeferredRequestsMeter(this.totalMeter(), this.load));
        }

        public void onRequestStarted() {
            super.onRequestStarted();
            this.inflightRequests.inc();
            this.load.mark();
        }

        public void onRequestCompleted(boolean isSuccessful, long processingTimeMs) {
            super.onRequestCompleted(isSuccessful, processingTimeMs);
            this.inflightRequests.dec();
            if (processingTimeMs >= this.longRunningRequestThresdholdMs) {
                this.longRunningRequests.mark();
            }
        }

        private static class DeferredRequestsMeter
        implements Meter {
            private final Meter hitRate;
            private final Meter load;

            private DeferredRequestsMeter(Meter hitRate, Meter load) {
                this.hitRate = hitRate;
                this.load = load;
            }

            public void mark() {
            }

            public void mark(long n) {
            }

            public long getCount() {
                return this.hitRate.getCount() - this.load.getCount();
            }

            public double getFifteenMinuteRate() {
                return Double.max(0.0, this.hitRate.getFifteenMinuteRate() - this.load.getFifteenMinuteRate());
            }

            public double getFiveMinuteRate() {
                return Double.max(0.0, this.hitRate.getFiveMinuteRate() - this.load.getFiveMinuteRate());
            }

            public double getMeanRate() {
                return Double.max(0.0, this.hitRate.getMeanRate() - this.load.getMeanRate());
            }

            public double getOneMinuteRate() {
                return Double.max(0.0, this.hitRate.getOneMinuteRate() - this.load.getOneMinuteRate());
            }
        }
    }

    private static class Basic
    implements KeyPerformanceIndicatorSupport.Metrics {
        private final MetricRegistry kpiMetricRegistry = RegistryFactory.getInstance().getRegistry(KPI_METRICS_REGISTRY_TYPE);
        private final Counter totalCount;
        private final Meter totalMeter;

        protected Basic(String metricsNamePrefix) {
            this.totalCount = this.kpiMetricRegistry().counter(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.REQUESTS_COUNT_NAME).withDisplayName("Total number of HTTP requests").withDescription("Each request (regardless of HTTP method) will increase this counter").withType(MetricType.COUNTER).withUnit("none").build());
            this.totalMeter = this.kpiMetricRegistry().meter(Metadata.builder().withName(metricsNamePrefix + KeyPerformanceIndicatorMetricsImpls.REQUESTS_METER_NAME).withDisplayName("Meter for overall HTTP requests").withDescription("Each request will mark the meter to see overall throughput").withType(MetricType.METERED).withUnit("none").build());
        }

        public void onRequestReceived() {
            this.totalCount.inc();
            this.totalMeter.mark();
        }

        protected MetricRegistry kpiMetricRegistry() {
            return this.kpiMetricRegistry;
        }

        protected Meter totalMeter() {
            return this.totalMeter;
        }
    }
}

