/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.KeyPerformanceIndicatorMetricsSettingsImpl;

public interface KeyPerformanceIndicatorMetricsSettings {
    public static Builder builder() {
        return new Builder();
    }

    public boolean isExtended();

    public long longRunningRequestThresholdMs();

    public static class Builder
    implements io.helidon.common.Builder<KeyPerformanceIndicatorMetricsSettings> {
        private boolean isExtendedKpiEnabled = false;
        private long longRunningRequestThresholdMs = 10000L;
        public static final String KEY_PERFORMANCE_INDICATORS_CONFIG_KEY = "key-performance-indicators";
        public static final String KEY_PERFORMANCE_INDICATORS_EXTENDED_CONFIG_KEY = "extended";
        static final boolean KEY_PERFORMANCE_INDICATORS_EXTENDED_DEFAULT = false;
        public static final String LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "threshold-ms";
        public static final String LONG_RUNNING_REQUESTS_CONFIG_KEY = "long-running-requests";
        static final long LONG_RUNNING_REQUESTS_THRESHOLD_MS_DEFAULT = 10000L;
        private static final String CONFIG_KEY_PREFIX = "metrics.key-performance-indicators";
        private static final String QUALIFIED_LONG_RUNNING_REQUESTS_THRESHOLD_CONFIG_KEY = "long-running-requests.extended";

        public Builder extended(boolean value) {
            this.isExtendedKpiEnabled = value;
            return this;
        }

        public Builder longRunningRequestThresholdMs(long value) {
            this.longRunningRequestThresholdMs = value;
            return this;
        }

        public KeyPerformanceIndicatorMetricsSettings build() {
            return new KeyPerformanceIndicatorMetricsSettingsImpl(this);
        }

        boolean isExtended() {
            return this.isExtendedKpiEnabled;
        }

        long longRunningRequestThresholdMs() {
            return this.longRunningRequestThresholdMs;
        }
    }
}

