/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import org.eclipse.microprofile.metrics.MetricID;

class PrometheusName {
    private final String prometheusTags;
    private final MetricImpl metricImpl;
    private final MetricID metricID;
    private final String prometheusNameWithUnits;
    private final String prometheusName;
    private final String prometheusUnit;
    private final MetricImpl.Units units;

    static PrometheusName create(MetricImpl metricImpl, MetricID metricID) {
        return new PrometheusName(metricImpl, metricID, metricImpl.getUnits());
    }

    static PrometheusName create(MetricImpl metricImpl, MetricID metricID, MetricImpl.Units units) {
        return new PrometheusName(metricImpl, metricID, units);
    }

    private PrometheusName(MetricImpl metricImpl, MetricID metricID, MetricImpl.Units units) {
        this.metricImpl = metricImpl;
        this.metricID = metricID;
        this.units = units;
        this.prometheusName = MetricImpl.prometheusClean(metricID.getName(), metricImpl.registryType() + "_");
        this.prometheusTags = metricImpl.prometheusTags(metricID.getTags());
        this.prometheusNameWithUnits = this.nameUnits(units);
        this.prometheusUnit = units.getPrometheusUnit().orElse("");
    }

    MetricImpl.Units units() {
        return this.units;
    }

    String nameUnits() {
        return this.prometheusNameWithUnits;
    }

    String nameUnits(MetricImpl.Units units) {
        return this.metricImpl.prometheusNameWithUnits(this.metricID.getName(), units.getPrometheusUnit());
    }

    String nameStatUnits(String statName) {
        return this.nameStat(statName) + "_" + this.prometheusUnit;
    }

    String nameStat(String statName) {
        return this.prometheusName + "_" + statName;
    }

    String nameUnitsSuffixTags(String nameSuffix) {
        return this.prometheusNameWithUnits + "_" + nameSuffix + this.prometheusTags;
    }

    String prometheusTags() {
        return this.prometheusTags;
    }
}

