/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import jakarta.json.JsonObjectBuilder;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonGauge<T extends Number>
extends MetricImpl
implements Gauge<T> {
    private final Supplier<T> value = () -> metric.getValue();

    private HelidonGauge(String registryType, Metadata metadata, Gauge<T> metric) {
        super(registryType, metadata);
    }

    static <S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, Gauge<S> metric) {
        return new HelidonGauge<S>(registryType, metadata, metric);
    }

    static <T, S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, T object, Function<T, S> func) {
        return new HelidonGauge<T>(registryType, metadata, () -> (Number)func.apply(object));
    }

    static <T, S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, Supplier<S> valueSupplier) {
        return new HelidonGauge<T>(registryType, metadata, valueSupplier::get);
    }

    public T getValue() {
        return (T)((Number)this.value.get());
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusNameWithUnits(metricID.getName(), this.getUnits().getPrometheusUnit());
    }

    @Override
    public String prometheusValue() {
        return this.getUnits().convert(this.getValue()).toString();
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        Object value = this.getValue();
        String nameWithTags = HelidonGauge.jsonFullKey(metricID);
        if (value instanceof AtomicInteger) {
            builder.add(nameWithTags, ((Number)value).doubleValue());
        } else if (value instanceof AtomicLong) {
            builder.add(nameWithTags, ((Number)value).longValue());
        } else if (value instanceof BigDecimal) {
            builder.add(nameWithTags, (BigDecimal)value);
        } else if (value instanceof BigInteger) {
            builder.add(nameWithTags, (BigInteger)value);
        } else if (value instanceof Byte) {
            builder.add(nameWithTags, ((Number)value).intValue());
        } else if (value instanceof Double) {
            builder.add(nameWithTags, ((Double)value).doubleValue());
        } else if (value instanceof DoubleAccumulator) {
            builder.add(nameWithTags, ((Number)value).doubleValue());
        } else if (value instanceof DoubleAdder) {
            builder.add(nameWithTags, ((Number)value).doubleValue());
        } else if (value instanceof Float) {
            builder.add(nameWithTags, (double)((Number)value).floatValue());
        } else if (value instanceof Integer) {
            builder.add(nameWithTags, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(nameWithTags, ((Long)value).longValue());
        } else if (value instanceof LongAccumulator) {
            builder.add(nameWithTags, ((Number)value).longValue());
        } else if (value instanceof LongAdder) {
            builder.add(nameWithTags, ((Number)value).longValue());
        } else if (value instanceof Short) {
            builder.add(nameWithTags, ((Number)value).intValue());
        } else {
            builder.add(nameWithTags, ((Number)value).doubleValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonGauge that = (HelidonGauge)o;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }

    @Override
    protected String toStringDetails() {
        return ", value='" + (Number)this.getValue() + "'";
    }
}

