/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.DisplayableLabeledSnapshot;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.MetricsSupport;
import io.helidon.metrics.PrometheusName;
import io.helidon.metrics.Sample;
import io.helidon.metrics.api.AbstractMetric;
import io.helidon.metrics.api.SystemTagsManager;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonBuilderFactory;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

abstract class MetricImpl
extends AbstractMetric
implements HelidonMetric {
    static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final Logger LOGGER = Logger.getLogger(MetricImpl.class.getName());
    private static final int EXEMPLAR_MAX_LENGTH = 128;
    private static final Pattern DOUBLE_UNDERSCORE = Pattern.compile("__");
    private static final Pattern COLON_UNDERSCORE = Pattern.compile(":_");
    private static final Pattern CAMEL_CASE = Pattern.compile("(.)(\\p{Upper})");
    private static final Map<String, Units> PROMETHEUS_CONVERTERS = new HashMap<String, Units>();
    private static final long KILOBITS = 125L;
    private static final long MEGABITS = 125000L;
    private static final long GIGABITS = 125000000L;
    private static final long KIBIBITS = 128L;
    private static final long MEBIBITS = 131072L;
    private static final long GIBIBITS = 0x8000000L;
    private static final long KILOBYTES = 1000L;
    private static final long MEGABYTES = 1000000L;
    private static final long GIGABYTES = 1000000000L;
    private static final Map<String, String> JSON_ESCAPED_CHARS_MAP = MetricImpl.initEscapedCharsMap();
    private static final Pattern JSON_ESCAPED_CHARS_REGEX = Pattern.compile(JSON_ESCAPED_CHARS_MAP.keySet().stream().map(Pattern::quote).collect(Collectors.joining("", "[", "]")));
    private boolean isDeleted;

    private static String bsls(String s) {
        return "\\\\" + s;
    }

    private static Map<String, String> initEscapedCharsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("\b", MetricImpl.bsls("b"));
        result.put("\f", MetricImpl.bsls("f"));
        result.put("\n", MetricImpl.bsls("n"));
        result.put("\r", MetricImpl.bsls("r"));
        result.put("\t", MetricImpl.bsls("t"));
        result.put("\"", MetricImpl.bsls("\""));
        result.put("\\", MetricImpl.bsls("\\\\"));
        result.put(";", "_");
        return result;
    }

    MetricImpl(String registryType, Metadata metadata) {
        super(registryType, metadata);
    }

    private static void addByteConverter(String metricUnit, long toByteRatio) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new Units(metricUnit, "bytes", o -> ((Number)o).doubleValue() * (double)toByteRatio));
    }

    private static void addConverter(Units units) {
        PROMETHEUS_CONVERTERS.put(units.getMetricUnit(), units);
    }

    private static void addTimeConverter(String metricUnit, TimeUnit timeUnit) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new TimeUnits(metricUnit, timeUnit));
    }

    @Override
    public String getName() {
        return this.metadata().getName();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registryType='" + this.registryType() + "', metadata=" + this.metadata() + this.toStringDetails() + "}";
    }

    @Override
    public void jsonMeta(JsonObjectBuilder builder, List<MetricID> metricIDs) {
        MetricsSupport.MergingJsonObjectBuilder metaBuilder = new MetricsSupport.MergingJsonObjectBuilder(JSON.createObjectBuilder());
        this.addNonEmpty(metaBuilder, "unit", this.metadata().getUnit());
        this.addNonEmpty(metaBuilder, "type", this.metadata().getType());
        this.addNonEmpty(metaBuilder, "description", this.metadata().getDescription());
        this.addNonEmpty(metaBuilder, "displayName", this.metadata().getDisplayName());
        if (metricIDs != null) {
            for (MetricID metricID : metricIDs) {
                boolean tagAdded = false;
                JsonArrayBuilder ab = JSON.createArrayBuilder();
                for (Map.Entry tag : SystemTagsManager.instance().allTags(metricID)) {
                    tagAdded = true;
                    ab.add(MetricImpl.tagForJsonKey(tag));
                }
                if (!tagAdded) continue;
                metaBuilder.add("tags", ab);
            }
        }
        builder.add(this.getName(), (JsonObjectBuilder)metaBuilder);
    }

    public boolean isDeleted() {
        return super.isDeleted();
    }

    static String jsonFullKey(String baseName, MetricID metricID) {
        return baseName + MetricImpl.tagsToJsonFormat(SystemTagsManager.instance().allTags(metricID));
    }

    private static String tagsToJsonFormat(Iterable<Map.Entry<String, String>> it) {
        StringJoiner sj = new StringJoiner(";", ";", "").setEmptyValue("");
        it.forEach(entry -> sj.add(MetricImpl.tagForJsonKey(entry)));
        return sj.toString();
    }

    static String jsonFullKey(MetricID metricID) {
        return MetricImpl.jsonFullKey(metricID.getName(), metricID);
    }

    long conversionFactor() {
        Units units = this.getUnits();
        String metricUnit = units.getMetricUnit();
        if (metricUnit == null) {
            return 1L;
        }
        long divisor = 1L;
        switch (metricUnit) {
            case "nanoseconds": {
                divisor = 1L;
                break;
            }
            case "microseconds": {
                divisor = 1000L;
                break;
            }
            case "milliseconds": {
                divisor = 1000000L;
                break;
            }
            case "seconds": {
                divisor = 1000000000L;
                break;
            }
            case "minutes": {
                divisor = -129542144L;
                break;
            }
            case "hours": {
                divisor = 817405952L;
                break;
            }
            case "days": {
                divisor = -1857093632L;
                break;
            }
            default: {
                divisor = 1L;
            }
        }
        return divisor;
    }

    protected String toStringDetails() {
        return "";
    }

    private static String tagForJsonKey(Map.Entry<String, String> tagEntry) {
        return String.format("%s=%s", MetricImpl.jsonEscape(tagEntry.getKey()), MetricImpl.jsonEscape(tagEntry.getValue()));
    }

    static String jsonEscape(String s) {
        Matcher m = JSON_ESCAPED_CHARS_REGEX.matcher(s);
        StringBuilder sb = new StringBuilder();
        while (m.find()) {
            m.appendReplacement(sb, JSON_ESCAPED_CHARS_MAP.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    void prometheusType(StringBuilder sb, String nameWithUnits, String type) {
        sb.append("# TYPE ").append(nameWithUnits).append(" ").append(type).append('\n');
    }

    void prometheusHelp(StringBuilder sb, String nameWithUnits) {
        sb.append("# HELP ").append(nameWithUnits).append(" ").append(this.metadata().getDescription()).append('\n');
    }

    JsonValue jsonDuration(Duration duration) {
        if (duration == null) {
            return JsonObject.NULL;
        }
        double result = (double)duration.toNanos() / (double)this.conversionFactor();
        return Json.createValue((double)result);
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType) {
        String nameWithUnits = this.prometheusNameWithUnits(metricID);
        if (withHelpType) {
            this.prometheusType(sb, nameWithUnits, this.metadata().getType());
            this.prometheusHelp(sb, nameWithUnits);
        }
        sb.append(nameWithUnits).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.prometheusValue()).append('\n');
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusNameWithUnits(metricID.getName(), this.getUnits().getPrometheusUnit());
    }

    public abstract String prometheusValue();

    protected final void prometheusQuantile(StringBuilder sb, PrometheusName name, Units units, String quantile, Sample.Derived derived) {
        String quantileTag = "quantile=\"" + quantile + "\"";
        Object tags = name.prometheusTags();
        tags = name.prometheusTags().isEmpty() ? "{" + quantileTag + "}" : ((String)tags).substring(0, ((String)tags).length() - 1) + "," + quantileTag + "}";
        sb.append(name.nameUnits()).append((String)tags).append(" ").append(units.convert(derived.value()));
        sb.append(this.prometheusExemplar(derived.sample(), units));
        sb.append("\n");
    }

    void appendPrometheusElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, Sample.Derived derived) {
        this.appendPrometheusElement(sb, name, () -> name.nameStatUnits(statName), withHelpType, typeName, derived.value(), derived.sample());
    }

    void appendPrometheusElement(StringBuilder sb, PrometheusName name, String statName, boolean withHelpType, String typeName, Sample.Labeled sample) {
        this.appendPrometheusElement(sb, name, () -> name.nameStatUnits(statName), withHelpType, typeName, sample.value(), sample);
    }

    private void appendPrometheusElement(StringBuilder sb, PrometheusName name, Supplier<String> nameToUse, boolean withHelpType, String typeName, double value, Sample.Labeled sample) {
        if (withHelpType) {
            this.prometheusType(sb, nameToUse.get(), typeName);
        }
        Object convertedValue = name.units().convert(value);
        sb.append(nameToUse.get()).append(name.prometheusTags()).append(" ").append(convertedValue).append(this.prometheusExemplar(sample, name.units())).append("\n");
    }

    void appendPrometheusHistogramElements(StringBuilder sb, MetricID metricID, boolean withHelpType, long count, long sum, DisplayableLabeledSnapshot snap) {
        PrometheusName name = PrometheusName.create(this, metricID);
        this.appendPrometheusHistogramElements(sb, name, this.getUnits(), withHelpType, count, sum, snap);
    }

    void appendPrometheusHistogramElements(StringBuilder sb, PrometheusName name, boolean withHelpType, long count, Duration elapsedTime, DisplayableLabeledSnapshot snap) {
        this.appendPrometheusHistogramElements(sb, name, TimeUnits.PROMETHEUS_TIMER_CONVERSION_TIME_UNITS, withHelpType, count, elapsedTime.toSeconds(), snap);
    }

    void appendPrometheusHistogramElements(StringBuilder sb, PrometheusName name, Units units, boolean withHelpType, long count, long sum, DisplayableLabeledSnapshot snap) {
        this.appendPrometheusElement(sb, name, "mean", withHelpType, "gauge", snap.mean());
        this.appendPrometheusElement(sb, name, "max", withHelpType, "gauge", snap.max());
        this.appendPrometheusElement(sb, name, "min", withHelpType, "gauge", snap.min());
        this.appendPrometheusElement(sb, name, "stddev", withHelpType, "gauge", snap.stdDev());
        if (withHelpType) {
            this.prometheusType(sb, name.nameUnits(), "summary");
            this.prometheusHelp(sb, name.nameUnits());
        }
        sb.append(name.nameUnitsSuffixTags("count")).append(" ").append(count).append('\n');
        sb.append(name.nameUnitsSuffixTags("sum")).append(" ").append(sum).append('\n');
        this.prometheusQuantile(sb, name, units, "0.5", snap.median());
        this.prometheusQuantile(sb, name, units, "0.75", snap.sample75thPercentile());
        this.prometheusQuantile(sb, name, units, "0.95", snap.sample95thPercentile());
        this.prometheusQuantile(sb, name, units, "0.98", snap.sample98thPercentile());
        this.prometheusQuantile(sb, name, units, "0.99", snap.sample99thPercentile());
        this.prometheusQuantile(sb, name, units, "0.999", snap.sample999thPercentile());
    }

    String prometheusExemplar(Sample.Labeled sample) {
        return this.prometheusExemplar(sample, this.getUnits());
    }

    String prometheusExemplar(Sample.Labeled sample, Units units) {
        return sample == null ? "" : this.prometheusExemplar(units.convert(sample.value()), sample);
    }

    String prometheusExemplar(Object value, Sample.Labeled sample) {
        if (sample == null || sample.label().isBlank()) {
            return "";
        }
        String exemplar = String.format(" # %s %s %f", sample.label(), value, (double)sample.timestamp() / 1000.0);
        if (exemplar.length() <= 128) {
            return exemplar;
        }
        LOGGER.log(Level.WARNING, String.format("Exemplar string exceeds the maximum length(%d); suppressing '%s'", exemplar.length(), exemplar));
        return "";
    }

    final String prometheusNameWithUnits(String name, Optional<String> unit) {
        return this.prometheusName(name) + unit.map(it -> "_" + it).orElse("");
    }

    final String prometheusName(String name) {
        return MetricImpl.prometheusClean(name, this.registryType() + "_");
    }

    static String prometheusClean(String name, String prefix) {
        Object orig;
        name = ((String)name).replaceAll("[^a-zA-Z0-9_]", "_");
        name = prefix + (String)name;
        while (!((String)(orig = name)).equals(name = DOUBLE_UNDERSCORE.matcher((CharSequence)name).replaceAll("_"))) {
        }
        while (!((String)(orig = name)).equals(name = COLON_UNDERSCORE.matcher((CharSequence)name).replaceAll(":"))) {
        }
        return name;
    }

    final String prometheusTags(Map<String, String> tags) {
        StringJoiner sj = new StringJoiner(",", "{", "}").setEmptyValue("");
        SystemTagsManager.instance().allTags(tags).forEach(entry -> {
            if (entry.getKey() != null) {
                sj.add(String.format("%s=\"%s\"", MetricImpl.prometheusClean((String)entry.getKey(), ""), this.prometheusTagValue((String)entry.getValue())));
            }
        });
        return sj.toString();
    }

    private String prometheusTagValue(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\n", "\\n");
        return value;
    }

    String camelToSnake(String name) {
        return CAMEL_CASE.matcher(name).replaceAll("$1_$2").toLowerCase();
    }

    void addNonEmpty(JsonObjectBuilder builder, String name, String value) {
        if (null != value && !value.isEmpty()) {
            builder.add(name, value);
        }
    }

    Units getUnits() {
        String unit = this.metadata().getUnit();
        if (null == unit || unit.isEmpty() || "none".equals(unit)) {
            return new Units(null);
        }
        Units units = PROMETHEUS_CONVERTERS.get(unit);
        if (null == units) {
            return new Units(unit, unit, o -> o);
        }
        return units;
    }

    static {
        MetricImpl.addTimeConverter("nanoseconds", TimeUnit.NANOSECONDS);
        MetricImpl.addTimeConverter("microseconds", TimeUnit.MICROSECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("seconds", TimeUnit.SECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("minutes", TimeUnit.MINUTES);
        MetricImpl.addTimeConverter("hours", TimeUnit.HOURS);
        MetricImpl.addTimeConverter("days", TimeUnit.DAYS);
        MetricImpl.addConverter(new Units("bits", "bytes", o -> ((Number)o).doubleValue() / 8.0));
        MetricImpl.addByteConverter("kilobits", 125L);
        MetricImpl.addByteConverter("megabits", 125000L);
        MetricImpl.addByteConverter("gigabits", 125000000L);
        MetricImpl.addByteConverter("kibibits", 128L);
        MetricImpl.addByteConverter("mebibits", 131072L);
        MetricImpl.addByteConverter("gibibits", 0x8000000L);
        MetricImpl.addByteConverter("kilobytes", 1000L);
        MetricImpl.addByteConverter("megabytes", 1000000L);
        MetricImpl.addByteConverter("gigabytes", 1000000000L);
        MetricImpl.addConverter(new Units("fahrenheits", "celsius", o -> (((Number)o).doubleValue() - 32.0) * 5.0 / 9.0));
        MetricImpl.addConverter(new LengthUnits("millimeters", 0.001));
        MetricImpl.addConverter(new LengthUnits("centimeters", 0.01));
        MetricImpl.addConverter(new LengthUnits("kilometers", 1000.0));
    }

    static class Units {
        private final String metricUnit;
        private final String prometheusUnit;
        private final Function<Object, Object> converter;

        Units(String unit) {
            this.metricUnit = unit;
            this.prometheusUnit = unit;
            this.converter = o -> o;
        }

        private Units(String metricUnit, String prometheusUnit, Function<Object, Object> converter) {
            this.metricUnit = metricUnit;
            this.prometheusUnit = prometheusUnit;
            this.converter = converter;
        }

        String getMetricUnit() {
            return this.metricUnit;
        }

        Optional<String> getPrometheusUnit() {
            return Optional.ofNullable(this.prometheusUnit);
        }

        public Object convert(Object value) {
            double num;
            Object apply = this.converter.apply(value);
            if (apply instanceof Double && Math.floor(num = ((Double)apply).doubleValue()) == num) {
                return (long)num;
            }
            return apply;
        }
    }

    static final class TimeUnits
    extends Units {
        private static final long MILLISECONDS = 1000L;
        private static final long MICROSECONDS = 1000000L;
        private static final long NANOSECONDS = 1000000000L;
        private static final String DOUBLE_NAN = String.valueOf(Double.NaN);
        private static final BiFunction<Object, Function<Object, Object>, Object> CHECK_NANS = (o, f) -> o instanceof Double && ((Double)o).isNaN() ? DOUBLE_NAN : f.apply(o);
        static final TimeUnits PROMETHEUS_TIMER_CONVERSION_TIME_UNITS = new TimeUnits("seconds", TimeUnit.NANOSECONDS);

        private TimeUnits(String metricUnit, TimeUnit timeUnit) {
            super(metricUnit, "seconds", TimeUnits.timeConverter(timeUnit));
        }

        static Function<Object, Object> timeConverter(TimeUnit from) {
            switch (from) {
                case NANOSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(p)).doubleValue() / 1.0E9));
                }
                case MICROSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000000.0));
                }
                case MILLISECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000.0));
                }
                case SECONDS: {
                    return o -> CHECK_NANS.apply(o, String::valueOf);
                }
            }
            return o -> CHECK_NANS.apply(o, p -> String.valueOf(TimeUnit.SECONDS.convert(new BigDecimal(String.valueOf(o)).longValue(), from)));
        }
    }

    private static final class LengthUnits
    extends Units {
        private LengthUnits(String metricUnit, double ratio) {
            super(metricUnit, "meters", o -> ((Number)o).doubleValue() * ratio);
        }
    }
}

