/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.ExemplarServiceManager;

interface Sample {
    public static final boolean IS_EXEMPLAR_HANDLING_ACTIVE = ExemplarServiceManager.isActive();

    public static Derived derived(double value, Labeled reference) {
        return new Derived.Impl(value, reference);
    }

    public static Derived derived(double value) {
        return new Derived.Impl(value, null);
    }

    public static Labeled labeled(long value) {
        return IS_EXEMPLAR_HANDLING_ACTIVE ? new Labeled.Impl(value, ExemplarServiceManager.exemplarLabel(), System.currentTimeMillis()) : new Labeled.Impl(value, "", 0L);
    }

    public double doubleValue();

    public static interface Derived
    extends Sample {
        public static final Derived ZERO = new Impl(0.0, null);

        public double value();

        public Labeled sample();

        public static class Impl
        implements Derived {
            private final double value;
            private final Labeled sample;

            Impl(double value, Labeled reference) {
                this.value = value;
                this.sample = reference;
            }

            @Override
            public double value() {
                return this.value;
            }

            @Override
            public Labeled sample() {
                return this.sample;
            }

            @Override
            public double doubleValue() {
                return this.value;
            }
        }
    }

    public static interface Labeled
    extends Sample {
        public long value();

        public String label();

        public long timestamp();

        public static class Impl
        implements Labeled {
            private final long value;
            private final String label;
            private final long timestamp;

            Impl(long value, String label, long timestamp) {
                this.value = value;
                this.label = label;
                this.timestamp = timestamp;
            }

            @Override
            public long value() {
                return this.value;
            }

            @Override
            public String label() {
                return this.label;
            }

            @Override
            public long timestamp() {
                return this.timestamp;
            }

            @Override
            public double doubleValue() {
                return this.value;
            }
        }
    }
}

