/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.Sample;
import jakarta.json.JsonObjectBuilder;
import java.util.Objects;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;

final class HelidonCounter
extends MetricImpl
implements Counter {
    private final Counter delegate;

    private HelidonCounter(String registryType, Metadata metadata, Counter delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonCounter create(String registryType, Metadata metadata) {
        return HelidonCounter.create(registryType, metadata, new CounterImpl());
    }

    static HelidonCounter create(String registryType, Metadata metadata, Counter metric) {
        return new HelidonCounter(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void inc(long n) {
        this.delegate.inc(n);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        String metricName = this.prometheusName(metricID.getName());
        return metricName.endsWith("total") ? metricName : metricName + "_total";
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType, boolean isStrictExemplars) {
        this.prometheusData(sb, metricID, withHelpType, this.prometheusNameWithUnits(metricID));
    }

    void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType, String prometheusName) {
        Sample.Labeled sample;
        if (withHelpType) {
            this.prometheusType(sb, prometheusName, this.metadata().getType());
            this.prometheusHelp(sb, prometheusName);
        }
        sb.append(prometheusName).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.prometheusValue());
        if (this.delegate instanceof CounterImpl && (sample = ((CounterImpl)this.delegate).sample) != null) {
            sb.append(this.prometheusExemplar(sample));
        }
        sb.append('\n');
    }

    @Override
    public String prometheusValue() {
        return Long.toString(this.getCount());
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        builder.add(HelidonCounter.jsonFullKey(metricID), this.getCount());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonCounter that = (HelidonCounter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        return ", counter='" + this.getCount() + "'";
    }

    private static class CounterImpl
    implements Counter {
        private final LongAdder adder = new LongAdder();
        private Sample.Labeled sample = null;

        private CounterImpl() {
        }

        public void inc() {
            this.inc(1L);
        }

        public void inc(long n) {
            this.adder.add(n);
            this.sample = Sample.labeled(n);
        }

        public long getCount() {
            return this.adder.sum();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getCount());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterImpl that = (CounterImpl)o;
            return this.getCount() == that.getCount();
        }
    }
}

