/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.Sample;
import jakarta.json.JsonObjectBuilder;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;

final class HelidonSimpleTimer
extends MetricImpl
implements SimpleTimer {
    private final SimpleTimer delegate;

    private HelidonSimpleTimer(String type, Metadata metadata, SimpleTimer delegate) {
        super(type, metadata);
        this.delegate = delegate;
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata) {
        return HelidonSimpleTimer.create(repoType, metadata, Clock.system());
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata, Clock clock) {
        return HelidonSimpleTimer.create(repoType, metadata, new SimpleTimerImpl(repoType, metadata.getName(), clock));
    }

    static HelidonSimpleTimer create(String repoType, Metadata metadata, SimpleTimer metric) {
        return new HelidonSimpleTimer(repoType, metadata, metric);
    }

    public Duration getMaxTimeDuration() {
        return this.delegate.getMaxTimeDuration();
    }

    public Duration getMinTimeDuration() {
        return this.delegate.getMinTimeDuration();
    }

    public void update(Duration duration) {
        this.delegate.update(duration);
    }

    public <T> T time(Callable<T> event) throws Exception {
        return (T)this.delegate.time(event);
    }

    public void time(Runnable event) {
        this.delegate.time(event);
    }

    public SimpleTimer.Context time() {
        return this.delegate.time();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public Duration getElapsedTime() {
        return this.delegate.getElapsedTime();
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType, boolean isStrictExemplars) {
        Sample.Labeled sample;
        String name = metricID.getName();
        String tags = this.prometheusTags(metricID.getTags());
        Object promName = this.prometheusName(name) + "_total";
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "counter");
            this.prometheusHelp(sb, (String)promName);
        }
        sb.append((String)promName).append(tags).append(" ").append(this.getCount());
        SimpleTimerImpl simpleTimerImpl = this.delegate instanceof SimpleTimerImpl ? (SimpleTimerImpl)this.delegate : null;
        Sample.Labeled labeled = sample = simpleTimerImpl != null ? simpleTimerImpl.sample : null;
        if (sample != null) {
            sb.append(this.prometheusExemplar(1, sample));
        }
        sb.append("\n");
        promName = this.prometheusNameWithUnits(name + "_elapsedTime", Optional.of("seconds"));
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "gauge");
        }
        sb.append((String)promName).append(tags).append(" ").append(this.elapsedTimeInSeconds()).append(isStrictExemplars ? "" : this.exemplarForElapsedTime(sample)).append("\n");
        promName = this.prometheusNameWithUnits(name + "_maxTimeDuration", Optional.of("seconds"));
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "gauge");
        }
        sb.append((String)promName).append(tags).append(" ").append(HelidonSimpleTimer.durationPrometheusOutput(this.getMaxTimeDuration())).append(this.exemplarForElapsedTime(this.getMaxTimeDuration(), simpleTimerImpl == null ? null : simpleTimerImpl.lastMaxSample)).append("\n");
        promName = this.prometheusNameWithUnits(name + "_minTimeDuration", Optional.of("seconds"));
        if (withHelpType) {
            this.prometheusType(sb, (String)promName, "gauge");
        }
        sb.append((String)promName).append(tags).append(" ").append(HelidonSimpleTimer.durationPrometheusOutput(this.getMinTimeDuration())).append(this.exemplarForElapsedTime(this.getMinTimeDuration(), simpleTimerImpl == null ? null : simpleTimerImpl.lastMinSample)).append("\n");
    }

    @Override
    public String prometheusValue() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void jsonData(JsonObjectBuilder builder, MetricID metricID) {
        JsonObjectBuilder myBuilder = JSON.createObjectBuilder().add(HelidonSimpleTimer.jsonFullKey("count", metricID), this.getCount()).add(HelidonSimpleTimer.jsonFullKey("elapsedTime", metricID), this.jsonDuration(this.getElapsedTime())).add(HelidonSimpleTimer.jsonFullKey("maxTimeDuration", metricID), this.jsonDuration(this.getMaxTimeDuration())).add(HelidonSimpleTimer.jsonFullKey("minTimeDuration", metricID), this.jsonDuration(this.getMinTimeDuration()));
        builder.add(metricID.getName(), myBuilder);
    }

    private String exemplarForElapsedTime(Duration duration, Sample.Labeled sample) {
        return duration == null ? "" : this.exemplarForElapsedTime(sample);
    }

    private String exemplarForElapsedTime(Sample.Labeled sample) {
        return sample == null ? "" : this.prometheusExemplar(sample.value(), sample);
    }

    private static String durationPrometheusOutput(Duration duration) {
        return duration == null ? "NaN" : Double.toString((double)duration.toNanos() / 1000.0 / 1000.0 / 1000.0);
    }

    private double elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds(this.getElapsedTime().toNanos());
    }

    private double elapsedTimeInSeconds(long nanos) {
        return (double)nanos / 1.0E9;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonSimpleTimer that = (HelidonSimpleTimer)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        return ", count='" + this.getCount() + "', elapsedTime='" + this.getElapsedTime() + "', minTimeDuration='" + this.getMinTimeDuration() + "', maxTimeDuration='" + this.getMaxTimeDuration() + "'";
    }

    private static class SimpleTimerImpl
    implements SimpleTimer {
        private final HelidonCounter counter;
        private final Clock clock;
        private Duration elapsed = Duration.ofNanos(0L);
        private Duration currentMin = null;
        private Duration currentMax = null;
        private Duration lastMin = null;
        private Duration lastMax = null;
        private long lastMinute;
        private Sample.Labeled sample = null;
        private Sample.Labeled currentMaxSample = null;
        private Sample.Labeled currentMinSample = null;
        private Sample.Labeled lastMaxSample = null;
        private Sample.Labeled lastMinSample = null;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        SimpleTimerImpl(String repoType, String name, Clock clock) {
            this.counter = HelidonCounter.create(repoType, Metadata.builder().withName(name).withType(MetricType.COUNTER).build());
            this.clock = clock;
            this.lastMinute = this.currentTimeMinute();
        }

        public Duration getMaxTimeDuration() {
            this.updateState();
            return this.readAccess(() -> this.lastMax == null ? null : Duration.from(this.lastMax));
        }

        public Duration getMinTimeDuration() {
            this.updateState();
            return this.readAccess(() -> this.lastMin == null ? null : Duration.from(this.lastMin));
        }

        public void update(Duration duration) {
            this.update(duration.toNanos());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T time(Callable<T> event) throws Exception {
            long t = this.clock.nanoTick();
            try {
                T t2 = event.call();
                return t2;
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void time(Runnable event) {
            long t = this.clock.nanoTick();
            try {
                event.run();
            }
            finally {
                this.update(this.clock.nanoTick() - t);
            }
        }

        public SimpleTimer.Context time() {
            return new ContextImpl(this, this.clock);
        }

        public Duration getElapsedTime() {
            return this.readAccess(() -> Duration.from(this.elapsed));
        }

        public long getCount() {
            return this.counter.getCount();
        }

        private long currentTimeMinute() {
            return this.clock.milliTime() / 1000L / 60L;
        }

        private void update(long nanos) {
            this.writeAccess(() -> {
                if (nanos >= 0L) {
                    this.counter.inc();
                    this.elapsed = this.elapsed.plusNanos(nanos);
                    this.sample = Sample.labeled(nanos);
                    this.updateStateLocked();
                    if (this.currentMin == null || this.currentMin.toNanos() > nanos) {
                        this.currentMin = Duration.ofNanos(nanos);
                        this.currentMinSample = this.sample;
                    }
                    if (this.currentMax == null || this.currentMax.toNanos() < nanos) {
                        this.currentMax = Duration.ofNanos(nanos);
                        this.currentMaxSample = this.sample;
                    }
                }
                return null;
            });
        }

        private void updateState() {
            this.writeAccess(() -> {
                this.updateStateLocked();
                return null;
            });
        }

        private void updateStateLocked() {
            long currentMinute = this.currentTimeMinute();
            long diff = currentMinute - this.lastMinute;
            if (diff >= 1L) {
                this.lastMax = this.currentMax;
                this.lastMin = this.currentMin;
                this.currentMax = null;
                this.currentMin = null;
                this.lastMaxSample = this.currentMaxSample;
                this.lastMinSample = this.currentMinSample;
                this.currentMaxSample = null;
                this.currentMinSample = null;
                this.lastMinute = currentMinute;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleTimerImpl that = (SimpleTimerImpl)o;
            return this.counter.equals(that.counter) && this.elapsed.equals(that.elapsed) && Objects.equals(this.lastMin, that.lastMin) && Objects.equals(this.lastMax, that.lastMax) && Objects.equals(this.sample, that.sample) && Objects.equals(this.currentMin, that.currentMin) && Objects.equals(this.currentMax, that.currentMax) && Objects.equals(this.currentMinSample, that.currentMinSample) && Objects.equals(this.currentMaxSample, that.currentMaxSample) && Objects.equals(this.lastMinSample, that.lastMinSample) && Objects.equals(this.lastMaxSample, that.lastMaxSample);
        }

        public int hashCode() {
            return Objects.hash(this.counter, this.elapsed, this.lastMin, this.lastMax, this.sample, this.currentMin, this.currentMax, this.currentMinSample, this.currentMaxSample, this.lastMinSample, this.lastMaxSample);
        }

        private <T> T writeAccess(Callable<T> action) {
            return this.access(this.lock.writeLock(), action);
        }

        private <T> T readAccess(Callable<T> action) {
            return this.access(this.lock.readLock(), action);
        }

        private <T> T access(Lock lock, Callable<T> action) {
            lock.lock();
            try {
                T t = action.call();
                return t;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                lock.unlock();
            }
        }
    }

    private static final class ContextImpl
    implements SimpleTimer.Context {
        private final SimpleTimerImpl theSimpleTimer;
        private final long startTime;
        private final Clock clock;
        private final AtomicBoolean running = new AtomicBoolean(true);
        private Duration elapsed;

        private ContextImpl(SimpleTimerImpl theSimpleTimer, Clock clock) {
            this.theSimpleTimer = theSimpleTimer;
            this.startTime = clock.nanoTick();
            this.clock = clock;
        }

        public long stop() {
            if (this.running.compareAndSet(true, false)) {
                this.elapsed = Duration.ofNanos(this.clock.nanoTick() - this.startTime);
                this.theSimpleTimer.update(this.elapsed);
            }
            return this.elapsed.toNanos();
        }

        public void close() {
            this.stop();
        }
    }
}

