/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.HelidonConcurrentGauge;
import io.helidon.metrics.HelidonCounter;
import io.helidon.metrics.HelidonGauge;
import io.helidon.metrics.HelidonHistogram;
import io.helidon.metrics.HelidonMeter;
import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.HelidonSimpleTimer;
import io.helidon.metrics.HelidonTimer;
import io.helidon.metrics.api.AbstractRegistry;
import io.helidon.metrics.api.RegistrySettings;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Timer;

public class Registry
extends AbstractRegistry<HelidonMetric> {
    public static Registry create(MetricRegistry.Type type, RegistrySettings registrySettings) {
        return new Registry(type, registrySettings);
    }

    public void update(RegistrySettings registrySettings) {
        super.update(registrySettings);
    }

    protected boolean isMetricEnabled(String metricName) {
        return this.registrySettings().isMetricEnabled(metricName);
    }

    protected <T extends Metric> HelidonMetric toImpl(Metadata metadata, T metric) {
        MetricType metricType = Registry.deriveType((MetricType)metadata.getTypeRaw(), metric);
        switch (metricType) {
            case COUNTER: {
                return HelidonCounter.create(this.type(), metadata, (Counter)metric);
            }
            case GAUGE: {
                return HelidonGauge.create(this.type(), metadata, (Gauge)metric);
            }
            case HISTOGRAM: {
                return HelidonHistogram.create(this.type(), metadata, (Histogram)metric);
            }
            case METERED: {
                return HelidonMeter.create(this.type(), metadata, (Meter)metric);
            }
            case TIMER: {
                return HelidonTimer.create(this.type(), metadata, (Timer)metric);
            }
            case SIMPLE_TIMER: {
                return HelidonSimpleTimer.create(this.type(), metadata, (SimpleTimer)metric);
            }
            case CONCURRENT_GAUGE: {
                return HelidonConcurrentGauge.create(this.type(), metadata, (ConcurrentGauge)metric);
            }
        }
        throw new IllegalArgumentException("Unexpected metric type " + metricType + ": " + metric.getClass().getName());
    }

    protected Registry(MetricRegistry.Type type, RegistrySettings registrySettings) {
        super(type, HelidonMetric.class, registrySettings);
    }

    protected Map<Class<? extends HelidonMetric>, MetricType> prepareMetricToTypeMap() {
        return Map.of(HelidonConcurrentGauge.class, MetricType.CONCURRENT_GAUGE, HelidonCounter.class, MetricType.COUNTER, HelidonGauge.class, MetricType.GAUGE, HelidonHistogram.class, MetricType.HISTOGRAM, HelidonMeter.class, MetricType.METERED, HelidonTimer.class, MetricType.TIMER, HelidonSimpleTimer.class, MetricType.SIMPLE_TIMER);
    }

    protected <R extends Number> Gauge<R> createGauge(Metadata metadata, Supplier<R> supplier) {
        return HelidonGauge.create(this.type(), metadata, supplier);
    }

    protected Map<MetricType, BiFunction<String, Metadata, HelidonMetric>> prepareMetricFactories() {
        return Map.of(MetricType.COUNTER, HelidonCounter::create, MetricType.HISTOGRAM, HelidonHistogram::create, MetricType.METERED, HelidonMeter::create, MetricType.TIMER, HelidonTimer::create, MetricType.SIMPLE_TIMER, HelidonSimpleTimer::create, MetricType.CONCURRENT_GAUGE, HelidonConcurrentGauge::create);
    }

    protected <T, R extends Number> Gauge<R> createGauge(Metadata metadata, T object, Function<T, R> func) {
        return HelidonGauge.create(this.type(), metadata, object, func);
    }

    protected Optional<Map.Entry<MetricID, HelidonMetric>> getOptionalMetricEntry(String metricName) {
        return super.getOptionalMetricEntry(metricName);
    }

    protected Map<MetricType, BiFunction<String, Metadata, HelidonMetric>> metricFactories() {
        return super.metricFactories();
    }

    protected Stream<Map.Entry<MetricID, HelidonMetric>> stream() {
        return super.stream();
    }

    protected List<MetricID> metricIDsForName(String metricName) {
        return super.metricIDsForName(metricName);
    }

    protected List<Map.Entry<MetricID, HelidonMetric>> getMetricsByName(String metricName) {
        return super.getMetricsByName(metricName);
    }
}

