/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.Clock;
import io.helidon.metrics.MetricImpl;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Metadata;

final class HelidonConcurrentGauge
extends MetricImpl
implements ConcurrentGauge {
    private final ConcurrentGauge delegate;

    private HelidonConcurrentGauge(String registryType, Metadata metadata, ConcurrentGauge delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata) {
        return HelidonConcurrentGauge.create(registryType, metadata, Clock.system());
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata, Clock clock) {
        return HelidonConcurrentGauge.create(registryType, metadata, new ConcurrentGaugeImpl(clock));
    }

    static HelidonConcurrentGauge create(String registryType, Metadata metadata, ConcurrentGauge metric) {
        return new HelidonConcurrentGauge(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void dec() {
        this.delegate.dec();
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public long getMax() {
        return this.delegate.getMax();
    }

    public long getMin() {
        return this.delegate.getMin();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonConcurrentGauge that = (HelidonConcurrentGauge)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    protected String toStringDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(", count='").append(this.getCount()).append('\'');
        sb.append(", min='").append(this.getMin()).append('\'');
        sb.append(", max='").append(this.getMax()).append('\'');
        return sb.toString();
    }

    static class ConcurrentGaugeImpl
    implements ConcurrentGauge {
        private long count;
        private long lastMax;
        private long lastMin;
        private long currentMax;
        private long currentMin;
        private long lastMinute;
        private final Clock clock;
        private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        ConcurrentGaugeImpl(Clock clock) {
            this.clock = clock;
            this.count = 0L;
            this.lastMax = Long.MIN_VALUE;
            this.lastMin = Long.MAX_VALUE;
            this.currentMax = Long.MIN_VALUE;
            this.currentMin = Long.MAX_VALUE;
            this.lastMinute = this.currentTimeMinute();
        }

        public long getCount() {
            return this.count;
        }

        public long getMax() {
            this.updateState();
            return this.readAccess(() -> {
                long max = this.lastMax;
                return max == Long.MIN_VALUE ? 0L : max;
            });
        }

        public long getMin() {
            this.updateState();
            return this.readAccess(() -> {
                long min = this.lastMin;
                return min == Long.MAX_VALUE ? 0L : min;
            });
        }

        public void inc() {
            this.writeAccess(() -> {
                this.updateStateLocked();
                ++this.count;
                if (this.count > this.currentMax) {
                    this.currentMax = this.count;
                }
            });
        }

        public void dec() {
            this.writeAccess(() -> {
                this.updateStateLocked();
                --this.count;
                if (this.count < this.currentMin) {
                    this.currentMin = this.count;
                }
            });
        }

        public void updateState() {
            this.writeAccess(this::updateStateLocked);
        }

        private Void updateStateLocked() {
            long currentMinute = this.currentTimeMinute();
            long diff = currentMinute - this.lastMinute;
            if (diff >= 1L) {
                this.lastMax = this.currentMax;
                this.lastMin = this.currentMin;
                this.lastMinute = currentMinute;
            }
            return null;
        }

        private long currentTimeMinute() {
            return this.clock.milliTime() / 1000L / 60L;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.count, this.lastMin, this.lastMax);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentGaugeImpl that = (ConcurrentGaugeImpl)o;
            return this.count == that.count && this.lastMin == that.lastMin && this.lastMax == that.lastMax;
        }

        private void writeAccess(Runnable action) {
            this.access((Lock)this.lock.writeLock(), action);
        }

        private <T> T readAccess(Callable<T> action) {
            return this.access((Lock)this.lock.readLock(), action);
        }

        private void access(Lock lock, Runnable action) {
            lock.lock();
            try {
                action.run();
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                lock.unlock();
            }
        }

        private <T> T access(Lock lock, Callable<T> action) {
            lock.lock();
            try {
                T t = action.call();
                return t;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                lock.unlock();
            }
        }
    }
}

