/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import io.helidon.metrics.api.Sample;
import io.helidon.metrics.api.SampledMetric;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;

final class HelidonCounter
extends MetricImpl
implements Counter,
SampledMetric {
    private final Counter delegate;

    private HelidonCounter(String registryType, Metadata metadata, Counter delegate) {
        super(registryType, metadata);
        this.delegate = delegate;
    }

    static HelidonCounter create(String registryType, Metadata metadata) {
        return HelidonCounter.create(registryType, metadata, new CounterImpl());
    }

    static HelidonCounter create(String registryType, Metadata metadata, Counter metric) {
        return new HelidonCounter(registryType, metadata, metric);
    }

    public void inc() {
        this.delegate.inc();
    }

    public void inc(long n) {
        this.delegate.inc(n);
    }

    public long getCount() {
        return this.delegate.getCount();
    }

    public Optional<Sample.Labeled> sample() {
        Counter counter = this.delegate;
        if (counter instanceof CounterImpl) {
            CounterImpl ci = (CounterImpl)counter;
            return Optional.ofNullable(ci.sample);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonCounter that = (HelidonCounter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    protected String toStringDetails() {
        return ", counter='" + this.getCount() + "'";
    }

    private static class CounterImpl
    implements Counter {
        private final LongAdder adder = new LongAdder();
        private Sample.Labeled sample = null;

        private CounterImpl() {
        }

        public void inc() {
            this.inc(1L);
        }

        public void inc(long n) {
            this.adder.add(n);
            this.sample = Sample.labeled((long)n);
        }

        public long getCount() {
            return this.adder.sum();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getCount());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CounterImpl that = (CounterImpl)o;
            return this.getCount() == that.getCount();
        }
    }
}

