/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.MetricImpl;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;

final class HelidonGauge<T extends Number>
extends MetricImpl
implements Gauge<T> {
    private final Supplier<T> value = () -> metric.getValue();

    private HelidonGauge(String registryType, Metadata metadata, Gauge<T> metric) {
        super(registryType, metadata);
    }

    static <S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, Gauge<S> metric) {
        return new HelidonGauge<S>(registryType, metadata, metric);
    }

    static <T, S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, T object, Function<T, S> func) {
        return new HelidonGauge<T>(registryType, metadata, () -> (Number)func.apply(object));
    }

    static <T, S extends Number> HelidonGauge<S> create(String registryType, Metadata metadata, Supplier<S> valueSupplier) {
        return new HelidonGauge<T>(registryType, metadata, valueSupplier::get);
    }

    public T getValue() {
        return (T)((Number)this.value.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonGauge that = (HelidonGauge)o;
        return this.getValue().equals(that.getValue());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getValue());
    }

    @Override
    protected String toStringDetails() {
        return ", value='" + String.valueOf(this.getValue()) + "'";
    }
}

