/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.config.Config;
import io.helidon.metrics.BaseRegistry;
import io.helidon.metrics.PeriodicExecutor;
import io.helidon.metrics.Registry;
import io.helidon.metrics.api.MetricsSettings;
import java.util.EnumMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.microprofile.metrics.MetricRegistry;

public class RegistryFactory
implements io.helidon.metrics.api.RegistryFactory {
    private final EnumMap<MetricRegistry.Type, Registry> registries = new EnumMap(MetricRegistry.Type.class);
    private final Lock metricsSettingsAccess = new ReentrantLock(true);
    private MetricsSettings metricsSettings;

    protected RegistryFactory(MetricsSettings metricsSettings, Registry appRegistry, Registry vendorRegistry) {
        this.metricsSettings = metricsSettings;
        this.registries.put(MetricRegistry.Type.APPLICATION, appRegistry);
        this.registries.put(MetricRegistry.Type.VENDOR, vendorRegistry);
    }

    private RegistryFactory(MetricsSettings metricsSettings) {
        this(metricsSettings, Registry.create(MetricRegistry.Type.APPLICATION, metricsSettings.registrySettings(MetricRegistry.Type.APPLICATION)), Registry.create(MetricRegistry.Type.VENDOR, metricsSettings.registrySettings(MetricRegistry.Type.VENDOR)));
    }

    private void accessMetricsSettings(Runnable operation) {
        this.metricsSettingsAccess.lock();
        try {
            operation.run();
        }
        finally {
            this.metricsSettingsAccess.unlock();
        }
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public static RegistryFactory create() {
        return (RegistryFactory)RegistryFactory.class.cast(io.helidon.metrics.api.RegistryFactory.create());
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public static RegistryFactory create(Config config) {
        return (RegistryFactory)RegistryFactory.class.cast(io.helidon.metrics.api.RegistryFactory.create((Config)config));
    }

    static RegistryFactory create(MetricsSettings metricsSettings) {
        return new RegistryFactory(metricsSettings);
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public static RegistryFactory getInstance() {
        return (RegistryFactory)RegistryFactory.class.cast(io.helidon.metrics.api.RegistryFactory.getInstance());
    }

    @Deprecated(since="2.4.0", forRemoval=true)
    public static RegistryFactory getInstance(Config config) {
        return (RegistryFactory)RegistryFactory.class.cast(io.helidon.metrics.api.RegistryFactory.getInstance((Config)config));
    }

    Registry getARegistry(MetricRegistry.Type type) {
        if (type == MetricRegistry.Type.BASE) {
            this.ensureBase();
        }
        return this.registries.get(type);
    }

    public Registry getRegistry(MetricRegistry.Type type) {
        if (type == MetricRegistry.Type.BASE) {
            this.ensureBase();
        }
        return this.registries.get(type);
    }

    public void update(MetricsSettings metricsSettings) {
        this.accessMetricsSettings(() -> {
            this.metricsSettings = metricsSettings;
            this.registries.forEach((key, value) -> value.update(metricsSettings.registrySettings(key)));
        });
    }

    public boolean enabled() {
        return true;
    }

    public void start() {
        PeriodicExecutor.start();
    }

    public void stop() {
        PeriodicExecutor.stop();
    }

    private void ensureBase() {
        if (null == this.registries.get(MetricRegistry.Type.BASE)) {
            this.accessMetricsSettings(() -> {
                Registry registry = BaseRegistry.create(this.metricsSettings);
                this.registries.put(MetricRegistry.Type.BASE, registry);
            });
        }
    }
}

