/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.api.LabeledSnapshot;
import io.helidon.metrics.api.Sample;
import org.eclipse.microprofile.metrics.Snapshot;

class WrappedSnapshot
implements LabeledSnapshot {
    private final Snapshot delegate;
    private final Sample.Labeled[] samples;
    private final Sample.Derived median;
    private final Sample.Labeled max;
    private final Sample.Labeled min;
    private final Sample.Derived mean;
    private final Sample.Derived stdDev;
    private final Sample.Derived sample75th;
    private final Sample.Derived sample95th;
    private final Sample.Derived sample98th;
    private final Sample.Derived sample99th;
    private final Sample.Derived sample999th;

    static WrappedSnapshot create(Snapshot delegate) {
        return new WrappedSnapshot(delegate);
    }

    private WrappedSnapshot(Snapshot delegate) {
        this.delegate = delegate;
        long[] values = delegate.getValues();
        this.samples = new Sample.Labeled[values.length];
        for (int i = 0; i < values.length; ++i) {
            this.samples[i] = Sample.labeled((long)values[i]);
        }
        this.median = Sample.derived((double)delegate.getMedian());
        this.max = Sample.labeled((long)delegate.getMax());
        this.min = Sample.labeled((long)delegate.getMin());
        this.mean = Sample.derived((double)delegate.getMean());
        this.stdDev = Sample.derived((double)delegate.getStdDev());
        this.sample75th = Sample.derived((double)delegate.get75thPercentile());
        this.sample95th = Sample.derived((double)delegate.get95thPercentile());
        this.sample98th = Sample.derived((double)delegate.get98thPercentile());
        this.sample99th = Sample.derived((double)delegate.get99thPercentile());
        this.sample999th = Sample.derived((double)delegate.get999thPercentile());
    }

    public Sample.Derived value(double quantile) {
        return Sample.derived((double)this.delegate.getValue(quantile));
    }

    public Sample.Derived median() {
        return this.median;
    }

    public Sample.Derived sample75thPercentile() {
        return this.sample75th;
    }

    public Sample.Derived sample95thPercentile() {
        return this.sample95th;
    }

    public Sample.Derived sample98thPercentile() {
        return this.sample98th;
    }

    public Sample.Derived sample99thPercentile() {
        return this.sample99th;
    }

    public Sample.Derived sample999thPercentile() {
        return this.sample999th;
    }

    public Sample.Labeled max() {
        return this.max;
    }

    public Sample.Derived mean() {
        return this.mean;
    }

    public Sample.Labeled min() {
        return this.min;
    }

    public Sample.Derived stdDev() {
        return this.stdDev;
    }
}

