/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.config.Config;
import io.helidon.metrics.HelidonMetadata;
import io.helidon.metrics.Registry;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

final class BaseRegistry
extends Registry {
    private static final String CONFIG_METRIC_ENABLED_BASE = "base.";
    static final String BASE_ENABLED_KEY = "base.enabled";
    private static final Metadata MEMORY_USED_HEAP = new HelidonMetadata("memory.usedHeap", "Used Heap Memory", "Displays the amount of used heap memory in bytes.", MetricType.GAUGE, "bytes");
    private static final Metadata MEMORY_COMMITTED_HEAP = new HelidonMetadata("memory.committedHeap", "Committed Heap Memory", "Displays the amount of memory in bytes that is committed for the Java virtual machine to use. This amount of memory is guaranteed for the Java virtual machine to use.", MetricType.GAUGE, "bytes");
    private static final Metadata MEMORY_MAX_HEAP = new HelidonMetadata("memory.maxHeap", "Max Heap Memory", "Displays the maximum amount of heap memory in bytes that can be used for memory management. This attribute displays -1 if the maximum heap memory size is undefined. This amount of memory is not guaranteed to be available for memory management if it is greater than the amount of committed memory. The Java virtual machine may fail to allocate memory even if the amount of used memory does not exceed this maximum size.", MetricType.GAUGE, "bytes");
    private static final Metadata JVM_UPTIME = new HelidonMetadata("jvm.uptime", "JVM Uptime", "Displays the start time of the Java virtual machine in milliseconds. This attribute displays the approximate time when the Java virtual machine started.", MetricType.GAUGE, "milliseconds");
    private static final Metadata THREAD_COUNT = new HelidonMetadata("thread.count", "Thread Count", "Displays the current number of live threads including both daemon and nondaemon threads", MetricType.GAUGE, "none");
    private static final Metadata THREAD_DAEMON_COUNT = new HelidonMetadata("thread.daemon.count", "Daemon Thread Count", "Displays the current number of live daemon threads.", MetricType.GAUGE, "none");
    private static final Metadata THREAD_MAX_COUNT = new HelidonMetadata("thread.max.count", "Peak Thread Count", "Displays the peak live thread count since the Java virtual machine started or peak was reset. This includes daemon and non-daemon threads.", MetricType.GAUGE, "none");
    private static final Metadata CL_LOADED_COUNT = new HelidonMetadata("classloader.loadedClasses.count", "Current Loaded Class Count", "Displays the number of classes that are currently loaded in the Java virtual machine.", MetricType.GAUGE, "none");
    private static final Metadata CL_LOADED_TOTAL = new HelidonMetadata("classloader.loadedClasses.total", "Total Loaded Class Count", "Displays the total number of classes that have been loaded since the Java virtual machine has started execution.", MetricType.COUNTER, "none");
    private static final Metadata CL_UNLOADED_COUNT = new HelidonMetadata("classloader.unloadedClasses.total", "Total Unloaded Class Count", "Displays the total number of classes unloaded since the Java virtual machine has started execution.", MetricType.COUNTER, "none");
    private static final Metadata OS_AVAILABLE_CPU = new HelidonMetadata("cpu.availableProcessors", "Available Processors", "Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.", MetricType.GAUGE, "none");
    private static final Metadata OS_LOAD_AVERAGE = new HelidonMetadata("cpu.systemLoadAverage", "System Load Average", "Displays the system load average for the last minute. The system load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated is operating system specific but is typically a damped timedependent average. If the load average is not available, a negative value is displayed. This attribute is designed to provide a hint about the system load and may be queried frequently. The load average may be unavailable on some platforms where it is expensive to implement this method.", MetricType.GAUGE, "none");
    private final Config config;

    private BaseRegistry(Config config) {
        super(MetricRegistry.Type.BASE);
        this.config = config;
    }

    public static Registry create(Config config) {
        BaseRegistry result = new BaseRegistry(config);
        if (!((Boolean)config.get(BASE_ENABLED_KEY).asBoolean().orElse((Object)true)).booleanValue()) {
            return result;
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        BaseRegistry.register(result, MEMORY_USED_HEAP, (Metric)((Gauge)() -> memoryBean.getHeapMemoryUsage().getUsed()), new Tag[0]);
        BaseRegistry.register(result, MEMORY_COMMITTED_HEAP, (Metric)((Gauge)() -> memoryBean.getHeapMemoryUsage().getCommitted()), new Tag[0]);
        BaseRegistry.register(result, MEMORY_MAX_HEAP, (Metric)((Gauge)() -> memoryBean.getHeapMemoryUsage().getMax()), new Tag[0]);
        RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();
        BaseRegistry.register(result, JVM_UPTIME, (Metric)((Gauge)runtimeBean::getUptime), new Tag[0]);
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        BaseRegistry.register(result, THREAD_COUNT, (Metric)((Gauge)threadBean::getThreadCount), new Tag[0]);
        BaseRegistry.register(result, THREAD_DAEMON_COUNT, (Metric)((Gauge)threadBean::getDaemonThreadCount), new Tag[0]);
        BaseRegistry.register(result, THREAD_MAX_COUNT, (Metric)((Gauge)threadBean::getPeakThreadCount), new Tag[0]);
        ClassLoadingMXBean clBean = ManagementFactory.getClassLoadingMXBean();
        BaseRegistry.register(result, CL_LOADED_COUNT, (Metric)((Gauge)clBean::getLoadedClassCount), new Tag[0]);
        BaseRegistry.register(result, CL_LOADED_TOTAL, (Metric)((SimpleCounter)clBean::getTotalLoadedClassCount), new Tag[0]);
        BaseRegistry.register(result, CL_UNLOADED_COUNT, (Metric)((SimpleCounter)clBean::getUnloadedClassCount), new Tag[0]);
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        BaseRegistry.register(result, OS_AVAILABLE_CPU, (Metric)((Gauge)osBean::getAvailableProcessors), new Tag[0]);
        BaseRegistry.register(result, OS_LOAD_AVERAGE, (Metric)((Gauge)osBean::getSystemLoadAverage), new Tag[0]);
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            String poolName = gcBean.getName();
            BaseRegistry.register(result, BaseRegistry.gcCountMeta(), (Metric)((SimpleCounter)gcBean::getCollectionCount), new Tag("name", poolName));
            BaseRegistry.register(result, BaseRegistry.gcTimeMeta(), (Metric)((Gauge)gcBean::getCollectionTime), new Tag("name", poolName));
        }
        return result;
    }

    private static Metadata gcTimeMeta() {
        return new HelidonMetadata("gc.time", "Garbage Collection Time", "Displays the approximate accumulated collection elapsed time in milliseconds. This attribute displays -1 if the collection elapsed time is undefined for this collector. The Java virtual machine implementation may use a high resolution timer to measure the elapsed time. This attribute may display the same value even if the collection count has been incremented if the collection elapsed time is very short.", MetricType.GAUGE, "milliseconds");
    }

    private static Metadata gcCountMeta() {
        return new HelidonMetadata("gc.total", "Garbage Collection Count", "Displays the total number of collections that have occurred. This attribute lists -1 if the collection count is undefined for this collector.", MetricType.COUNTER, "none");
    }

    private static void register(BaseRegistry registry, Metadata meta, Metric metric, Tag ... tags) {
        if (((Boolean)registry.config.get(CONFIG_METRIC_ENABLED_BASE + meta.getName() + ".enabled").asBoolean().orElse((Object)true)).booleanValue()) {
            registry.register(meta, metric, tags);
        }
    }

    @FunctionalInterface
    private static interface SimpleCounter
    extends Counter {
        default public void inc() {
            throw new IllegalStateException("Cannot increase a system counter");
        }

        default public void inc(long n) {
            throw new IllegalStateException("Cannot increase a system counter");
        }
    }
}

