/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.common.metrics.InternalBridge;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

class InternalMetricIDImpl
implements InternalBridge.MetricID {
    private final MetricID delegate;

    InternalMetricIDImpl(String name) {
        this.delegate = new MetricID(name);
    }

    InternalMetricIDImpl(String name, Map<String, String> tags) {
        this.delegate = new MetricID(name, this.toTagArray(tags));
    }

    private Tag[] toTagArray(Map<String, String> tags) {
        return tags.entrySet().stream().map(entry -> new Tag((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList()).toArray(new Tag[0]);
    }

    public String getName() {
        return this.delegate.getName();
    }

    public Map<String, String> getTags() {
        return this.delegate.getTags();
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + Objects.hashCode(this.delegate);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InternalMetricIDImpl other = (InternalMetricIDImpl)obj;
        return Objects.equals(this.delegate, other.delegate);
    }

    static class FactoryImpl
    implements InternalBridge.MetricID.Factory {
        FactoryImpl() {
        }

        public InternalBridge.MetricID newMetricID(String name) {
            return new InternalMetricIDImpl(name);
        }

        public InternalBridge.MetricID newMetricID(String name, Map<String, String> tags) {
            return new InternalMetricIDImpl(name, tags);
        }
    }
}

