/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics;

import io.helidon.metrics.HelidonMetric;
import io.helidon.metrics.MetricsSupport;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObjectBuilder;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.Tag;

abstract class MetricImpl
implements HelidonMetric {
    static final JsonBuilderFactory JSON = Json.createBuilderFactory(Collections.emptyMap());
    private static final Pattern DOUBLE_UNDERSCORE = Pattern.compile("__");
    private static final Pattern COLON_UNDERSCORE = Pattern.compile(":_");
    private static final Pattern CAMEL_CASE = Pattern.compile("(.)(\\p{Upper})");
    private static final Map<String, Units> PROMETHEUS_CONVERTERS = new HashMap<String, Units>();
    private static final long KILOBITS = 125L;
    private static final long MEGABITS = 125000L;
    private static final long GIGABITS = 125000000L;
    private static final long KIBIBITS = 128L;
    private static final long MEBIBITS = 131072L;
    private static final long GIBIBITS = 0x8000000L;
    private static final long KILOBYTES = 1000L;
    private static final long MEGABYTES = 1000000L;
    private static final long GIGABYTES = 1000000000L;
    private static final Map<String, String> JSON_ESCAPED_CHARS_MAP = MetricImpl.initEscapedCharsMap();
    private static final Pattern JSON_ESCAPED_CHARS_REGEX = Pattern.compile(JSON_ESCAPED_CHARS_MAP.keySet().stream().map(Pattern::quote).collect(Collectors.joining("", "[", "]")));
    private final String registryType;
    private final Metadata metadata;

    private static String bsls(String s) {
        return "\\\\" + s;
    }

    private static Map<String, String> initEscapedCharsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("\b", MetricImpl.bsls("b"));
        result.put("\f", MetricImpl.bsls("f"));
        result.put("\n", MetricImpl.bsls("n"));
        result.put("\r", MetricImpl.bsls("r"));
        result.put("\t", MetricImpl.bsls("t"));
        result.put("\"", MetricImpl.bsls("\""));
        result.put("\\", MetricImpl.bsls("\\\\"));
        result.put(";", "_");
        return result;
    }

    MetricImpl(String registryType, Metadata metadata) {
        this.metadata = metadata;
        this.registryType = registryType;
    }

    private static void addByteConverter(String metricUnit, long toByteRatio) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new Units(metricUnit, "bytes", o -> ((Number)o).doubleValue() * (double)toByteRatio));
    }

    private static void addConverter(Units units) {
        PROMETHEUS_CONVERTERS.put(units.getMetricUnit(), units);
    }

    private static void addTimeConverter(String metricUnit, TimeUnit timeUnit) {
        PROMETHEUS_CONVERTERS.put(metricUnit, new TimeUnits(metricUnit, timeUnit));
    }

    @Override
    public String getName() {
        return this.metadata.getName();
    }

    @Override
    public Metadata metadata() {
        return this.metadata;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{registryType='" + this.registryType + '\'' + ", metadata=" + this.metadata + ", name='" + this.getName() + '\'' + '}';
    }

    @Override
    public void jsonMeta(JsonObjectBuilder builder, List<MetricID> metricIDs) {
        MetricsSupport.MergingJsonObjectBuilder metaBuilder = new MetricsSupport.MergingJsonObjectBuilder(JSON.createObjectBuilder());
        this.addNonEmpty(metaBuilder, "unit", this.metadata.getUnit().orElse(null));
        this.addNonEmpty(metaBuilder, "type", this.metadata.getType());
        this.addNonEmpty(metaBuilder, "description", this.metadata.getDescription().orElse(null));
        this.addNonEmpty(metaBuilder, "displayName", this.metadata.getDisplayName());
        if (metricIDs != null) {
            for (MetricID metricID : metricIDs) {
                boolean tagAdded = false;
                JsonArrayBuilder ab = JSON.createArrayBuilder();
                for (Tag tag : metricID.getTagsAsList()) {
                    tagAdded = true;
                    ab.add(MetricImpl.tagForJsonKey(tag));
                }
                if (!tagAdded) continue;
                metaBuilder.add("tags", ab);
            }
        }
        builder.add(this.getName(), (JsonObjectBuilder)metaBuilder);
    }

    static String jsonFullKey(String baseName, MetricID metricID) {
        return metricID.getTags().isEmpty() ? baseName : String.format("%s;%s", baseName, metricID.getTagsAsList().stream().map(MetricImpl::tagForJsonKey).collect(Collectors.joining(";")));
    }

    static String jsonFullKey(MetricID metricID) {
        return MetricImpl.jsonFullKey(metricID.getName(), metricID);
    }

    private static String tagForJsonKey(Tag t) {
        return String.format("%s=%s", MetricImpl.jsonEscape(t.getTagName()), MetricImpl.jsonEscape(t.getTagValue()));
    }

    static String jsonEscape(String s) {
        Matcher m = JSON_ESCAPED_CHARS_REGEX.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(sb, JSON_ESCAPED_CHARS_MAP.get(m.group()));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    void prometheusType(StringBuilder sb, String nameWithUnits, String type) {
        sb.append("# TYPE ").append(nameWithUnits).append(" ").append(type).append('\n');
    }

    void prometheusHelp(StringBuilder sb, String nameWithUnits) {
        sb.append("# HELP ").append(nameWithUnits).append(" ").append(this.metadata.getDescription().orElse("")).append('\n');
    }

    @Override
    public void prometheusData(StringBuilder sb, MetricID metricID, boolean withHelpType) {
        String nameWithUnits = this.prometheusNameWithUnits(metricID);
        if (withHelpType) {
            this.prometheusType(sb, nameWithUnits, this.metadata.getType());
            this.prometheusHelp(sb, nameWithUnits);
        }
        sb.append(nameWithUnits).append(this.prometheusTags(metricID.getTags())).append(" ").append(this.prometheusValue()).append('\n');
    }

    @Override
    public String prometheusNameWithUnits(MetricID metricID) {
        return this.prometheusNameWithUnits(metricID.getName(), this.getUnits().getPrometheusUnit());
    }

    public abstract String prometheusValue();

    protected final void prometheusQuantile(StringBuilder sb, String tags, Units units, String nameUnits, String quantile, Supplier<Double> value) {
        String quantileTag = "quantile=\"" + quantile + "\"";
        tags = tags.isEmpty() ? "{" + quantileTag + "}" : tags.substring(0, tags.length() - 1) + "," + quantileTag + "}";
        sb.append(nameUnits).append(tags).append(" ").append(units.convert(value.get())).append("\n");
    }

    final String prometheusNameWithUnits(String name, Optional<String> unit) {
        return this.prometheusName(name) + unit.map(it -> "_" + it).orElse("");
    }

    final String prometheusName(String name) {
        return this.prometheusClean(name, this.registryType + "_");
    }

    private String prometheusClean(String name, String prefix) {
        String orig;
        name = name.replaceAll("[^a-zA-Z0-9_]", "_");
        name = prefix + name;
        while (!(orig = name).equals(name = DOUBLE_UNDERSCORE.matcher(name).replaceAll("_"))) {
        }
        while (!(orig = name).equals(name = COLON_UNDERSCORE.matcher(name).replaceAll(":"))) {
        }
        return name;
    }

    final String prometheusTags(Map<String, String> tags) {
        return tags == null || tags.isEmpty() ? "" : tags.entrySet().stream().filter(entry -> entry.getKey() != null).map(entry -> String.format("%s=\"%s\"", this.prometheusClean((String)entry.getKey(), ""), this.prometheusTagValue((String)entry.getValue()))).collect(Collectors.joining(",", "{", "}"));
    }

    private String prometheusTagValue(String value) {
        value = value.replace("\\", "\\\\");
        value = value.replace("\"", "\\\"");
        value = value.replace("\n", "\\n");
        return value;
    }

    String camelToSnake(String name) {
        return CAMEL_CASE.matcher(name).replaceAll("$1_$2").toLowerCase();
    }

    void addNonEmpty(JsonObjectBuilder builder, String name, String value) {
        if (null != value && !value.isEmpty()) {
            builder.add(name, value);
        }
    }

    Units getUnits() {
        String unit = (String)this.metadata.getUnit().get();
        if (null == unit || unit.isEmpty() || "none".equals(unit)) {
            return new Units(null);
        }
        Units units = PROMETHEUS_CONVERTERS.get(unit);
        if (null == units) {
            return new Units(unit, unit, o -> o);
        }
        return units;
    }

    static {
        MetricImpl.addTimeConverter("nanoseconds", TimeUnit.NANOSECONDS);
        MetricImpl.addTimeConverter("microseconds", TimeUnit.MICROSECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("seconds", TimeUnit.SECONDS);
        MetricImpl.addTimeConverter("milliseconds", TimeUnit.MILLISECONDS);
        MetricImpl.addTimeConverter("minutes", TimeUnit.MINUTES);
        MetricImpl.addTimeConverter("hours", TimeUnit.HOURS);
        MetricImpl.addTimeConverter("days", TimeUnit.DAYS);
        MetricImpl.addConverter(new Units("bits", "bytes", o -> (Double)o / 8.0));
        MetricImpl.addByteConverter("kilobits", 125L);
        MetricImpl.addByteConverter("megabits", 125000L);
        MetricImpl.addByteConverter("gigabits", 125000000L);
        MetricImpl.addByteConverter("kibibits", 128L);
        MetricImpl.addByteConverter("mebibits", 131072L);
        MetricImpl.addByteConverter("gibibits", 0x8000000L);
        MetricImpl.addByteConverter("kilobytes", 1000L);
        MetricImpl.addByteConverter("megabytes", 1000000L);
        MetricImpl.addByteConverter("gigabytes", 1000000000L);
        MetricImpl.addConverter(new Units("fahrenheits", "celsius", o -> (((Number)o).doubleValue() - 32.0) * 5.0 / 9.0));
        MetricImpl.addConverter(new LengthUnits("millimeters", 0.001));
        MetricImpl.addConverter(new LengthUnits("centimeters", 0.01));
        MetricImpl.addConverter(new LengthUnits("kilometers", 1000.0));
    }

    static class Units {
        private final String metricUnit;
        private final String prometheusUnit;
        private final Function<Object, Object> converter;

        Units(String unit) {
            this.metricUnit = unit;
            this.prometheusUnit = unit;
            this.converter = o -> o;
        }

        private Units(String metricUnit, String prometheusUnit, Function<Object, Object> converter) {
            this.metricUnit = metricUnit;
            this.prometheusUnit = prometheusUnit;
            this.converter = converter;
        }

        String getMetricUnit() {
            return this.metricUnit;
        }

        Optional<String> getPrometheusUnit() {
            return Optional.ofNullable(this.prometheusUnit);
        }

        public Object convert(Object value) {
            double num;
            Object apply = this.converter.apply(value);
            if (apply instanceof Double && Math.floor(num = ((Double)apply).doubleValue()) == num) {
                return (long)num;
            }
            return apply;
        }
    }

    static final class TimeUnits
    extends Units {
        private static final long MILLISECONDS = 1000L;
        private static final long MICROSECONDS = 1000000L;
        private static final long NANOSECONDS = 1000000000L;
        private static final String DOUBLE_NAN = String.valueOf(Double.NaN);
        private static final BiFunction<Object, Function<Object, Object>, Object> CHECK_NANS = (o, f) -> o instanceof Double && ((Double)o).isNaN() ? DOUBLE_NAN : f.apply(o);

        private TimeUnits(String metricUnit, TimeUnit timeUnit) {
            super(metricUnit, "seconds", TimeUnits.timeConverter(timeUnit));
        }

        static Function<Object, Object> timeConverter(TimeUnit from) {
            switch (from) {
                case NANOSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(p)).doubleValue() / 1.0E9));
                }
                case MICROSECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000000.0));
                }
                case MILLISECONDS: {
                    return o -> CHECK_NANS.apply(o, p -> String.valueOf(new BigDecimal(String.valueOf(o)).doubleValue() / 1000.0));
                }
                case SECONDS: {
                    return o -> CHECK_NANS.apply(o, String::valueOf);
                }
            }
            return o -> CHECK_NANS.apply(o, p -> String.valueOf(TimeUnit.SECONDS.convert(new BigDecimal(String.valueOf(o)).longValue(), from)));
        }
    }

    private static final class LengthUnits
    extends Units {
        private LengthUnits(String metricUnit, double ratio) {
            super(metricUnit, "meters", o -> ((Number)o).doubleValue() * ratio);
        }
    }
}

