/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.ScopingConfig;
import io.helidon.metrics.api.SystemTagsManager;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.providers.micrometer.MClock;
import io.helidon.metrics.providers.micrometer.MCounter;
import io.helidon.metrics.providers.micrometer.MDistributionSummary;
import io.helidon.metrics.providers.micrometer.MFunctionalCounter;
import io.helidon.metrics.providers.micrometer.MGauge;
import io.helidon.metrics.providers.micrometer.MMeter;
import io.helidon.metrics.providers.micrometer.MTag;
import io.helidon.metrics.providers.micrometer.MTimer;
import io.helidon.metrics.providers.micrometer.MicrometerMetricsFactory;
import io.helidon.metrics.providers.micrometer.Util;
import io.helidon.metrics.spi.MetersProvider;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.search.Search;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

class MMeterRegistry
implements io.helidon.metrics.api.MeterRegistry {
    private static final System.Logger LOGGER = System.getLogger(MMeterRegistry.class.getName());
    private final MeterRegistry delegate;
    private final List<Consumer<io.helidon.metrics.api.Meter>> onAddListeners = new ArrayList<Consumer<io.helidon.metrics.api.Meter>>();
    private final List<Consumer<io.helidon.metrics.api.Meter>> onRemoveListeners = new ArrayList<Consumer<io.helidon.metrics.api.Meter>>();
    private final io.helidon.metrics.api.Clock clock;
    private final MicrometerMetricsFactory metricsFactory;
    private final MetricsConfig metricsConfig;
    private final Map<Meter, MMeter> meters = new HashMap<Meter, MMeter>();
    private final Map<String, Map<Meter.Id, MMeter.Builder<?, ?, ?, ?>>> buildersByPromMeterId = new HashMap();
    private final Map<String, Set<io.helidon.metrics.api.Meter>> scopeMembership = new HashMap<String, Set<io.helidon.metrics.api.Meter>>();
    private final Map<Meter.Id, MMeter<?>> metersById = new HashMap();
    private final ReentrantLock lock = new ReentrantLock();

    private MMeterRegistry(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, MetricsConfig metricsConfig, io.helidon.metrics.api.Clock clock) {
        this.delegate = delegate;
        this.clock = clock;
        this.metricsFactory = metricsFactory;
        this.metricsConfig = metricsConfig;
    }

    static Builder builder(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory) {
        return new Builder(delegate, metricsFactory);
    }

    static MMeterRegistry create(MicrometerMetricsFactory metricsFactory, io.helidon.metrics.api.Clock clock, Collection<MetersProvider> metersProviders) {
        CompositeMeterRegistry delegate = new CompositeMeterRegistry((Clock)ClockWrapper.create(clock));
        return MMeterRegistry.create((MeterRegistry)delegate, metricsFactory, metricsFactory.metricsConfig(), clock, metersProviders);
    }

    static MMeterRegistry create(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, MetricsConfig metricsConfig, Collection<MetersProvider> metersProviders) {
        return MMeterRegistry.create(delegate, metricsFactory, metricsConfig, MClock.create(delegate.config().clock()), metersProviders);
    }

    static MMeterRegistry create(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, MetricsConfig metricsConfig, Collection<MetersProvider> metersProviders, Consumer<io.helidon.metrics.api.Meter> onAddListener, Consumer<io.helidon.metrics.api.Meter> onRemoveListener) {
        MMeterRegistry result = MMeterRegistry.create(delegate, metricsFactory, metricsConfig, MClock.create(delegate.config().clock()));
        result.onMeterAdded(onAddListener).onMeterRemoved(onRemoveListener);
        return MMeterRegistry.applyMetersProvidersToRegistry(metricsFactory, result, metersProviders);
    }

    static MMeterRegistry create(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, MetricsConfig metricsConfig, io.helidon.metrics.api.Clock clock, Collection<MetersProvider> metersProviders) {
        return MMeterRegistry.applyMetersProvidersToRegistry(metricsFactory, MMeterRegistry.create(delegate, metricsFactory, metricsConfig, clock), metersProviders);
    }

    static MMeterRegistry create(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, MetricsConfig metricsConfig, io.helidon.metrics.api.Clock clock) {
        MeterRegistry preppedDelegate = MMeterRegistry.ensurePrometheusRegistryIsPresent(delegate, metricsFactory.metricsConfig());
        return new MMeterRegistry(preppedDelegate, metricsFactory, metricsConfig, clock);
    }

    static MMeterRegistry create(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory, Collection<MetersProvider> metersProviders) {
        return MMeterRegistry.create(delegate, metricsFactory, metricsFactory.metricsConfig(), MClock.create(delegate.config().clock()), metersProviders);
    }

    static MMeterRegistry applyMetersProvidersToRegistry(MetricsFactory factory, MMeterRegistry registry, Collection<MetersProvider> metersProviders) {
        metersProviders.stream().flatMap(mp -> mp.meterBuilders(factory).stream()).forEach(registry::getOrCreateUntyped);
        return registry;
    }

    public void close() {
        this.onAddListeners.clear();
        this.onRemoveListeners.clear();
        this.meters.clear();
        this.buildersByPromMeterId.clear();
        this.scopeMembership.clear();
        this.metersById.clear();
    }

    public List<io.helidon.metrics.api.Meter> meters() {
        return this.meters.values().stream().map(io.helidon.metrics.api.Meter.class::cast).toList();
    }

    public Collection<io.helidon.metrics.api.Meter> meters(Predicate<io.helidon.metrics.api.Meter> filter) {
        return this.meters.values().stream().map(io.helidon.metrics.api.Meter.class::cast).filter(filter).toList();
    }

    public Iterable<String> scopes() {
        return this.scopeMembership.keySet();
    }

    public boolean isMeterEnabled(String name, Map<String, String> tags, Optional<String> scope) {
        return this.metricsConfig.enabled();
    }

    public io.helidon.metrics.api.Clock clock() {
        return this.clock;
    }

    public <HB extends Meter.Builder<HB, HM>, HM extends io.helidon.metrics.api.Meter> HM getOrCreate(HB builder) {
        if (builder instanceof MMeter.Builder) {
            MMeter.Builder mBuilder = (MMeter.Builder)builder;
            return (HM)this.getOrCreateUntyped((Meter.Builder)mBuilder);
        }
        return (HM)this.getOrCreateUntyped((Meter.Builder)this.convertNeutralBuilder(builder));
    }

    public <M extends io.helidon.metrics.api.Meter> Optional<M> meter(Class<M> mClass, String name, Iterable<Tag> tags) {
        Search search = this.delegate().find(name).tags(MTag.tags(tags));
        Meter match = search.meter();
        if (match == null) {
            return Optional.empty();
        }
        io.helidon.metrics.api.Meter neutralMeter = this.meters.get(match);
        if (neutralMeter == null) {
            LOGGER.log(System.Logger.Level.WARNING, String.format("Found no Helidon counterpart for Micrometer meter %s %s", name, Util.list(tags)));
            return Optional.empty();
        }
        if (mClass.isInstance(neutralMeter)) {
            return Optional.of((io.helidon.metrics.api.Meter)mClass.cast(neutralMeter));
        }
        throw new IllegalArgumentException(String.format("Matching meter is of type %s but %s was requested", match.getClass().getName(), mClass.getName()));
    }

    public Optional<io.helidon.metrics.api.Meter> remove(io.helidon.metrics.api.Meter meter) {
        return this.internalRemove(meter.id(), meter.scope());
    }

    public Optional<io.helidon.metrics.api.Meter> remove(Meter.Id id) {
        return this.internalRemove(id, Optional.empty());
    }

    public Optional<io.helidon.metrics.api.Meter> remove(String name, Iterable<Tag> tags) {
        return this.internalRemove(MMeter.PlainId.create(name, tags), Optional.empty());
    }

    public Optional<io.helidon.metrics.api.Meter> remove(Meter.Id id, String scope) {
        return this.internalRemove(id, Optional.ofNullable(scope));
    }

    public Optional<io.helidon.metrics.api.Meter> remove(String name, Iterable<Tag> tags, String scope) {
        return this.internalRemove(MMeter.PlainId.create(name, tags), Optional.ofNullable(scope));
    }

    public boolean isDeleted(io.helidon.metrics.api.Meter meter) {
        MMeter helidonMeter;
        return meter instanceof MMeter && (helidonMeter = (MMeter)meter).isDeleted();
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }

    MeterRegistry delegate() {
        return this.delegate;
    }

    public Iterable<io.helidon.metrics.api.Meter> meters(Iterable<String> scopeSelection) {
        if (scopeSelection.iterator().hasNext()) {
            HashSet<io.helidon.metrics.api.Meter> result = new HashSet<io.helidon.metrics.api.Meter>();
            for (String scope : scopeSelection) {
                if (!this.scopeMembership.containsKey(scope)) continue;
                result.addAll((Collection<io.helidon.metrics.api.Meter>)this.scopeMembership.get(scope));
            }
            return result;
        }
        return this.meters();
    }

    public io.helidon.metrics.api.MeterRegistry onMeterAdded(Consumer<io.helidon.metrics.api.Meter> listener) {
        this.onAddListeners.add(listener);
        return this;
    }

    public io.helidon.metrics.api.MeterRegistry onMeterRemoved(Consumer<io.helidon.metrics.api.Meter> listener) {
        this.onRemoveListeners.add(listener);
        return this;
    }

    void erase() {
        this.lock.lock();
        try {
            this.buildersByPromMeterId.clear();
            this.meters.clear();
            this.onAddListeners.clear();
            this.onRemoveListeners.clear();
            this.scopeMembership.clear();
            this.metersById.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    io.helidon.metrics.api.Meter getOrCreateUntyped(Meter.Builder<?, ?> builder) {
        this.lock.lock();
        try {
            Object helidonMeter;
            if (!this.isMeterEnabled(builder.name(), builder.tags(), builder.scope())) {
                io.helidon.metrics.api.Meter meter = this.metricsFactory.noOpMeter(builder);
                return meter;
            }
            if (builder instanceof MCounter.Builder) {
                MCounter.Builder cBuilder = (MCounter.Builder)builder;
                helidonMeter = this.getOrCreate(cBuilder, cBuilder::addTag, arg_0 -> ((Counter.Builder)((Counter.Builder)cBuilder.delegate())).register(arg_0));
            } else if (builder instanceof MFunctionalCounter.Builder) {
                MFunctionalCounter.Builder fcBuilder = (MFunctionalCounter.Builder)builder;
                helidonMeter = this.getOrCreate(fcBuilder, fcBuilder::addTag, arg_0 -> ((FunctionCounter.Builder)((FunctionCounter.Builder)fcBuilder.delegate())).register(arg_0));
            } else if (builder instanceof MDistributionSummary.Builder) {
                MDistributionSummary.Builder sBuilder = (MDistributionSummary.Builder)builder;
                helidonMeter = this.getOrCreate(sBuilder, sBuilder::addTag, arg_0 -> ((DistributionSummary.Builder)((DistributionSummary.Builder)sBuilder.delegate())).register(arg_0));
            } else if (builder instanceof MGauge.Builder) {
                MGauge.Builder gBuilder = (MGauge.Builder)builder;
                helidonMeter = this.getOrCreate(gBuilder, gBuilder::addTag, arg_0 -> ((Gauge.Builder)((Gauge.Builder)gBuilder.delegate())).register(arg_0));
            } else if (builder instanceof MTimer.Builder) {
                MTimer.Builder tBuilder = (MTimer.Builder)builder;
                helidonMeter = this.getOrCreate(tBuilder, tBuilder::addTag, arg_0 -> ((Timer.Builder)((Timer.Builder)tBuilder.delegate())).register(arg_0));
            } else {
                throw new IllegalArgumentException(String.format("Unexpected builder type %s, expected one of %s", builder.getClass().getName(), List.of(MCounter.Builder.class.getName(), MFunctionalCounter.Builder.class.getName(), MDistributionSummary.Builder.class.getName(), MGauge.Builder.class.getName(), MTimer.Builder.class.getName())));
            }
            Object HM = helidonMeter;
            return HM;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <HM extends MMeter<M>, M extends Meter, B, HB extends MMeter.Builder<B, M, HB, HM>> void onMeterAdded(M addedMeter) {
        this.lock.lock();
        try {
            Object mMeter;
            Meter.Id id;
            Meter.Id neutralIdForAddedMeter = this.neutralIdWithoutSystemTags(addedMeter.getId());
            Optional<String> scope = SystemTagsManager.instance().effectiveScope(Optional.empty(), neutralIdForAddedMeter.tags());
            Map<Meter.Id, MMeter.Builder<?, ?, ?, ?>> buildersInScope = this.buildersByPromMeterId.get(scope.orElse(""));
            MMeter.Builder<?, ?, ?, ?> builder = null;
            if (buildersInScope != null) {
                builder = buildersInScope.get(neutralIdForAddedMeter);
            }
            scope = this.chooseScope(addedMeter, builder != null ? builder.scope() : Optional.empty());
            if (builder == null) {
                if (scope.isEmpty()) {
                    LOGGER.log(System.Logger.Level.DEBUG, "Processing meter creation with no scope from the meter or configuration: " + String.valueOf(addedMeter));
                }
                id = neutralIdForAddedMeter;
                mMeter = MMeter.create(id, addedMeter, scope);
            } else {
                id = builder.id();
                scope.ifPresent(builder::scope);
                mMeter = builder.build(id, addedMeter);
            }
            this.recordNewMeter(id, (MMeter<?>)mMeter, addedMeter, scope);
            if (buildersInScope != null) {
                buildersInScope.remove(id);
            }
            this.onAddListeners.forEach(listener -> {
                try {
                    listener.accept(mMeter);
                }
                catch (Exception ex) {
                    LOGGER.log(System.Logger.Level.ERROR, "Error invoking on-add callback listener " + String.valueOf(listener), (Throwable)ex);
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }

    void onMeterRemoved(Meter removedMeter) {
        this.lock.lock();
        try {
            MMeter removedHelidonMeter = this.meters.remove(removedMeter);
            if (removedHelidonMeter == null) {
                LOGGER.log(System.Logger.Level.WARNING, "No matching neutral meter for implementation meter " + String.valueOf(removedMeter));
            } else {
                this.recordRemove(removedHelidonMeter);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private static MeterRegistry ensurePrometheusRegistryIsPresent(MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        CompositeMeterRegistry compositeMeterRegistry;
        if (meterRegistry instanceof CompositeMeterRegistry && (compositeMeterRegistry = (CompositeMeterRegistry)meterRegistry).getRegistries().stream().noneMatch(r -> r instanceof PrometheusMeterRegistry)) {
            compositeMeterRegistry.add((MeterRegistry)new PrometheusMeterRegistry(key -> metricsConfig.lookupConfig(key).orElse(null)));
        }
        return meterRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends Meter, HB extends MMeter.Builder<?, M, HB, HM>, HM extends MMeter<M>> HM getOrCreate(HB mBuilder, Function<Tag, ?> builderTagSetter, Function<MeterRegistry, M> registration) {
        Optional effectiveScope = SystemTagsManager.instance().effectiveScope(mBuilder.scope());
        effectiveScope.ifPresent(realScope -> SystemTagsManager.instance().assignScope(realScope, builderTagSetter));
        Meter.Id id = mBuilder.id();
        MMeter<?> foundMeter = this.metersById.get(id);
        if (foundMeter != null) {
            if (!mBuilder.meterType().isInstance(foundMeter)) {
                throw new IllegalArgumentException("Attempt to get or create a meter of type " + mBuilder.meterType().getName() + " when an existing meter " + String.valueOf(id) + " has an incompatible type " + foundMeter.getClass().getName());
            }
            return (HM)foundMeter;
        }
        this.lock.lock();
        try {
            Map pendingBuildersInScope = this.buildersByPromMeterId.computeIfAbsent(effectiveScope.orElse(""), k -> new HashMap());
            HB previousBuilderWithId = pendingBuildersInScope.put(id, mBuilder);
            if (previousBuilderWithId != null) {
                LOGGER.log(System.Logger.Level.WARNING, "Unexpected overwrite of existing pending builder " + String.valueOf(previousBuilderWithId) + " during creation of new meter " + String.valueOf(mBuilder));
            }
            Meter meter = (Meter)registration.apply(this.delegate());
            pendingBuildersInScope.remove(id);
            MMeter<Object> result = this.meters.get(meter);
            if (result == null) {
                LOGGER.log(System.Logger.Level.WARNING, "Unexpected discovery of unknown previously-created meter; creating wrapper for " + String.valueOf(meter));
                result = this.wrapMeter(id, meter, mBuilder.scope());
                this.recordNewMeter(id, result, meter, effectiveScope);
            }
            MMeter mMeter = result;
            return (HM)mMeter;
        }
        finally {
            this.lock.unlock();
        }
    }

    private <M extends Meter, HB extends MMeter.Builder<?, M, HB, HM>, HM extends MMeter<M>> HM wrapMeter(Meter.Id id, M addedMeter, Optional<String> scope) {
        MMeter helidonMeter = null;
        Optional<String> scopeToUse = this.chooseScope(addedMeter, scope);
        if (addedMeter instanceof Counter) {
            Counter counter = (Counter)addedMeter;
            helidonMeter = MCounter.create(id, counter, scopeToUse);
        } else if (addedMeter instanceof DistributionSummary) {
            DistributionSummary summary = (DistributionSummary)addedMeter;
            helidonMeter = MDistributionSummary.create(id, summary, scopeToUse);
        } else if (addedMeter instanceof Gauge) {
            Gauge gauge = (Gauge)addedMeter;
            helidonMeter = MGauge.create(id, gauge, scopeToUse);
        } else if (addedMeter instanceof Timer) {
            Timer timer = (Timer)addedMeter;
            helidonMeter = MTimer.create(id, timer, scopeToUse);
        } else if (addedMeter instanceof FunctionCounter) {
            FunctionCounter functionCounter = (FunctionCounter)addedMeter;
            helidonMeter = MFunctionalCounter.create(id, functionCounter, scopeToUse);
        }
        if (helidonMeter == null) {
            LOGGER.log(System.Logger.Level.DEBUG, String.format("Addition of meter %s which is of an unsupported type; ignored", addedMeter));
        }
        return (HM)helidonMeter;
    }

    private <M extends Meter, HB extends MMeter.Builder<?, M, HB, HM>, HM extends MMeter<M>> HB convertNeutralBuilder(Meter.Builder<?, ?> builder) {
        if (builder instanceof Counter.Builder) {
            Counter.Builder cBuilder = (Counter.Builder)builder;
            return MCounter.builder(cBuilder.name()).from((Meter.Builder<?, ?>)cBuilder);
        }
        if (builder instanceof FunctionalCounter.Builder) {
            FunctionalCounter.Builder fcBuilder = (FunctionalCounter.Builder)builder;
            return (HB)MFunctionalCounter.builderFrom(fcBuilder);
        }
        if (builder instanceof Gauge.Builder) {
            Gauge.Builder gBuilder = (Gauge.Builder)builder;
            return (HB)MGauge.builderFrom(gBuilder);
        }
        if (builder instanceof DistributionSummary.Builder) {
            DistributionSummary.Builder sBuilder = (DistributionSummary.Builder)builder;
            return (HB)MDistributionSummary.builderFrom(sBuilder);
        }
        if (builder instanceof Timer.Builder) {
            Timer.Builder tBuilder = (Timer.Builder)builder;
            return (HB)MTimer.builderFrom(tBuilder);
        }
        throw new IllegalArgumentException("Unexpected builder type: " + builder.getClass().getName());
    }

    private Optional<String> chooseScope(Meter meter, Optional<String> reliableScope) {
        return reliableScope.or(() -> this.metricsConfig.scoping().tagName().map(scopeTagName -> meter.getId().getTag(scopeTagName)).filter(scopeTagValue -> !scopeTagValue.isBlank())).or(() -> MMeterRegistry.lambda$chooseScope$9(this.metricsConfig.scoping()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<io.helidon.metrics.api.Meter> internalRemove(Meter.Id id, Optional<String> scope) {
        Iterable tags = SystemTagsManager.instance().withScopeTag(id.tags(), scope);
        Meter nativeMeter = this.delegate.find(id.name()).tags(MTag.tags(tags)).meter();
        this.lock.lock();
        try {
            if (nativeMeter != null) {
                MMeter result = this.meters.get(nativeMeter);
                this.delegate.remove(nativeMeter);
                this.onRemoveListeners.forEach(listener -> listener.accept(result));
                Optional<io.helidon.metrics.api.Meter> optional = Optional.of(result);
                return optional;
            }
            Optional<io.helidon.metrics.api.Meter> optional = Optional.empty();
            return optional;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Meter.Id neutralIdWithoutSystemTags(Meter.Id micrometerId) {
        return MMeter.PlainId.create(micrometerId.getName(), SystemTagsManager.instance().withoutSystemTags(MTag.neutralTags(micrometerId.getTags())));
    }

    private void recordNewMeter(Meter.Id id, MMeter<?> newNeutralMeter, Meter delegate, Optional<String> scope) {
        this.meters.put(delegate, newNeutralMeter);
        this.metersById.put(id, newNeutralMeter);
        scope.ifPresent(s -> this.scopeMembership.computeIfAbsent((String)s, key -> new HashSet()).add(newNeutralMeter));
    }

    private MMeter<?> recordRemove(MMeter<?> removedHelidonMeter) {
        this.metersById.remove(removedHelidonMeter.id());
        removedHelidonMeter.markAsDeleted();
        removedHelidonMeter.scope().ifPresent(scope -> {
            Set<io.helidon.metrics.api.Meter> scopeMembers = this.scopeMembership.get(scope);
            if (scopeMembers != null) {
                scopeMembers.remove(removedHelidonMeter);
            }
        });
        this.onRemoveListeners.forEach(listener -> listener.accept(removedHelidonMeter));
        return removedHelidonMeter;
    }

    private static /* synthetic */ Optional lambda$chooseScope$9(ScopingConfig rec$) {
        return rec$.defaultValue();
    }

    static class Builder<B extends Builder<B, R>, R extends MMeterRegistry>
    implements MeterRegistry.Builder<B, R> {
        private final MeterRegistry delegate;
        private final MicrometerMetricsFactory metricsFactory;
        private final Collection<MetersProvider> metersProviders = new ArrayList<MetersProvider>();
        private MetricsConfig metricsConfig;
        private Optional<io.helidon.metrics.api.Clock> clock = Optional.empty();
        private Optional<Consumer<io.helidon.metrics.api.Meter>> onAddListener = Optional.empty();
        private Optional<Consumer<io.helidon.metrics.api.Meter>> onRemoveListener = Optional.empty();

        private Builder(MeterRegistry delegate, MicrometerMetricsFactory metricsFactory) {
            this.delegate = delegate;
            this.metricsFactory = metricsFactory;
            this.metricsConfig = metricsFactory.metricsConfig();
        }

        B metersProviders(Collection<MetersProvider> metersProviders) {
            this.metersProviders.clear();
            this.metersProviders.addAll(metersProviders);
            return (B)((Builder)this.identity());
        }

        public B metricsConfig(MetricsConfig metricsConfig) {
            this.metricsConfig = metricsConfig;
            return (B)((Builder)this.identity());
        }

        public B clock(io.helidon.metrics.api.Clock clock) {
            this.clock = Optional.of(clock);
            return (B)((Builder)this.identity());
        }

        public B onMeterAdded(Consumer<io.helidon.metrics.api.Meter> listener) {
            this.onAddListener = Optional.of(listener);
            return (B)((Builder)this.identity());
        }

        public B onMeterRemoved(Consumer<io.helidon.metrics.api.Meter> listener) {
            this.onRemoveListener = Optional.of(listener);
            return (B)((Builder)this.identity());
        }

        public R build() {
            MMeterRegistry result = new MMeterRegistry(this.delegate, this.metricsFactory, this.metricsConfig, this.clock.orElse(MClock.create(this.delegate.config().clock())));
            this.onAddListener.ifPresent(result::onMeterAdded);
            this.onRemoveListener.ifPresent(result::onMeterRemoved);
            return (R)MMeterRegistry.applyMetersProvidersToRegistry(this.metricsFactory, result, this.metersProviders);
        }
    }

    private static class ClockWrapper
    implements Clock {
        private final io.helidon.metrics.api.Clock neutralClock;

        private ClockWrapper(io.helidon.metrics.api.Clock neutralClock) {
            this.neutralClock = neutralClock;
        }

        static ClockWrapper create(io.helidon.metrics.api.Clock clock) {
            return new ClockWrapper(clock);
        }

        public long wallTime() {
            return this.neutralClock.wallTime();
        }

        public long monotonicTime() {
            return this.neutralClock.monotonicTime();
        }
    }
}

