/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.LazyValue;
import io.helidon.common.config.Config;
import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.DistributionStatisticsConfig;
import io.helidon.metrics.api.DistributionSummary;
import io.helidon.metrics.api.FunctionalCounter;
import io.helidon.metrics.api.Gauge;
import io.helidon.metrics.api.HistogramSnapshot;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MetricsConfig;
import io.helidon.metrics.api.MetricsFactory;
import io.helidon.metrics.api.Tag;
import io.helidon.metrics.api.Timer;
import io.helidon.metrics.providers.micrometer.MCounter;
import io.helidon.metrics.providers.micrometer.MDistributionStatisticsConfig;
import io.helidon.metrics.providers.micrometer.MDistributionSummary;
import io.helidon.metrics.providers.micrometer.MFunctionalCounter;
import io.helidon.metrics.providers.micrometer.MGauge;
import io.helidon.metrics.providers.micrometer.MHistogramSnapshot;
import io.helidon.metrics.providers.micrometer.MMeterRegistry;
import io.helidon.metrics.providers.micrometer.MTag;
import io.helidon.metrics.providers.micrometer.MTimer;
import io.helidon.metrics.spi.MeterRegistryLifeCycleListener;
import io.helidon.metrics.spi.MetersProvider;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.util.Collection;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;

class MicrometerMetricsFactory
implements MetricsFactory {
    private final MetricsConfig metricsConfig;
    private final Collection<MetersProvider> metersProviders;
    private final Collection<MMeterRegistry> meterRegistries = new ConcurrentLinkedQueue<MMeterRegistry>();
    private final ReentrantLock lock = new ReentrantLock();
    private final LazyValue<Collection<MeterRegistryLifeCycleListener>> meterRegistryLifeCycleListeners = LazyValue.create(() -> HelidonServiceLoader.create(ServiceLoader.load(MeterRegistryLifeCycleListener.class)).asList());
    private MMeterRegistry globalMeterRegistry;

    private MicrometerMetricsFactory(MetricsConfig metricsConfig, Collection<MetersProvider> metersProviders) {
        this.metricsConfig = metricsConfig;
        this.metersProviders = metersProviders;
    }

    static MicrometerMetricsFactory create(Config rootConfig, MetricsConfig metricsConfig, Collection<MetersProvider> metersProviders) {
        return new MicrometerMetricsFactory(metricsConfig, metersProviders);
    }

    void onMeterAdded(Meter meter) {
        this.meterRegistries.forEach(mr -> mr.onMeterAdded(meter));
    }

    void onMeterRemoved(Meter meter) {
        this.meterRegistries.forEach(mr -> mr.onMeterRemoved(meter));
    }

    public io.helidon.metrics.api.MeterRegistry globalRegistry(Consumer<io.helidon.metrics.api.Meter> onAddListener, Consumer<io.helidon.metrics.api.Meter> onRemoveListener, boolean backfill) {
        this.globalMeterRegistry.onMeterAdded(onAddListener);
        this.globalMeterRegistry.onMeterRemoved(onRemoveListener);
        if (backfill) {
            this.globalMeterRegistry.meters().forEach(onAddListener);
        }
        return this.globalMeterRegistry;
    }

    public MMeterRegistry.Builder meterRegistryBuilder() {
        return MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this);
    }

    public io.helidon.metrics.api.MeterRegistry createMeterRegistry(MetricsConfig metricsConfig) {
        return this.save((MMeterRegistry)MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this).metricsConfig(metricsConfig).build());
    }

    public io.helidon.metrics.api.MeterRegistry createMeterRegistry(MetricsConfig metricsConfig, Consumer<io.helidon.metrics.api.Meter> onAddListener, Consumer<io.helidon.metrics.api.Meter> onRemoveListener) {
        return this.save((MMeterRegistry)MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this).metricsConfig(metricsConfig).onMeterAdded((Consumer)onAddListener).onMeterRemoved((Consumer)onRemoveListener).build());
    }

    public io.helidon.metrics.api.MeterRegistry createMeterRegistry(io.helidon.metrics.api.Clock clock, MetricsConfig metricsConfig, Consumer<io.helidon.metrics.api.Meter> onAddListener, Consumer<io.helidon.metrics.api.Meter> onRemoveListener) {
        return this.save((MMeterRegistry)MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this).metricsConfig(metricsConfig).clock(clock).onMeterAdded((Consumer)onAddListener).onMeterRemoved((Consumer)onRemoveListener).build());
    }

    public io.helidon.metrics.api.MeterRegistry createMeterRegistry(io.helidon.metrics.api.Clock clock, MetricsConfig metricsConfig) {
        return this.save((MMeterRegistry)MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this).clock(clock).metricsConfig(metricsConfig).build());
    }

    public io.helidon.metrics.api.MeterRegistry globalRegistry() {
        return this.globalMeterRegistry != null ? this.globalMeterRegistry : this.globalRegistry(MetricsConfig.create());
    }

    public io.helidon.metrics.api.MeterRegistry globalRegistry(MetricsConfig metricsConfig) {
        this.lock.lock();
        try {
            if (this.globalMeterRegistry != null) {
                this.globalMeterRegistry.close();
                this.meterRegistries.remove(this.globalMeterRegistry);
            }
            MicrometerMetricsFactory.ensurePrometheusRegistry(Metrics.globalRegistry, metricsConfig);
            this.globalMeterRegistry = this.save((MMeterRegistry)MMeterRegistry.builder((MeterRegistry)Metrics.globalRegistry, this).metricsConfig(metricsConfig).build());
            this.notifyListenersOfCreate(this.globalMeterRegistry, metricsConfig);
            this.applyMetersProvidersToRegistry(this, this.globalMeterRegistry, this.metersProviders);
            MMeterRegistry mMeterRegistry = this.globalMeterRegistry;
            return mMeterRegistry;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() {
        List<MMeterRegistry> registries = List.copyOf(this.meterRegistries);
        registries.forEach(MMeterRegistry::close);
        this.meterRegistries.clear();
        this.globalMeterRegistry = null;
    }

    public MetricsConfig metricsConfig() {
        return this.metricsConfig;
    }

    public io.helidon.metrics.api.Clock clockSystem() {
        return new io.helidon.metrics.api.Clock(this){
            private final Clock delegate = Clock.SYSTEM;

            public long wallTime() {
                return this.delegate.wallTime();
            }

            public long monotonicTime() {
                return this.delegate.monotonicTime();
            }

            public <R> R unwrap(Class<? extends R> c) {
                return c.cast(this.delegate);
            }
        };
    }

    public Counter.Builder counterBuilder(String name) {
        return MCounter.builder(name);
    }

    public <T> FunctionalCounter.Builder<T> functionalCounterBuilder(String name, T stateObject, Function<T, Long> fn) {
        return MFunctionalCounter.builder(name, stateObject, fn);
    }

    public DistributionStatisticsConfig.Builder distributionStatisticsConfigBuilder() {
        return MDistributionStatisticsConfig.builder();
    }

    public DistributionSummary.Builder distributionSummaryBuilder(String name, DistributionStatisticsConfig.Builder configBuilder) {
        return MDistributionSummary.builder(name, configBuilder);
    }

    public <N extends Number> Gauge.Builder<N> gaugeBuilder(String name, Supplier<N> supplier) {
        return MGauge.builder(name, supplier);
    }

    public <T> Gauge.Builder<Double> gaugeBuilder(String name, T stateObject, ToDoubleFunction<T> fn) {
        return MGauge.builder(name, stateObject, fn);
    }

    public Timer.Builder timerBuilder(String name) {
        return MTimer.builder(name);
    }

    public Timer.Sample timerStart() {
        return MTimer.start();
    }

    public Timer.Sample timerStart(io.helidon.metrics.api.MeterRegistry registry) {
        return MTimer.start(registry);
    }

    public Timer.Sample timerStart(io.helidon.metrics.api.Clock clock) {
        return MTimer.start(clock);
    }

    public Tag tagCreate(String key, String value) {
        return MTag.of(key, value);
    }

    public HistogramSnapshot histogramSnapshotEmpty(long count, double total, double max) {
        return MHistogramSnapshot.create(io.micrometer.core.instrument.distribution.HistogramSnapshot.empty((long)count, (double)total, (double)max));
    }

    private static void ensurePrometheusRegistry(CompositeMeterRegistry compositeMeterRegistry, MetricsConfig metricsConfig) {
        if (compositeMeterRegistry.getRegistries().stream().noneMatch(mr -> mr instanceof PrometheusMeterRegistry)) {
            compositeMeterRegistry.add((MeterRegistry)new PrometheusMeterRegistry(key -> metricsConfig.lookupConfig(key).orElse(null)));
        }
    }

    private void notifyListenersOfCreate(io.helidon.metrics.api.MeterRegistry meterRegistry, MetricsConfig metricsConfig) {
        ((Collection)this.meterRegistryLifeCycleListeners.get()).forEach(listener -> listener.onCreate(meterRegistry, metricsConfig));
    }

    private <B extends Meter.Builder<B, M>, M extends io.helidon.metrics.api.Meter> io.helidon.metrics.api.MeterRegistry applyMetersProvidersToRegistry(MetricsFactory factory, io.helidon.metrics.api.MeterRegistry registry, Collection<MetersProvider> metersProviders) {
        metersProviders.stream().flatMap(mp -> mp.meterBuilders(factory).stream()).forEach(b -> registry.getOrCreate(b));
        return registry;
    }

    private MMeterRegistry save(MMeterRegistry meterRegistry) {
        this.meterRegistries.add(meterRegistry);
        return meterRegistry;
    }
}

