/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.common.HelidonFeatures;
import io.helidon.common.HelidonFlavor;
import io.helidon.common.LogConfig;
import io.helidon.common.SerializationConfig;
import io.helidon.common.context.Context;
import io.helidon.common.context.Contexts;
import io.helidon.config.Config;
import io.helidon.config.mp.MpConfig;
import io.helidon.config.mp.MpConfigProviderResolver;
import io.helidon.microprofile.cdi.BuildTimeEnd;
import io.helidon.microprofile.cdi.BuildTimeStart;
import io.helidon.microprofile.cdi.ContainerInstanceHolder;
import io.helidon.microprofile.cdi.HelidonCdiProvider;
import io.helidon.microprofile.cdi.HelidonContainer;
import io.helidon.microprofile.cdi.HelidonProxyServices;
import io.helidon.microprofile.cdi.RuntimeStart;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.inject.se.SeContainer;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.enterprise.inject.spi.CDIProvider;
import jakarta.enterprise.inject.spi.Extension;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.weld.AbstractCDI;
import org.jboss.weld.bean.builtin.BeanManagerProxy;
import org.jboss.weld.bootstrap.WeldBootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Environments;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.configuration.spi.ExternalConfiguration;
import org.jboss.weld.configuration.spi.helpers.ExternalConfigurationBuilder;
import org.jboss.weld.environment.deployment.WeldDeployment;
import org.jboss.weld.environment.deployment.WeldResourceLoader;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.environment.se.events.ContainerBeforeShutdown;
import org.jboss.weld.environment.se.events.ContainerInitialized;
import org.jboss.weld.environment.se.events.ContainerShutdown;
import org.jboss.weld.environment.se.logging.WeldSELogger;
import org.jboss.weld.executor.ExecutorServicesFactory;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jboss.weld.serialization.spi.ProxyServices;

final class HelidonContainerImpl
extends Weld
implements HelidonContainer {
    private static final Logger LOGGER = Logger.getLogger(HelidonContainerImpl.class.getName());
    private static final AtomicBoolean IN_RUNTIME = new AtomicBoolean();
    private static final String EXIT_ON_STARTED_KEY = "exit.on.started";
    private static final boolean EXIT_ON_STARTED = "!".equals(System.getProperty("exit.on.started"));
    private static final Context ROOT_CONTEXT;
    private final WeldBootstrap bootstrap = new WeldBootstrap();
    private final String id = UUID.randomUUID().toString();
    private HelidonCdi cdi;

    HelidonContainerImpl() {
    }

    static HelidonContainerImpl create() {
        HelidonContainerImpl container = new HelidonContainerImpl();
        container.initInContext();
        return container;
    }

    void initInContext() {
        long time = System.nanoTime();
        Contexts.runInContext((Context)ROOT_CONTEXT, this::init);
        time = System.nanoTime() - time;
        long t = TimeUnit.MILLISECONDS.convert(time, TimeUnit.NANOSECONDS);
        LOGGER.fine("Container initialized in " + t + " millis");
    }

    private HelidonContainerImpl init() {
        LOGGER.fine(() -> "Initializing CDI container " + this.id);
        this.addHelidonBeanDefiningAnnotations("jakarta.ws.rs.Path", "jakarta.ws.rs.ext.Provider", "jakarta.websocket.server.ServerEndpoint", "org.eclipse.microprofile.graphql.GraphQLApi", "org.eclipse.microprofile.graphql.Input", "org.eclipse.microprofile.graphql.Interface", "org.eclipse.microprofile.graphql.Type");
        WeldResourceLoader resourceLoader = new WeldResourceLoader(){

            public Collection<URL> getResources(String name) {
                Collection resources = super.getResources(name);
                return new HashSet<URL>(resources);
            }
        };
        this.setResourceLoader((ResourceLoader)resourceLoader);
        org.eclipse.microprofile.config.Config mpConfig = ConfigProvider.getConfig();
        Config config = MpConfig.toHelidonConfig((org.eclipse.microprofile.config.Config)mpConfig);
        Map properties = (Map)config.get("cdi").detach().asMap().orElseGet(Map::of);
        this.setProperties(new HashMap(properties));
        ServiceLoader.load(Extension.class).findFirst().ifPresent(it -> this.addExtension(new Extension(){}));
        Deployment deployment = this.createDeployment((ResourceLoader)resourceLoader, (CDI11Bootstrap)this.bootstrap);
        deployment.getServices().add(ProxyServices.class, (Service)new HelidonProxyServices());
        ExternalConfigurationBuilder configurationBuilder = new ExternalConfigurationBuilder().add(ConfigurationKey.EXECUTOR_THREAD_POOL_TYPE.get(), (Object)ExecutorServicesFactory.ThreadPoolType.COMMON.toString()).add(ConfigurationKey.RELAXED_CONSTRUCTION.get(), (Object)true).add(ConfigurationKey.ALLOW_OPTIMIZED_CLEANUP.get(), (Object)this.isEnabled("org.jboss.weld.bootstrap.allowOptimizedCleanup", true));
        for (Map.Entry property : properties.entrySet()) {
            String key = (String)property.getKey();
            if ("org.jboss.weld.se.shutdownHook".equals(key) || "org.jboss.weld.se.archive.isolation".equals(key) || "org.jboss.weld.development".equals(key) || "org.jboss.weld.se.scan.classpath.entries".equals(key) || "jakarta.enterprise.inject.scan.implicit".equals(key)) continue;
            configurationBuilder.add(key, property.getValue());
        }
        deployment.getServices().add(ExternalConfiguration.class, (Service)configurationBuilder.build());
        this.bootstrap.startContainer(this.id, (Environment)Environments.SE, deployment);
        this.bootstrap.startInitialization();
        Collection archives = deployment.getBeanDeploymentArchives();
        if (archives.isEmpty()) {
            throw new IllegalStateException("No deployment archive");
        }
        BeanManagerImpl beanManager = this.bootstrap.getManager((BeanDeploymentArchive)archives.iterator().next());
        beanManager.getEvent().select(new Annotation[]{BuildTimeStart.Literal.INSTANCE}).fire((Object)this.id);
        this.bootstrap.deployBeans();
        this.cdi = new HelidonCdi(this.id, this.bootstrap, deployment);
        HelidonCdiProvider.setCdi((CDI<Object>)this.cdi);
        beanManager.getEvent().select(new Annotation[]{BuildTimeEnd.Literal.INSTANCE}).fire((Object)this.id);
        return this;
    }

    private void addHelidonBeanDefiningAnnotations(String ... classNames) {
        for (String className : classNames) {
            try {
                Class<?> clazz = Class.forName(className);
                this.addBeanDefiningAnnotations(new Class[]{clazz});
            }
            catch (Throwable e) {
                LOGGER.log(Level.FINEST, e, () -> className + " is not in the classpath, it will be ignored by CDI");
            }
        }
    }

    @Override
    public SeContainer start() {
        if (IN_RUNTIME.get()) {
            return this.cdi;
        }
        SerializationConfig.configureRuntime();
        LogConfig.configureRuntime();
        try {
            Contexts.runInContext((Context)ROOT_CONTEXT, this::doStart);
        }
        catch (Exception e) {
            try {
                this.shutdown();
            }
            catch (Exception exception) {
                e.addSuppressed(exception);
            }
            throw e;
        }
        if (EXIT_ON_STARTED) {
            this.exitOnStarted();
        }
        return this.cdi;
    }

    @Override
    public Context context() {
        return ROOT_CONTEXT;
    }

    @Override
    public void shutdown() {
        this.cdi.close();
    }

    private HelidonContainerImpl doStart() {
        long now = System.currentTimeMillis();
        IN_RUNTIME.set(true);
        BeanManager bm = null;
        try {
            bm = CDI.current().getBeanManager();
        }
        catch (IllegalStateException e) {
            LOGGER.log(Level.FINEST, "Cannot get current CDI, probably restarted", e);
            this.initInContext();
            bm = CDI.current().getBeanManager();
        }
        org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
        MpConfigProviderResolver.runtimeStart((org.eclipse.microprofile.config.Config)config);
        bm.getEvent().select(new Annotation[]{RuntimeStart.Literal.INSTANCE}).fire((Object)config);
        this.bootstrap.validateBeans();
        this.bootstrap.endInitialization();
        final Thread shutdownHook = new Thread(() -> this.cdi.close(), "helidon-cdi-shutdown-hook");
        Logger rootLogger = LogManager.getLogManager().getLogger("");
        Handler[] handlers = rootLogger.getHandlers();
        Handler[] newHandlers = new Handler[handlers.length + 1];
        newHandlers[0] = new Handler(){

            @Override
            public void publish(LogRecord record) {
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() throws SecurityException {
                try {
                    shutdownHook.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        System.arraycopy(handlers, 0, newHandlers, 1, handlers.length);
        for (Handler handler : handlers) {
            rootLogger.removeHandler(handler);
        }
        for (Handler newHandler : newHandlers) {
            rootLogger.addHandler(newHandler);
        }
        bm.getEvent().select(new Annotation[]{Initialized.Literal.APPLICATION}).fire((Object)new ContainerInitialized(this.id));
        now = System.currentTimeMillis() - now;
        LOGGER.fine("Container started in " + now + " millis (this excludes the initialization time)");
        HelidonFeatures.print((HelidonFlavor)HelidonFlavor.MP, (String)"3.2.0", (boolean)config.getOptionalValue("features.print-details", Boolean.class).orElse(false));
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        return this;
    }

    private void exitOnStarted() {
        LOGGER.info(String.format("Exiting, -D%s set.", EXIT_ON_STARTED_KEY));
        System.exit(0);
    }

    public static boolean isRuntime() {
        return IN_RUNTIME.get();
    }

    static {
        HelidonFeatures.flavor((HelidonFlavor)HelidonFlavor.MP);
        Context.Builder contextBuilder = Context.builder().id("helidon-cdi");
        Contexts.context().ifPresent(arg_0 -> ((Context.Builder)contextBuilder).parent(arg_0));
        ROOT_CONTEXT = contextBuilder.build();
        CDI.setCDIProvider((CDIProvider)new HelidonCdiProvider());
    }

    private static final class HelidonCdi
    extends AbstractCDI<Object>
    implements SeContainer {
        private final AtomicBoolean isRunning = new AtomicBoolean(true);
        private final String id;
        private final WeldBootstrap bootstrap;
        private final Deployment deployment;

        private HelidonCdi(String id, WeldBootstrap bootstrap, Deployment deployment) {
            this.id = id;
            this.bootstrap = bootstrap;
            this.deployment = deployment;
        }

        public void close() {
            if (this.isRunning.compareAndSet(true, false)) {
                try {
                    this.beanManager().getEvent().select(new Annotation[]{BeforeDestroyed.Literal.APPLICATION}).fire((Object)new ContainerBeforeShutdown(this.id));
                }
                catch (Throwable throwable) {
                    try {
                        this.beanManager().getEvent().select(new Annotation[]{Destroyed.Literal.APPLICATION}).fire((Object)new ContainerShutdown(this.id));
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, e, () -> "Failed to fire ApplicationScoped Destroyed event");
                    }
                    this.bootstrap.shutdown();
                    WeldSELogger.LOG.weldContainerShutdown((Object)this.id);
                    throw throwable;
                }
                try {
                    this.beanManager().getEvent().select(new Annotation[]{Destroyed.Literal.APPLICATION}).fire((Object)new ContainerShutdown(this.id));
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e, () -> "Failed to fire ApplicationScoped Destroyed event");
                }
                this.bootstrap.shutdown();
                WeldSELogger.LOG.weldContainerShutdown((Object)this.id);
            }
            IN_RUNTIME.set(false);
            ContainerInstanceHolder.reset();
        }

        public boolean isRunning() {
            return this.isRunning.get();
        }

        public BeanManager getBeanManager() {
            if (!this.isRunning.get()) {
                LOGGER.warning("BeanManager requested during container shutdown. This may be caused by observer methods that use CDI.current(). Switch to finest logging to see stack trace.");
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.log(Level.FINEST, "Invocation of container method during shutdown", new IllegalStateException("Container not running"));
                }
            }
            return new BeanManagerProxy(this.beanManager());
        }

        private BeanManagerImpl beanManager() {
            return BeanManagerProxy.unwrap((BeanManager)this.bootstrap.getManager(this.getArchive(this.deployment)));
        }

        private BeanDeploymentArchive getArchive(Deployment deployment) {
            Collection beanDeploymentArchives = deployment.getBeanDeploymentArchives();
            if (beanDeploymentArchives.size() == 1) {
                return (BeanDeploymentArchive)beanDeploymentArchives.iterator().next();
            }
            for (BeanDeploymentArchive beanDeploymentArchive : beanDeploymentArchives) {
                if (!WeldDeployment.SYNTHETIC_BDA_ID.equals(beanDeploymentArchive.getId())) continue;
                return beanDeploymentArchive;
            }
            for (BeanDeploymentArchive beanDeploymentArchive : beanDeploymentArchives) {
                if (WeldDeployment.ADDITIONAL_BDA_ID.equals(beanDeploymentArchive.getId())) continue;
                return beanDeploymentArchive;
            }
            return deployment.loadBeanDeploymentArchive(WeldContainer.class);
        }
    }
}

