/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.common.LazyValue;
import io.helidon.microprofile.cdi.ExecuteOn;
import io.helidon.microprofile.cdi.ExecuteOnInterceptor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.literal.NamedLiteral;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.DeploymentException;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ExecuteOnExtension
implements Extension {
    private final LazyValue<Map<Method, AnnotatedMethod<?>>> methodMap = LazyValue.create(ConcurrentHashMap::new);
    private final LazyValue<Map<Method, MethodType>> methodType = LazyValue.create(ConcurrentHashMap::new);

    void registerMethods(BeanManager bm, @Observes ProcessSyntheticBean<?> event) {
        this.registerMethods(bm.createAnnotatedType(event.getBean().getBeanClass()));
    }

    void registerMethods(@Observes ProcessManagedBean<?> event) {
        this.registerMethods(event.getAnnotatedBeanClass());
    }

    private void registerMethods(AnnotatedType<?> type) {
        for (AnnotatedMethod annotatedMethod : type.getMethods()) {
            if (!annotatedMethod.isAnnotationPresent(ExecuteOn.class)) continue;
            Method method = annotatedMethod.getJavaMember();
            ((Map)this.methodMap.get()).put(method, annotatedMethod);
            ((Map)this.methodType.get()).put(method, ExecuteOnExtension.findMethodType(method));
        }
    }

    void validateAnnotations(BeanManager bm, @Observes @Initialized(value=ApplicationScoped.class) Object event) {
        ((Map)this.methodMap.get()).forEach((method, annotatedMethod) -> ExecuteOnExtension.validateExecutor(bm, annotatedMethod));
    }

    private static MethodType findMethodType(Method method) {
        Class<?> returnType = method.getReturnType();
        if (CompletionStage.class.isAssignableFrom(returnType) || CompletableFuture.class.isAssignableFrom(returnType)) {
            return MethodType.NON_BLOCKING;
        }
        if (Future.class.equals(returnType)) {
            throw new DeploymentException("Future is not supported as return type of ExecuteOn method");
        }
        return MethodType.BLOCKING;
    }

    private static void validateExecutor(BeanManager bm, AnnotatedMethod<?> method) {
        ExecuteOn executeOn = (ExecuteOn)method.getAnnotation(ExecuteOn.class);
        if (executeOn.value() == ExecuteOn.ThreadType.EXECUTOR) {
            String executorName = executeOn.executorName();
            Set beans = bm.getBeans(ExecutorService.class, new Annotation[]{NamedLiteral.of((String)executorName)});
            if (beans.isEmpty()) {
                throw new IllegalArgumentException("Unable to resolve named executor service '" + String.valueOf((Object)executeOn.value()) + "' at " + method.getJavaMember().getDeclaringClass().getName() + "::" + method.getJavaMember().getName());
            }
        }
    }

    ExecuteOn getAnnotation(Method method) {
        AnnotatedMethod annotatedMethod = (AnnotatedMethod)((Map)this.methodMap.get()).get(method);
        if (annotatedMethod != null) {
            return (ExecuteOn)annotatedMethod.getAnnotation(ExecuteOn.class);
        }
        throw new IllegalArgumentException("Unable to map method " + String.valueOf(method));
    }

    MethodType getMethodType(Method method) {
        return (MethodType)((Object)((Map)this.methodType.get()).get(method));
    }

    void registerInterceptors(@Observes BeforeBeanDiscovery discovery, BeanManager bm) {
        discovery.addAnnotatedType(bm.createAnnotatedType(ExecuteOnInterceptor.class), ExecuteOnInterceptor.class.getName());
    }

    void clearMethodMap() {
        ((Map)this.methodMap.get()).clear();
        ((Map)this.methodType.get()).clear();
    }

    static enum MethodType {
        BLOCKING,
        NON_BLOCKING;

    }
}

