/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.cdi;

import io.helidon.Main;
import io.helidon.common.Weights;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ResolvedType;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.metadata.reflection.AnnotationFactory;
import io.helidon.metadata.reflection.TypeFactory;
import io.helidon.service.registry.DependencyContext;
import io.helidon.service.registry.GlobalServiceRegistry;
import io.helidon.service.registry.InterceptionMetadata;
import io.helidon.service.registry.Lookup;
import io.helidon.service.registry.Qualifier;
import io.helidon.service.registry.Service;
import io.helidon.service.registry.ServiceDescriptor;
import io.helidon.service.registry.ServiceInfo;
import io.helidon.service.registry.ServiceInstance;
import io.helidon.service.registry.ServiceRegistry;
import io.helidon.service.registry.ServiceRegistryException;
import io.helidon.service.registry.ServiceRegistryManager;
import io.helidon.service.registry.Services;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.NormalScope;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Annotated;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedField;
import jakarta.enterprise.inject.spi.AnnotatedMember;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.InterceptionFactory;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.ProcessManagedBean;
import jakarta.enterprise.inject.spi.ProcessProducer;
import jakarta.enterprise.inject.spi.ProcessSyntheticBean;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedFieldConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedMethodConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import jakarta.inject.Named;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jboss.weld.literal.NamedLiteral;

public class ServiceRegistryExtension
implements Extension {
    private static final TypeName CDI_NAMED_TYPE = TypeName.create(Named.class);
    private static final System.Logger LOGGER = System.getLogger(ServiceRegistryExtension.class.getName());
    private static final int SYNTHETIC_BEAN_PRIORITY = 0;
    private static final double WEIGHT = 110.0;
    private final Set<CdiServiceId> processedBeans = new HashSet<CdiServiceId>();

    @Deprecated
    public ServiceRegistryExtension() {
    }

    void registerTypes(@Observes @Priority(value=4000) BeforeBeanDiscovery bbd) {
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        List allServices = registry.lookupServices(Lookup.EMPTY);
        HashSet<TypeName> addedQualifiers = new HashSet<TypeName>();
        for (ServiceInfo service : allServices) {
            for (Qualifier qualifier : service.qualifiers()) {
                TypeName typeName = qualifier.typeName();
                if (!addedQualifiers.add(typeName)) continue;
                bbd.addQualifier(TypeFactory.toClass((TypeName)typeName));
            }
        }
    }

    void processManagedBean(@Observes @Priority(value=4000) ProcessManagedBean<?> pb, BeanManager bm) {
        this.doProcessBean(bm, (ProcessBean<?>)pb);
    }

    void processSyntheticBean(@Observes @Priority(value=4000) ProcessSyntheticBean<?> pb, BeanManager bm) {
        if (pb.getSource() == this) {
            return;
        }
        this.doProcessBean(bm, (ProcessBean<?>)pb);
    }

    void processProducer(@Observes @Priority(value=4000) ProcessProducer pb, BeanManager bm) {
        AnnotatedMember member = pb.getAnnotatedMember();
        Set typeClosure = member.getTypeClosure();
        Set annotations = member.getAnnotations();
        Set<Qualifier> qualifiers = ServiceRegistryExtension.findRegistryQualifiers(annotations);
        TypeName beanType = TypeName.create((Type)member.getDeclaringType().getJavaClass());
        for (Type type : typeClosure) {
            this.addCdiProducer(bm, new CdiProducer(beanType, type, annotations, qualifiers));
        }
    }

    void registryToCdi(@Observes @Priority(value=6000) AfterBeanDiscovery abd, BeanManager bm) {
        ServiceRegistry registry = GlobalServiceRegistry.registry();
        List allServices = registry.lookupServices(Lookup.EMPTY);
        HashSet<UniqueBean> processedTypes = new HashSet<UniqueBean>();
        for (ServiceInfo service : allServices) {
            if (service instanceof CdiBeanDescriptor || service instanceof CdiProducerDescriptor) continue;
            this.addServiceInfo(abd, bm, registry, processedTypes, service);
        }
        abd.addBean().id("helidon-service-registry").scope(ApplicationScoped.class).beanClass(ServiceRegistry.class).addType(ServiceRegistry.class).createWith(context -> GlobalServiceRegistry.registry());
    }

    void resetRegistry(@Observes @Destroyed(value=ApplicationScoped.class) Object event) {
        ServiceRegistryManager manager = ServiceRegistryManager.create();
        GlobalServiceRegistry.registry(() -> ((ServiceRegistryManager)manager).registry());
        Main.addShutdownHandler(() -> ((ServiceRegistryManager)manager).shutdown());
    }

    private static Annotation mapNamed(Annotation annotation) {
        if (annotation.typeName().equals((Object)CDI_NAMED_TYPE)) {
            return ((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(Service.Named.TYPE)).update(it -> annotation.value().ifPresent(arg_0 -> ((Annotation.Builder)it).value(arg_0)))).build();
        }
        return annotation;
    }

    private static Set<Qualifier> findRegistryQualifiers(Set<java.lang.annotation.Annotation> annotations) {
        return Stream.concat(annotations.stream().filter(it -> it.annotationType().isAnnotationPresent(Service.Qualifier.class)).map(AnnotationFactory::create).map(Qualifier::create), annotations.stream().filter(it -> it.annotationType().equals(Named.class)).map(AnnotationFactory::create).map(ServiceRegistryExtension::mapNamed).map(Qualifier::create)).collect(Collectors.toUnmodifiableSet());
    }

    private void addNamedBean(BeanManager bm, AfterBeanDiscovery abd, AnnotatedType<?> annotatedType, TypeName serviceType, Class<?> beanClass, Set<Type> typeClosure, Class<? extends java.lang.annotation.Annotation> cdiScope, String name, Supplier<Object> instanceSupplier) {
        if (typeClosure.isEmpty()) {
            return;
        }
        BeanConfigurator<Object> configurator = this.addBean(abd, serviceType, beanClass, typeClosure, cdiScope, "-" + name);
        this.beanCreateWith(bm, annotatedType, beanClass, configurator, instanceSupplier);
        configurator.addQualifier((java.lang.annotation.Annotation)new NamedLiteral(name));
    }

    private BeanConfigurator<Object> addBean(AfterBeanDiscovery abd, TypeName serviceType, Class<?> beanClass, Set<Type> typeClosure, Class<? extends java.lang.annotation.Annotation> cdiScope, String idSuffix) {
        return abd.addBean().beanClass(beanClass).types(typeClosure).id("service-registry-" + serviceType.fqName() + idSuffix).alternative(true).priority(0).scope(cdiScope);
    }

    private void beanCreateWith(BeanManager bm, AnnotatedType<?> annotatedType, Class<?> beanClass, BeanConfigurator<Object> configurator, Supplier<Object> instance) {
        configurator.createWith(ctx -> this.interceptInstance(bm, beanClass, annotatedType, (CreationalContext)ctx, instance.get()));
    }

    private Object interceptInstance(BeanManager bm, Class<?> beanClass, AnnotatedType<?> annotatedType, CreationalContext ctx, Object instance) {
        InterceptionFactory factory = bm.createInterceptionFactory(ctx, beanClass);
        if (annotatedType != null) {
            this.updateFromAnnotatedType(annotatedType, factory.configure());
        }
        return factory.createInterceptedInstance(instance);
    }

    private Set<Type> toTypes(Set<ResolvedType> usedContracts) {
        return usedContracts.stream().map(ResolvedType::type).map(TypeFactory::toType).collect(Collectors.toUnmodifiableSet());
    }

    private void updateFromAnnotatedType(AnnotatedType<?> type, AnnotatedTypeConfigurator builder) {
        Optional<Object> found;
        Predicate<AnnotatedMethod> p;
        AnnotatedType beforeChanges = builder.getAnnotated();
        this.fixAnnotations((Annotated)type, (Annotated)beforeChanges, arg_0 -> ((AnnotatedTypeConfigurator)builder).add(arg_0));
        for (AnnotatedMethod method : type.getMethods()) {
            p = it -> it.getJavaMember().equals(method.getJavaMember());
            found = builder.filterMethods(p).findFirst();
            found.ifPresent(it -> this.fixAnnotations((Annotated)method, (Annotated)it.getAnnotated(), arg_0 -> ((AnnotatedMethodConfigurator)it).add(arg_0)));
        }
        for (AnnotatedField field : type.getFields()) {
            p = it -> it.getJavaMember().equals(field.getJavaMember());
            found = builder.filterFields(p).findFirst();
            found.ifPresent(it -> this.fixAnnotations((Annotated)field, (Annotated)it.getAnnotated(), arg_0 -> ((AnnotatedFieldConfigurator)it).add(arg_0)));
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            p = it -> it.getJavaMember().equals(constructor.getJavaMember());
            found = builder.filterConstructors(p).findFirst();
            found.ifPresent(it -> this.fixAnnotations((Annotated)constructor, (Annotated)it.getAnnotated(), arg_0 -> ((AnnotatedConstructorConfigurator)it).add(arg_0)));
        }
    }

    private void fixAnnotations(Annotated desiredAnnotated, Annotated targetAnnotated, Consumer<java.lang.annotation.Annotation> configurator) {
        Set targetAnnotations = targetAnnotated.getAnnotations();
        for (java.lang.annotation.Annotation annotation : desiredAnnotated.getAnnotations()) {
            if (targetAnnotations.contains(annotation)) continue;
            configurator.accept(annotation);
        }
    }

    private void addCdiProducer(BeanManager bm, CdiProducer cdiProducer) {
        Type type = cdiProducer.contract();
        if (this.invalidContract(ResolvedType.create((Type)type))) {
            return;
        }
        Class<Dependent> scope = this.findCdiScope(bm, cdiProducer.annotations()).orElse(Dependent.class);
        Optional<TypeName> registryScope = this.toRegistryScope(scope);
        if (registryScope.isEmpty()) {
            return;
        }
        TypeName actualScope = registryScope.get();
        java.lang.annotation.Annotation[] cdiQualifiers = this.findCdiQualifiers(bm, cdiProducer.annotations());
        try {
            Services.add((ServiceDescriptor)new CdiProducerDescriptor(bm, actualScope, cdiProducer, cdiQualifiers));
        }
        catch (ServiceRegistryException e) {
            LOGGER.log(System.Logger.Level.TRACE, "Failed to register CDI producer for contract: " + cdiProducer.contract().getTypeName() + ", producer: " + cdiProducer.beanType().fqName(), (Throwable)e);
        }
    }

    private void addCdiBean(BeanManager bm, CdiBean cdiBean) {
        Bean<?> bean = cdiBean.bean();
        Class scope = bean.getScope();
        Optional<TypeName> registryScope = this.toRegistryScope(scope);
        if (registryScope.isEmpty()) {
            return;
        }
        TypeName actualScope = registryScope.get();
        for (Type type : bean.getTypes()) {
            if (this.invalidContract(ResolvedType.create((Type)type))) continue;
            try {
                Services.add((ServiceDescriptor)new CdiBeanDescriptor(bm, cdiBean, type, actualScope));
            }
            catch (ServiceRegistryException e) {
                LOGGER.log(System.Logger.Level.TRACE, "Failed to register CDI bean for contract: " + String.valueOf(type) + ", bean: " + String.valueOf(bean), (Throwable)e);
            }
        }
    }

    private java.lang.annotation.Annotation[] findCdiQualifiers(BeanManager bm, Set<java.lang.annotation.Annotation> annotations) {
        return (java.lang.annotation.Annotation[])annotations.stream().filter(it -> bm.isQualifier(it.annotationType())).toArray(java.lang.annotation.Annotation[]::new);
    }

    private Optional<Class<? extends java.lang.annotation.Annotation>> findCdiScope(BeanManager bm, Set<java.lang.annotation.Annotation> annotations) {
        for (java.lang.annotation.Annotation annotation : annotations) {
            Optional<java.lang.annotation.Annotation> metaAnnotated;
            if (bm.isNormalScope(annotation.annotationType()) && (metaAnnotated = this.findMetaAnnotated(annotation, NormalScope.class, new HashSet<Class<? extends java.lang.annotation.Annotation>>())).isPresent()) {
                return metaAnnotated.map(java.lang.annotation.Annotation::annotationType);
            }
            if (!bm.isScope(annotation.annotationType()) || !(metaAnnotated = this.findMetaAnnotated(annotation, Scope.class, new HashSet<Class<? extends java.lang.annotation.Annotation>>())).isPresent()) continue;
            return metaAnnotated.map(java.lang.annotation.Annotation::annotationType);
        }
        return Optional.empty();
    }

    private Optional<java.lang.annotation.Annotation> findMetaAnnotated(java.lang.annotation.Annotation annotation, Class<? extends java.lang.annotation.Annotation> annotationType, Set<Class<? extends java.lang.annotation.Annotation>> processed) {
        java.lang.annotation.Annotation[] declaredAnnotations;
        Class<? extends java.lang.annotation.Annotation> aClass = annotation.annotationType();
        if (aClass.getDeclaredAnnotation(annotationType) != null) {
            return Optional.of(annotation);
        }
        if (!processed.add(aClass)) {
            return Optional.empty();
        }
        for (java.lang.annotation.Annotation declaredAnnotation : declaredAnnotations = aClass.getDeclaredAnnotations()) {
            Optional<java.lang.annotation.Annotation> found = this.findMetaAnnotated(declaredAnnotation, annotationType, processed);
            if (!found.isPresent()) continue;
            return found;
        }
        return Optional.empty();
    }

    private void doProcessBean(BeanManager bm, ProcessBean<?> pb) {
        Bean bean = pb.getBean();
        CdiServiceId id = new CdiServiceId(bean.getBeanClass(), bean.hashCode());
        if (this.processedBeans.add(id)) {
            this.addCdiBean(bm, new CdiBean(id, bean, pb.getAnnotated()));
        }
    }

    private Optional<Qualifier> namedQualifier(Set<Qualifier> qualifiers) {
        for (Qualifier qualifier : qualifiers) {
            if (!qualifier.typeName().equals((Object)Service.Named.TYPE)) continue;
            return Optional.of(qualifier);
        }
        return Optional.empty();
    }

    private boolean invalidContract(ResolvedType contract) {
        if (contract.type().equals((Object)TypeNames.OBJECT)) {
            return true;
        }
        return this.hasWildcard(contract.type()) || this.hasGeneric(contract.type());
    }

    private boolean hasWildcard(TypeName type) {
        if (type.wildcard()) {
            return true;
        }
        if (!type.typeArguments().isEmpty()) {
            for (TypeName typeArgument : type.typeArguments()) {
                if (!this.hasWildcard(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasGeneric(TypeName type) {
        if (type.generic()) {
            return true;
        }
        if (!type.typeArguments().isEmpty()) {
            for (TypeName typeArgument : type.typeArguments()) {
                if (!this.hasGeneric(typeArgument)) continue;
                return true;
            }
        }
        return false;
    }

    private Optional<TypeName> toRegistryScope(Class<? extends java.lang.annotation.Annotation> scope) {
        if (scope == ApplicationScoped.class) {
            return Optional.of(Service.Singleton.TYPE);
        }
        if (scope == Singleton.class) {
            return Optional.of(Service.Singleton.TYPE);
        }
        if (scope == RequestScoped.class) {
            return Optional.of(Service.PerRequest.TYPE);
        }
        if (scope == Dependent.class) {
            return Optional.of(Service.PerLookup.TYPE);
        }
        return Optional.empty();
    }

    private Class<? extends java.lang.annotation.Annotation> toCdiScope(ServiceInfo service) {
        TypeName scope = service.scope();
        if (scope.equals((Object)Service.Singleton.TYPE)) {
            return ApplicationScoped.class;
        }
        if (scope.equals((Object)Service.PerLookup.TYPE)) {
            return Dependent.class;
        }
        if (scope.equals((Object)Service.PerRequest.TYPE)) {
            return RequestScoped.class;
        }
        return Dependent.class;
    }

    private void addServiceInfo(AfterBeanDiscovery abd, BeanManager bm, ServiceRegistry registry, Set<UniqueBean> processedTypes, ServiceInfo service) {
        Set contracts = service.contracts();
        TypeName serviceType = service.serviceType();
        HashSet<ResolvedType> usedContracts = new HashSet<ResolvedType>();
        for (ResolvedType contract : contracts) {
            UniqueBean uniqueBean = new UniqueBean(contract, service.qualifiers());
            if (!processedTypes.add(uniqueBean) || this.invalidContract(contract)) continue;
            usedContracts.add(contract);
        }
        TypeName serviceProvidedType = service.providedType();
        ResolvedType serviceProvidedResolved = ResolvedType.create((TypeName)serviceProvidedType);
        if (processedTypes.add(new UniqueBean(serviceProvidedResolved, service.qualifiers())) && !this.invalidContract(serviceProvidedResolved)) {
            usedContracts.add(serviceProvidedResolved);
        }
        Class beanClass = TypeFactory.toClass((TypeName)serviceProvidedType);
        AnnotatedType annotatedType = abd.getAnnotatedType(beanClass, serviceProvidedType.fqName());
        Optional<Qualifier> named = this.namedQualifier(service.qualifiers());
        Set<Type> typeClosure = this.toTypes(usedContracts);
        Class<? extends java.lang.annotation.Annotation> cdiScope = this.toCdiScope(service);
        if (named.isEmpty()) {
            if (!typeClosure.isEmpty()) {
                this.addBean(abd, serviceType, beanClass, typeClosure, cdiScope, "").createWith(ctx -> {
                    Object instance = registry.get(serviceProvidedType);
                    return this.interceptInstance(bm, beanClass, (AnnotatedType<?>)annotatedType, (CreationalContext)ctx, instance);
                });
            }
        } else if ("*".equals(named.get().value().orElse("*"))) {
            Lookup lookup = ((Lookup.Builder)((Lookup.Builder)Lookup.builder().addContract(serviceProvidedType)).serviceType(serviceType)).build();
            List instances = registry.lookupInstances(lookup);
            HashSet<String> names = new HashSet<String>();
            for (ServiceInstance instance : instances) {
                String name = this.namedQualifier(instance.qualifiers()).flatMap(rec$ -> ((Qualifier)rec$).stringValue()).orElse("@default");
                if (!names.add(name)) continue;
                this.addNamedBean(bm, abd, annotatedType, serviceType, beanClass, typeClosure, cdiScope, name, (Supplier<Object>)instance);
            }
        } else {
            String name = (String)named.get().stringValue().orElseThrow();
            this.addNamedBean(bm, abd, annotatedType, serviceType, beanClass, typeClosure, cdiScope, name, () -> registry.get(((Lookup.Builder)((Lookup.Builder)Lookup.builder().addQualifier((Qualifier)named.get())).addContract(serviceProvidedType)).build()));
        }
    }

    private record CdiProducer(TypeName beanType, Type contract, Set<java.lang.annotation.Annotation> annotations, Set<Qualifier> qualifiers) {
    }

    private static class CdiBeanDescriptor
    implements ServiceDescriptor<Object> {
        private static final TypeName DESCRIPTOR_TYPE = TypeName.create(CdiBeanDescriptor.class);
        private final TypeName serviceType;
        private final Set<ResolvedType> contracts;
        private final Set<Qualifier> qualifiers;
        private final Bean<?> bean;
        private final BeanManager bm;
        private final Type theType;
        private final double weight;
        private final TypeName scope;

        CdiBeanDescriptor(BeanManager bm, CdiBean cdiBean, Type contract, TypeName scope) {
            this.bm = bm;
            this.bean = cdiBean.bean();
            this.scope = scope;
            this.theType = contract;
            this.serviceType = TypeName.create((Type)this.bean.getBeanClass());
            this.weight = Weights.find((Class)this.bean.getBeanClass(), (double)110.0);
            this.contracts = Set.of(ResolvedType.create((Type)contract));
            this.qualifiers = ServiceRegistryExtension.findRegistryQualifiers(cdiBean.annotated().getAnnotations());
        }

        public TypeName serviceType() {
            return this.serviceType;
        }

        public TypeName descriptorType() {
            return DESCRIPTOR_TYPE;
        }

        public Set<ResolvedType> contracts() {
            return this.contracts;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public Object instantiate(DependencyContext ctx, InterceptionMetadata interceptionMetadata) {
            return this.bm.getReference(this.bean, this.theType, this.bm.createCreationalContext(this.bean));
        }

        public TypeName scope() {
            return this.scope;
        }

        public double weight() {
            return this.weight;
        }

        public String toString() {
            return "CDI bean descriptor for: Contract: " + this.theType.getTypeName() + "; bean: " + this.serviceType.fqName() + " (" + this.weight + ")";
        }
    }

    private static class CdiProducerDescriptor
    implements ServiceDescriptor<Object> {
        private static final TypeName DESCRIPTOR_TYPE = TypeName.create(CdiProducerDescriptor.class);
        private final TypeName serviceType;
        private final Set<ResolvedType> contracts;
        private final Set<Qualifier> qualifiers;
        private final BeanManager bm;
        private final Type theType;
        private final TypeName scope;
        private final java.lang.annotation.Annotation[] cdiQualifiers;

        CdiProducerDescriptor(BeanManager bm, TypeName scope, CdiProducer producer, java.lang.annotation.Annotation[] cdiQualifiers) {
            this.bm = bm;
            this.scope = scope;
            this.theType = producer.contract();
            this.serviceType = producer.beanType();
            this.contracts = Set.of(ResolvedType.create((Type)producer.contract()));
            this.qualifiers = producer.qualifiers();
            this.cdiQualifiers = cdiQualifiers;
        }

        public TypeName serviceType() {
            return this.serviceType;
        }

        public TypeName descriptorType() {
            return DESCRIPTOR_TYPE;
        }

        public Set<ResolvedType> contracts() {
            return this.contracts;
        }

        public Set<Qualifier> qualifiers() {
            return this.qualifiers;
        }

        public Object instantiate(DependencyContext ctx, InterceptionMetadata interceptionMetadata) {
            Set beans = this.bm.getBeans(this.theType, this.cdiQualifiers);
            if (beans.isEmpty()) {
                throw new ServiceRegistryException("CDI did not provide any beans for producer. Bean: " + this.serviceType().fqName() + "; type: " + String.valueOf(this.theType));
            }
            Bean bean = (Bean)beans.iterator().next();
            return this.bm.getReference(bean, this.theType, this.bm.createCreationalContext((Contextual)bean));
        }

        public TypeName scope() {
            return this.scope;
        }

        public double weight() {
            return 110.0;
        }

        public String toString() {
            return "CDI producer descriptor for: Contract: " + this.theType.getTypeName() + "; producer: " + this.serviceType.fqName();
        }
    }

    private record CdiBean(CdiServiceId id, Bean<?> bean, Annotated annotated) {
    }

    private record CdiServiceId(Class<?> beanClass, int hash) {
    }

    private record UniqueBean(ResolvedType contract, Set<Qualifier> qualifiers) {
    }
}

