/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.microprofile.config.MpConfigBuilder;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;

public class MpConfigProviderResolver
extends ConfigProviderResolver {
    private static final Map<ClassLoader, Config> CONFIGS = new IdentityHashMap<ClassLoader, Config>();
    private static final ReadWriteLock RW_LOCK = new ReentrantReadWriteLock();

    public Config getConfig() {
        return this.getConfig(Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Config getConfig(ClassLoader loader) {
        if (null == loader) {
            loader = ClassLoader.getSystemClassLoader();
        }
        Lock lock = RW_LOCK.readLock();
        try {
            lock.lock();
            Config config = CONFIGS.get(loader);
            if (null == config) {
                lock.unlock();
                lock = RW_LOCK.writeLock();
                lock.lock();
                Config c = this.buildConfig(loader);
                this.doRegisterConfig(c, loader);
                Config config2 = c;
                return config2;
            }
            Config config3 = config;
            return config3;
        }
        finally {
            lock.unlock();
        }
    }

    private Config buildConfig(ClassLoader loader) {
        return this.getBuilder().forClassLoader(loader).addDefaultSources().addDiscoveredSources().addDiscoveredConverters().build();
    }

    public ConfigBuilder getBuilder() {
        return new MpConfigBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerConfig(Config config, ClassLoader classLoader) {
        Lock lock = RW_LOCK.writeLock();
        try {
            lock.lock();
            this.doRegisterConfig(config, classLoader);
        }
        finally {
            lock.unlock();
        }
    }

    private void doRegisterConfig(Config config, ClassLoader classLoader) {
        CONFIGS.put(classLoader, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConfig(Config config) {
        Lock lock = RW_LOCK.readLock();
        AtomicReference<ClassLoader> cl = new AtomicReference<ClassLoader>();
        try {
            lock.lock();
            for (Map.Entry<ClassLoader, Config> entry : CONFIGS.entrySet()) {
                Config configFromRef = entry.getValue();
                if (config != configFromRef) continue;
                cl.set(entry.getKey());
                break;
            }
        }
        finally {
            lock.unlock();
        }
        if (cl.get() != null) {
            lock = RW_LOCK.writeLock();
            try {
                lock.lock();
                CONFIGS.remove(cl.get());
            }
            finally {
                lock.unlock();
            }
        }
    }
}

