/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigMappingException;
import io.helidon.config.ConfigSources;
import io.helidon.config.MissingValueException;
import io.helidon.microprofile.config.MpConfigBuilder;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public final class MpConfig
implements org.eclipse.microprofile.config.Config {
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!\\\\),");
    private final Supplier<Config> config;
    private final List<ConfigSource> mpConfigSources;
    private final Iterable<String> propertyNames;
    private final Map<Class<?>, Converter<?>> converters;
    private final AtomicReference<Config> helidonConverter;

    MpConfig(Config config, List<ConfigSource> mpConfigSources, Map<Class<?>, Converter<?>> converters) {
        AtomicReference<Config> ref = new AtomicReference<Config>(config);
        config.onChange(ref::set);
        this.config = ref::get;
        this.mpConfigSources = mpConfigSources;
        this.propertyNames = Stream.concat(mpConfigSources.stream().flatMap(cs -> cs.getPropertyNames().stream()), config.traverse().filter(Config::isLeaf).map(Config::key).map(Config.Key::toString)).collect(Collectors.toSet());
        this.converters = converters;
        this.helidonConverter = new AtomicReference();
    }

    public static MpConfigBuilder builder() {
        return new MpConfigBuilder();
    }

    static String[] toArray(String stringValue) {
        String[] values = SPLIT_PATTERN.split(stringValue, -1);
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            values[i] = value.replace("\\,", ",");
        }
        return values;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        try {
            if (propertyType.isArray()) {
                Class<?> element = propertyType.getComponentType();
                return (T)this.findArrayValue(propertyName, element);
            }
            return this.findValue(propertyName, propertyType);
        }
        catch (MissingValueException e) {
            throw new NoSuchElementException(e.getMessage());
        }
        catch (ConfigMappingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> Set<T> asSet(String propertyName, Class<T> typeArg) {
        return new HashSet<T>(this.asList(propertyName, typeArg));
    }

    public <T> List<T> asList(String propertyName, Class<T> typeArg) {
        if (typeArg == Config.class) {
            return (List)this.config.get().get(propertyName).asList(typeArg).get();
        }
        return this.findInMpSources(propertyName).map(value -> this.toList((String)value, typeArg)).orElseGet(() -> (List)this.config.get().get(propertyName).asList(typeArg).get());
    }

    private <T> List<T> toList(String value, Class<T> elementType) {
        String[] valueArray = MpConfig.toArray(value);
        ArrayList<T> result = new ArrayList<T>();
        for (String element : valueArray) {
            result.add(this.convert(elementType, element));
        }
        return result;
    }

    <T> T findValue(String propertyName, Class<T> propertyType) {
        if (propertyType == Config.class) {
            return (T)this.config.get().get(propertyName).as(propertyType).get();
        }
        return (T)this.findInMpSources(propertyName).map(value -> this.convert(propertyType, (String)value)).orElseGet(() -> this.config.get().get(propertyName).as(propertyType).get());
    }

    private Object findArrayValue(String propertyName, Class<?> element) {
        return this.findInMpSources(propertyName).map(value -> this.asArray((String)value, element)).orElseGet(() -> {
            Config arrayConfig = this.config.get().get(propertyName);
            if (arrayConfig.isLeaf()) {
                return this.asArray((String)arrayConfig.asString().get(), element);
            }
            List objects = (List)arrayConfig.asList(element).get();
            Object array = Array.newInstance(element, objects.size());
            for (int i = 0; i < objects.size(); ++i) {
                Array.set(array, i, objects.get(i));
            }
            return array;
        });
    }

    private Object asArray(String value, Class<?> element) {
        String[] valueArray = MpConfig.toArray(value);
        Object array = Array.newInstance(element, valueArray.length);
        for (int i = 0; i < valueArray.length; ++i) {
            Array.set(array, i, this.convert(element, valueArray[i]));
        }
        return array;
    }

    private Optional<String> findInMpSources(String propertyName) {
        ConfigSource source;
        String propertyValue = null;
        Iterator<ConfigSource> iterator = this.mpConfigSources.iterator();
        while (iterator.hasNext() && null == (propertyValue = (source = iterator.next()).getValue(propertyName))) {
        }
        return Optional.ofNullable(propertyValue);
    }

    public <T> T value(String propertyName, Class<T> propertyType, T defaultValue) {
        return this.getOptionalValue(propertyName, propertyType).orElse(defaultValue);
    }

    public <T> T valueWithDefault(String propertyName, Class<T> propertyType, String defaultValue) {
        return this.getOptionalValue(propertyName, propertyType).orElse(this.convert(propertyType, defaultValue));
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        try {
            return Optional.of(this.getValue(propertyName, propertyType));
        }
        catch (NoSuchElementException e) {
            return Optional.empty();
        }
        catch (ConfigMappingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Iterable<String> getPropertyNames() {
        return this.propertyNames;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.mpConfigSources;
    }

    public <T> T convert(Class<T> type, String value) {
        if (null == value) {
            return null;
        }
        Converter<?> converter = this.converters.get(type);
        if (null != converter) {
            return (T)converter.convert(value);
        }
        if (type == String.class) {
            return (T)value;
        }
        if (type.isArray()) {
            return (T)this.asArray(value, type.getComponentType());
        }
        Config c = this.helidonConverter();
        try {
            return (T)c.convert(type, value);
        }
        catch (ConfigMappingException e) {
            throw new IllegalArgumentException("Failed to convert " + value + " to " + type.getName(), e);
        }
    }

    private Config helidonConverter() {
        Config converter = this.helidonConverter.get();
        if (converter == null) {
            converter = Config.builder().disableSystemPropertiesSource().disableFilterServices().disableEnvironmentVariablesSource().sources((Supplier)ConfigSources.empty()).build();
            this.helidonConverter.set(converter);
        }
        return converter;
    }

    public Config helidonConfig() {
        return this.config.get();
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>((Map)this.config.get().asMap().get());
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>(this.mpConfigSources);
        Collections.reverse(configSources);
        for (ConfigSource configSource : configSources) {
            map.putAll(configSource.getProperties());
        }
        return map;
    }

    public String toString() {
        return "microprofileConfig: " + this.config;
    }
}

